/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.controlchart;

import com.macrofocus.coloring.MutableColoring;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.filter.Filter;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.high_d.axis.AbstractAxisModel;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.group.DefaultAxisGroupModel;
import com.macrofocus.high_d.controlchart.AxisModelsDataFrame;
import com.macrofocus.high_d.scatterplot.AbstractScatterPlotModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.dataframe.DataFrameHelper;
import com.macrofocus.molap.dataframe.DataFrameListener;
import com.macrofocus.molap.dataframe.math.DataFrameRealMatrix;
import com.macrofocus.molap.subset.OrdinalDimension;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import com.macrofocus.visual.Visual;
import com.macrofocus.visual.VisualObjects;
import java.util.Iterator;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.linear.BlockRealMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.commons.math3.linear.RealMatrix;

public class ControlChartScatterPlotModel<Color, Row, C>
extends AbstractScatterPlotModel<Color, Row, C>
implements VisualObjects<Row> {
    private final DataFrame<Row, C, ?> dataFrame;
    private final DataFrame<?, C, ?> annotationDataFrame;
    private final Visual<Color, Row, C> visual;
    private final AxisGroupModel<Row, C> axisGroupModel;
    private final MutableSingleSelection<AxisModel<Row, C>> x = new SimpleSingleSelection();
    private final MutableSingleSelection<AxisModel<Row, C>> y = new SimpleSingleSelection();
    private final MutableSingleSelection<AxisModel> size = new SimpleSingleSelection();
    private final AxisModelsDataFrame<Row, C> axisModelsDataFrame;
    private RealMatrix inverseCovarianceMatrix;
    private RealMatrix deviationFromMean;
    private Number max = null;
    T2AxisModel yAxisModel = new T2AxisModel();

    public ControlChartScatterPlotModel(CPFactory factory, ColorMapFactory<Color> colorMapFactory, DataFrame<Row, C, ?> dataFrame) {
        this(factory, dataFrame, (Visual<Color, Row, C>)new SimpleVisual((VisualObjects)new SimpleVisualObjects(dataFrame), (MutableColorMapping)new SimpleColorMapping(colorMapFactory, dataFrame)));
    }

    public ControlChartScatterPlotModel(CPFactory factory, DataFrame<Row, C, ?> dataFrame, Visual<Color, Row, C> visual) {
        this(dataFrame, null, visual, (AxisGroupModel<Row, C>)new DefaultAxisGroupModel(factory, "Root", dataFrame, null, (SingleSelection)visual.getProbing(), (Selection)visual.getSelection(), (MutableFilter)visual.getFilter()));
    }

    public ControlChartScatterPlotModel(DataFrame<Row, C, ?> dataFrame, DataFrame<?, C, ?> annotationDataFrame, Visual<Color, Row, C> visual, AxisGroupModel<Row, C> axisGroupModel) {
        this.dataFrame = dataFrame;
        this.annotationDataFrame = annotationDataFrame;
        this.visual = visual;
        this.axisGroupModel = axisGroupModel;
        this.x.setSelected((Object)((AxisModel)axisGroupModel.getAxisOrder().get(0)));
        this.y.setSelected((Object)this.yAxisModel);
        this.x.addSingleSelectionListener(new SingleSelectionListener<AxisModel<Row, C>>(){

            public void selectionChanged(SingleSelectionEvent<AxisModel<Row, C>> event) {
                AxisModel xAxisModel = (AxisModel)event.getCurrentSelection();
                ControlChartScatterPlotModel.this.fireScatterPlotChanged();
            }
        });
        this.y.addSingleSelectionListener(new SingleSelectionListener<AxisModel<Row, C>>(){

            public void selectionChanged(SingleSelectionEvent<AxisModel<Row, C>> event) {
                AxisModel yAxisModel = (AxisModel)event.getCurrentSelection();
                ControlChartScatterPlotModel.this.fireScatterPlotChanged();
            }
        });
        this.size.addSingleSelectionListener((SingleSelectionListener)new SingleSelectionListener<AxisModel>(){

            public void selectionChanged(SingleSelectionEvent<AxisModel> event) {
                AxisModel sizeAxisModel = (AxisModel)event.getCurrentSelection();
                ControlChartScatterPlotModel.this.fireScatterPlotChanged();
            }
        });
        this.axisModelsDataFrame = new AxisModelsDataFrame<Row, C>(dataFrame, axisGroupModel, this.x);
        DataFrameRealMatrix matrix = new DataFrameRealMatrix(this.axisModelsDataFrame);
        this.axisModelsDataFrame.addDataFrameListener(new DataFrameListener<Row, AxisModel<Row, C>>(){
            final /* synthetic */ RealMatrix val$matrix;
            {
                this.val$matrix = realMatrix;
            }

            public void dataFrameChanged(DataFrameEvent<Row, AxisModel<Row, C>> event) {
                ControlChartScatterPlotModel.this.update(this.val$matrix);
            }
        });
        this.update((RealMatrix)matrix);
    }

    public void update(RealMatrix matrix) {
        try {
            RealMatrix covariance = this.computeCovarianceMatrix(matrix, true);
            try {
                this.inverseCovarianceMatrix = MatrixUtils.inverse((RealMatrix)covariance);
            }
            catch (NonSquareMatrixException e) {
                e.printStackTrace();
                this.inverseCovarianceMatrix = null;
            }
            this.deviationFromMean = matrix.copy();
            for (int i = 0; i < this.deviationFromMean.getColumnDimension(); ++i) {
                double mean = this.mean(this.deviationFromMean.getColumn(i));
                for (int j = 0; j < this.deviationFromMean.getRowDimension(); ++j) {
                    this.deviationFromMean.addToEntry(j, i, -mean);
                }
            }
            Number max = null;
            for (Object row : this.axisModelsDataFrame.rows()) {
                double v;
                Number t2 = this.computeT2(row);
                if (max == null) {
                    max = t2;
                    continue;
                }
                if (t2 == null || Double.isNaN(v = t2.doubleValue()) || !(v > max.doubleValue())) continue;
                max = t2;
            }
            this.max = max;
            this.yAxisModel.fireAxisChanged();
            this.fireScatterPlotChanged();
        }
        catch (MathIllegalArgumentException e) {
            this.max = null;
        }
    }

    protected double mean(double[] values) {
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < values.length; ++i) {
            double value = values[i];
            if (Double.isNaN(value)) continue;
            sum += value;
            ++count;
        }
        return sum / (double)count;
    }

    protected double variance(double[] values, boolean isBiasCorrected) {
        return this.variance(values, this.mean(values), isBiasCorrected);
    }

    protected double variance(double[] values, double mean, boolean isBiasCorrected) {
        int count = 0;
        double accum = 0.0;
        double dev = 0.0;
        double accum2 = 0.0;
        for (int i = 0; i < values.length; ++i) {
            double value = values[i];
            if (Double.isNaN(value)) continue;
            ++count;
            dev = value - mean;
            accum += dev * dev;
            accum2 += dev;
        }
        double len = count;
        if (isBiasCorrected) {
            return (accum - accum2 * accum2 / len) / (len - 1.0);
        }
        return (accum - accum2 * accum2 / len) / len;
    }

    protected RealMatrix computeCovarianceMatrix(RealMatrix matrix, boolean biasCorrected) throws MathIllegalArgumentException {
        int dimension = matrix.getColumnDimension();
        BlockRealMatrix outMatrix = new BlockRealMatrix(dimension, dimension);
        for (int i = 0; i < dimension; ++i) {
            for (int j = 0; j < i; ++j) {
                double cov = this.covariance(matrix.getColumn(i), matrix.getColumn(j), biasCorrected);
                outMatrix.setEntry(i, j, cov);
                outMatrix.setEntry(j, i, cov);
            }
            outMatrix.setEntry(i, i, this.variance(matrix.getColumn(i), biasCorrected));
        }
        return outMatrix;
    }

    public double covariance(double[] xArray, double[] yArray, boolean biasCorrected) throws MathIllegalArgumentException {
        double result = 0.0;
        int length = xArray.length;
        if (length != yArray.length) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, new Object[]{length, yArray.length});
        }
        if (length < 2) {
            throw new MathIllegalArgumentException((Localizable)LocalizedFormats.INSUFFICIENT_OBSERVED_POINTS_IN_SAMPLE, new Object[]{length, 2});
        }
        double xMean = this.mean(xArray);
        double yMean = this.mean(yArray);
        int count = 0;
        for (int i = 0; i < length; ++i) {
            double xDev = xArray[i] - xMean;
            double yDev = yArray[i] - yMean;
            if (Double.isNaN(xDev) || Double.isNaN(yDev)) continue;
            result += (xDev * yDev - result) / (double)(++count);
        }
        return biasCorrected ? result * ((double)count / (double)(count - 1)) : result;
    }

    public Number computeT2(Row row) {
        RealMatrix d = this.deviationFromMean.getRowMatrix(this.dataFrame.getRowAddress(row));
        RealMatrix transposed = d.transpose();
        RealMatrix t2 = d.multiply(this.inverseCovarianceMatrix).multiply(transposed);
        double value = t2.getEntry(0, 0);
        return value;
    }

    @Override
    public Visual<Color, Row, C> getVisual() {
        return this.visual;
    }

    @Override
    public AxisGroupModel getAxisGroupModel() {
        return this.axisGroupModel;
    }

    @Override
    public MutableSingleSelection<Row> getProbing() {
        return this.visual.getProbing();
    }

    @Override
    public MutableSelection<Row> getSelection() {
        return this.visual.getSelection();
    }

    @Override
    public Filter<Row> getFilter() {
        return this.visual.getFilter();
    }

    @Override
    public MutableColorMapping<Color, Row, C> getColorMapping() {
        return this.visual.getColorMapping();
    }

    @Override
    public MutableColoring<Color, Row> getColoring() {
        return this.visual.getColoring();
    }

    @Override
    public int getObjectCount() {
        return this.visual.getVisualObjects().getObjectCount();
    }

    @Override
    public Row getObject(int index) {
        return (Row)this.visual.getVisualObjects().getObject(index);
    }

    @Override
    public AxisModel getXAxisModel() {
        return (AxisModel)this.x.getSelected();
    }

    @Override
    public AxisModel getY2AxisModel() {
        return null;
    }

    @Override
    public AxisModel getYAxisModel() {
        return (AxisModel)this.y.getSelected();
    }

    @Override
    public AxisModel getSizeAxisModel() {
        return (AxisModel)this.size.getSelected();
    }

    @Override
    public MutableSingleSelection<AxisModel<Row, C>> getX() {
        return this.x;
    }

    @Override
    public MutableSingleSelection<AxisModel<Row, C>> getY() {
        return this.y;
    }

    @Override
    public MutableSingleSelection<AxisModel<Row, C>> getY2() {
        return null;
    }

    @Override
    public MutableSingleSelection<AxisModel> getSize() {
        return this.size;
    }

    @Override
    public DataFrame getDataFrame() {
        return this.dataFrame;
    }

    @Override
    public DataFrame getAnnotationDataFrame() {
        return null;
    }

    private class T2AxisModel
    extends AbstractAxisModel<Row, C> {
        private T2AxisModel() {
        }

        public void fireAxisChanged() {
            super.fireAxisChanged();
        }

        protected String getFormattedValue(double value) {
            return null;
        }

        public MutableProperty<Boolean> getButtonModel() {
            return null;
        }

        public boolean isNumerical() {
            return true;
        }

        public String getName() {
            return "T2";
        }

        public Number getValue(Row row) {
            return ControlChartScatterPlotModel.this.computeT2(row);
        }

        public Number getValue(int layer, Row row) {
            if (layer == 0) {
                return this.getValue(row);
            }
            return null;
        }

        public double getMinimum() {
            return 0.0;
        }

        public double getMean() {
            return 0.0;
        }

        public double getStdDev() {
            return 0.0;
        }

        public double getMaximum() {
            return ControlChartScatterPlotModel.this.max.doubleValue();
        }

        public boolean isDegenerate() {
            return ControlChartScatterPlotModel.this.max != null;
        }

        public int getRowCount() {
            return ControlChartScatterPlotModel.this.visual.getVisualObjects().getObjectCount();
        }

        public Row getRow(int row) {
            return ControlChartScatterPlotModel.this.visual.getVisualObjects().getObject(row);
        }

        public SingleSelection<Row> getProbing() {
            return ControlChartScatterPlotModel.this.visual.getProbing();
        }

        public Selection<Row> getSelection() {
            return ControlChartScatterPlotModel.this.visual.getSelection();
        }

        public MutableFilter<Row> getFilter() {
            return ControlChartScatterPlotModel.this.visual.getFilter();
        }

        public void setMinimum(double min) {
        }

        public void setMaximum(double max) {
        }

        public void setMinMax(double min, double max) {
        }

        public DataFrameHelper.ColumnStatistics getColumnStatistics() {
            return null;
        }

        public MutableBoundedInterval getInterval() {
            return null;
        }

        public MutableBoundedInterval getScaledInterval() {
            return null;
        }

        public Class getType() {
            return Number.class;
        }

        public C getColumn() {
            return null;
        }

        public String getFormattedMinimum() {
            return null;
        }

        public String getFormattedMaximum() {
            return null;
        }

        public String getFormattedValue(Row row) {
            return null;
        }

        public String getFormattedValue(int layer, Row row) {
            return null;
        }

        public OrdinalDimension getDimension() {
            return null;
        }

        public Object getOriginalFloorValue(double value) {
            return null;
        }

        public Object getOriginalCeilValue(double value) {
            return null;
        }

        public Iterator<Row> iterator() {
            return null;
        }
    }
}

