/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.distributions;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.high_d.distributions.Distributions;
import com.macrofocus.high_d.distributions.DistributionsController;
import com.macrofocus.high_d.distributions.DistributionsModel;
import com.macrofocus.high_d.distributions.DistributionsView;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;

public abstract class AbstractDistributions<Component, Color, Row, Column, Value, Bin>
implements Distributions<Component, Color, Row, Column, Value, Bin> {
    protected static LicenseModel licenseModel;
    private DistributionsModel<Color, Row, Column, Value, Bin> model;
    protected DistributionsView<Component, Color, Row, Column, Value, Bin> view;
    protected DistributionsController controller;

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.HIGHD_API_V1, username, key);
    }

    protected void load(DataFrame dataFrame) {
        this.setModel(this.createModel(dataFrame));
    }

    @Override
    public DistributionsModel<Color, Row, Column, Value, Bin> getModel() {
        return this.model;
    }

    @Override
    public void setModel(DistributionsModel<Color, Row, Column, Value, Bin> model) {
        if (this.model != model) {
            this.model = model;
            if (this.view != null) {
                this.view.setModel(model);
            }
        }
    }

    @Override
    public DistributionsView<Component, Color, Row, Column, Value, Bin> getView() {
        return this.view;
    }

    @Override
    public void setView(DistributionsView<Component, Color, Row, Column, Value, Bin> view) {
        if (this.view != view) {
            if (this.view != null) {
                this.view.setModel(null);
            }
            this.view = view;
            if (view != null) {
                view.setModel(this.model);
                this.view.setLicenseModel(licenseModel);
            }
        }
    }

    @Override
    public DistributionsController getController() {
        return this.controller;
    }

    @Override
    public void setController(DistributionsController controller) {
        if (this.controller != controller) {
            if (this.controller != null) {
                this.controller.setView(null);
            }
            this.controller = controller;
            if (controller != null) {
                controller.setView(this.view);
            }
        }
    }

    protected abstract DistributionsModel<Color, Row, Column, Value, Bin> createModel(DataFrame var1);

    protected abstract DistributionsView<Component, Color, Row, Column, ?, ?> createView();

    protected abstract DistributionsController createController(DistributionsView var1);
}

