/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.distributions;

import com.macrofocus.filter.Filter;
import com.macrofocus.high_d.distributions.Histogram;
import java.util.ArrayList;
import java.util.List;

public class FixedBinsHistogram<R>
implements Histogram<R> {
    private final int numberOfBins;
    private final double minValue;
    private final double maxValue;
    private int maxCount = 0;
    private int activeMaxCount = 0;
    private final int[] bins;
    private int underflowBin = 0;
    private int overflowBin = 0;
    private final List<R>[] activeBins;
    private final List<R> activeUnderflowBin = new ArrayList<R>();
    private final List<R> activeOverflowBin = new ArrayList<R>();
    private final Filter<R> filter;

    public FixedBinsHistogram(int nbins, double min, double max, Filter<R> filter) {
        this.numberOfBins = nbins;
        this.minValue = min;
        this.maxValue = max;
        this.bins = new int[this.numberOfBins];
        this.activeBins = new List[this.numberOfBins];
        for (int i = 0; i < this.activeBins.length; ++i) {
            this.activeBins[i] = new ArrayList<R>();
        }
        this.filter = filter;
    }

    public void addValue(R row, double value) {
        if (this.numberOfBins <= 0) {
            return;
        }
        int bin = this.getBin(value);
        if (bin < 0) {
            switch (bin) {
                case -1: {
                    ++this.underflowBin;
                    break;
                }
                case -2: {
                    ++this.overflowBin;
                }
            }
        } else {
            int n = bin;
            this.bins[n] = this.bins[n] + 1;
            if (this.bins[bin] > this.maxCount) {
                this.maxCount = this.bins[bin];
            }
        }
        if (!this.filter.isFiltered(row)) {
            if (bin < 0) {
                switch (bin) {
                    case -1: {
                        this.activeUnderflowBin.add(row);
                        break;
                    }
                    case -2: {
                        this.activeOverflowBin.add(row);
                    }
                }
            } else {
                this.activeBins[bin].add(row);
                if (this.activeBins[bin].size() > this.activeMaxCount) {
                    this.activeMaxCount = this.activeBins[bin].size();
                }
            }
        }
    }

    @Override
    public int getActiveDensity(int index) {
        return this.activeBins[index].size();
    }

    @Override
    public R getActiveRowAtBin(int j, int index) {
        return this.activeBins[j].get(index);
    }

    @Override
    public int getDensity(int index) {
        return this.bins[index];
    }

    @Override
    public int getNumberOfBins() {
        return this.numberOfBins;
    }

    @Override
    public double getMinValue() {
        return this.minValue;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public double getBinStartValue(int bin) {
        return (double)bin * ((this.maxValue - this.minValue) / (double)this.numberOfBins) + this.minValue;
    }

    @Override
    public double getBinEndValue(int bin) {
        return (double)(bin + 1) * ((this.maxValue - this.minValue) / (double)this.numberOfBins) + this.minValue;
    }

    @Override
    public int getMaxActiveDensity() {
        return this.activeMaxCount;
    }

    @Override
    public int getMaxDensity() {
        return this.maxCount;
    }

    public int getUnderflowBin() {
        return this.underflowBin;
    }

    public int getOverflowBin() {
        return this.overflowBin;
    }

    @Override
    public int getBin(double value) {
        if (value < this.minValue) {
            return -1;
        }
        if (value > this.maxValue) {
            return -2;
        }
        if (value == this.maxValue) {
            return this.numberOfBins - 1;
        }
        if (value == this.minValue) {
            return 0;
        }
        return (int)((value - this.minValue) / ((this.maxValue - this.minValue) / (double)this.numberOfBins));
    }

    public String toString() {
        Object content = "------\n";
        content = (String)content + this.getClass().getName() + "\n";
        content = (String)content + "   Number of bins: " + this.numberOfBins + "\n";
        content = (String)content + "   Min value:      " + this.minValue + "\n";
        content = (String)content + "   Max value:      " + this.maxValue + "\n";
        content = (String)content + "   Max count:      " + this.maxCount + "\n";
        content = (String)content + "   Underflow bin:  " + this.underflowBin + "\n";
        content = (String)content + "   Overflow bin:   " + this.overflowBin + "\n";
        return content;
    }
}

