/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.mds.distance;

import com.macrofocus.high_d.mds.distance.DistanceStrategy;
import com.macrofocus.molap.dataframe.matrix.vector.Vector;

public final class EuclideanDistanceStrategy<K>
implements DistanceStrategy<K> {
    @Override
    public double getDistance(Vector<K> vectorModel1, Vector<K> vectorModel2) {
        double difference = 0.0;
        int count = 0;
        int column1 = 0;
        for (int column2 = 0; column1 < vectorModel1.size() && column2 < vectorModel2.size(); ++column1, ++column2) {
            Object k1 = vectorModel1.getKey(column1);
            Object k2 = vectorModel1.getKey(column2);
            if (!vectorModel1.isAvailable(k1) || !vectorModel2.isAvailable(k2)) continue;
            double f = vectorModel1.getDouble(k1);
            double g = vectorModel2.getDouble(k2);
            double diff = this.getDistance(f, g);
            difference += diff * diff;
            ++count;
        }
        if (count == 0) {
            return Double.NaN;
        }
        double result = Math.sqrt(difference);
        return result;
    }

    private double getDistance(Object f, Object g) {
        if (f != null && g != null) {
            if (f instanceof Number && g instanceof Number) {
                return Math.abs(((Number)f).doubleValue() - ((Number)g).doubleValue());
            }
            if (f.equals(g)) {
                return 0.0;
            }
            return 1.0;
        }
        return 0.5;
    }

    private double getDistance(double f, double g) {
        return Math.abs(f - g);
    }
}

