/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.mds.spring;

import com.macrofocus.high_d.mds.AbstractMDSModel;
import com.macrofocus.high_d.mds.spring.SpringModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.matrix.SimpleMutableMatrix;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.IntegerRangeUniqueIndex;
import com.macrofocus.molap.index.UniqueIndex;
import java.util.Random;

public final class SimpleSpringModel
extends AbstractMDSModel
implements SpringModel {
    private final Random rand = new Random(123L);
    private double layoutBounds = 100.0;
    private final SimpleMutableMatrix matrix;
    private final UniqueIndex<Integer> rowIndex;
    private final UniqueIndex<String> columnIndex;

    public SimpleSpringModel(DataFrame datasetModel) {
        this(datasetModel.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            double radius = this.rand.nextDouble() * this.layoutBounds * 0.5;
            double azimuth = this.rand.nextDouble() * 360.0;
            double elevation = this.rand.nextDouble() * 180.0 - 90.0;
            double phi = azimuth / 180.0 * Math.PI;
            double theta = elevation / 180.0 * Math.PI;
            double x = radius * Math.cos(theta) * Math.cos(phi);
            double y = radius * Math.cos(theta) * Math.sin(phi);
            double z = radius * Math.sin(theta);
            this.setPosition(i, x, y, z);
        }
    }

    public SimpleSpringModel(int rowCount) {
        this.matrix = new SimpleMutableMatrix(rowCount, 10);
        this.rowIndex = new IntegerRangeUniqueIndex(0, rowCount - 1);
        this.columnIndex = new DefaultUniqueIndex((Object[])new String[]{"X", "Y", "Z", "W", "VelocityX", "VelocityY", "VelocityZ", "ForceX", "ForceY", "ForceZ"});
    }

    public Object getValueAt(int row, int column) {
        return this.matrix.getValueAt((Object)row, (Object)column);
    }

    public boolean isAvailable(int row, int column) {
        return this.matrix.isAvailable((Object)row, (Object)column);
    }

    public double getDouble(int row, int column) {
        return this.matrix.getDouble(Integer.valueOf(row), Integer.valueOf(column));
    }

    public void setDouble(int row, int column, double value) {
        this.matrix.setDouble(Integer.valueOf(row), Integer.valueOf(column), value);
    }

    @Override
    public int getRowCount() {
        return this.matrix.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.matrix.getColumnCount();
    }

    @Override
    public void setPosition(int row, double x, double y, double z) {
        this.setDouble(row, 0, x);
        this.setDouble(row, 1, y);
        this.setDouble(row, 2, z);
    }

    @Override
    public void setPosition(int row, double x, double y, double z, double w) {
        this.setDouble(row, 0, x);
        this.setDouble(row, 1, y);
        this.setDouble(row, 2, z);
        this.setDouble(row, 3, w);
    }

    @Override
    public void setVelocity(int row, double x, double y, double z) {
        this.setDouble(row, 4, x);
        this.setDouble(row, 5, y);
        this.setDouble(row, 6, z);
    }

    @Override
    public void setForce(int row, double x, double y, double z) {
        this.setDouble(row, 7, x);
        this.setDouble(row, 8, y);
        this.setDouble(row, 9, z);
    }

    @Override
    public void setForceY(int row, double y) {
        this.setDouble(row, 8, y);
    }

    @Override
    public void setForceZ(int row, double z) {
        this.setDouble(row, 9, z);
    }

    @Override
    public void addForce(int row, double x, double y, double z) {
        this.setDouble(row, 7, this.getForceX(row) + x);
        this.setDouble(row, 8, this.getForceY(row) + y);
        this.setDouble(row, 9, this.getForceZ(row) + z);
    }

    @Override
    public double getX(int row) {
        return this.getDouble(row, 0);
    }

    @Override
    public double getY(int row) {
        return this.getDouble(row, 1);
    }

    @Override
    public double getZ(int row) {
        return this.getDouble(row, 2);
    }

    @Override
    public double getW(int row) {
        return this.getDouble(row, 3);
    }

    @Override
    public double getVelocityX(int row) {
        return this.getDouble(row, 4);
    }

    @Override
    public double getVelocityY(int row) {
        return this.getDouble(row, 5);
    }

    @Override
    public double getVelocityZ(int row) {
        return this.getDouble(row, 6);
    }

    @Override
    public double getForceX(int row) {
        return this.getDouble(row, 7);
    }

    @Override
    public double getForceY(int row) {
        return this.getDouble(row, 8);
    }

    @Override
    public double getForceZ(int row) {
        return this.getDouble(row, 9);
    }

    @Override
    public Object getColumnName(int column) {
        return this.matrix.getColumnName((Object)column);
    }

    public int getColumnIndex(Object name) {
        int index = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equals(name)) continue;
            index = i;
        }
        return index;
    }

    public Class getColumnClass(int column) {
        return this.matrix.getColumnClass((Object)column);
    }

    public UniqueIndex<Integer> getRowIndex() {
        return this.rowIndex;
    }

    public UniqueIndex<String> getColumnIndex() {
        return this.columnIndex;
    }
}

