/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates;

import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperties;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.high_d.interaction.InteractionMode;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesController;
import java.util.Collection;

public abstract class AbstractParallelCoordinatesController<Component, Row, Column>
implements ParallelCoordinatesController<Component, Row, Column> {
    protected final DefaultMouseListener mouseListener = new DefaultMouseListener();
    private final MutableProperties properties = new SimpleProperties();
    protected MutableProperty<Boolean> reordering = this.properties.createProperty((Object)"reordering", (Object)Boolean.TRUE);
    protected MutableProperty<Boolean> reversing = this.properties.createProperty((Object)"reversing", (Object)Boolean.TRUE);
    private final boolean multipleSelectionEnabled = true;
    private final boolean selectOnPopupTrigger = false;
    private InteractionMode mode = InteractionMode.Selection;
    private Object locksmith = this;

    @Override
    public MutableProperty<Boolean> getReordering() {
        return this.reordering;
    }

    @Override
    public void setReordering(MutableProperty<Boolean> reordering) {
        this.reordering = reordering;
        this.properties.replaceProperty((Object)"reordering", reordering);
    }

    @Override
    public MutableProperty<Boolean> getReversing() {
        return this.reversing;
    }

    @Override
    public void setReversing(MutableProperty<Boolean> reversing) {
        this.reversing = reversing;
        this.properties.replaceProperty((Object)"reversing", reversing);
    }

    @Override
    public InteractionMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(InteractionMode mode) {
        this.mode = mode;
    }

    public Object getLocksmith() {
        return this.locksmith;
    }

    @Override
    public void setLocksmith(Object locksmith) {
        this.locksmith = locksmith;
    }

    private void removeFromSelection(Row observation) {
        this.getView().getModel().getSelection().setSelectedState(observation, false);
    }

    private void setSelection(Row observation) {
        if (observation != null) {
            this.getView().getModel().getSelection().setSelectedElements(new Object[]{observation});
        } else {
            this.getView().getModel().getSelection().clearSelection();
        }
    }

    private void addToSelection(Row observation) {
        this.getView().getModel().getSelection().setSelectedState(observation, true);
    }

    private void addToSelection(Collection<Row> newSelection) {
        this.getView().getModel().getSelection().setSelectedIterableState(newSelection, true);
    }

    public class DefaultMouseListener
    implements CPCanvas.MouseListener,
    CPCanvas.MouseMotionListener {
        private Point last;
        private Row selectOnRelease = null;
        private Point zoomOnRelease = null;
        private Point zoomingPoint = null;
        private Point pressedPoint = null;

        public void mouseClicked(CPCanvas.MouseEvent e) {
        }

        public void mousePressed(CPCanvas.MouseEvent event) {
            if (AbstractParallelCoordinatesController.this.getView() != null) {
                this.pressedPoint = new Point(event.getX(), event.getY());
                Object bestrow = AbstractParallelCoordinatesController.this.getView().getClosestRow(event.getX(), event.getY());
                switch (AbstractParallelCoordinatesController.this.getMode()) {
                    case Selection: {
                        if (bestrow != null) {
                            if (!event.isMultipleSelectionKey()) {
                                if (AbstractParallelCoordinatesController.this.getView().getModel().getSelection().isSelected(bestrow) && AbstractParallelCoordinatesController.this.getView().getModel().getSelection().getSelectedCount() <= 1) break;
                                AbstractParallelCoordinatesController.this.getView().getModel().getSelection().clearSelection();
                                AbstractParallelCoordinatesController.this.getView().getModel().getSelection().setSelected(bestrow);
                                AbstractParallelCoordinatesController.this.getView().setSelectionMode(AbstractParallelCoordinatesController.this.getView().getModel().getSelection().isSelected(bestrow));
                                break;
                            }
                            AbstractParallelCoordinatesController.this.getView().setSelectionMode(!AbstractParallelCoordinatesController.this.getView().getModel().getSelection().isSelected(bestrow));
                            if (AbstractParallelCoordinatesController.this.getView().isSelectionMode()) {
                                AbstractParallelCoordinatesController.this.getView().getModel().getSelection().setSelectedState(bestrow, true);
                                break;
                            }
                            AbstractParallelCoordinatesController.this.getView().getModel().getSelection().setSelectedState(bestrow, false);
                            break;
                        }
                        AbstractParallelCoordinatesController.this.getView().getModel().getSelection().clearSelection();
                        break;
                    }
                    case Toggle: {
                        boolean selected = AbstractParallelCoordinatesController.this.getView().getModel().getSelection().isSelected(bestrow);
                        AbstractParallelCoordinatesController.this.getView().getModel().getSelection().setSelectedState(bestrow, !selected);
                        break;
                    }
                    case Filter: {
                        boolean filtered = AbstractParallelCoordinatesController.this.getView().getModel().getFilter().isFilteredBy(bestrow, (Object)this);
                        AbstractParallelCoordinatesController.this.getView().getModel().getFilter().setFiltered(bestrow, !filtered, (Object)this);
                    }
                }
            }
        }

        public void mouseReleased(CPCanvas.MouseEvent event) {
            if (AbstractParallelCoordinatesController.this.getView() != null) {
                if (!event.isPopupTrigger()) {
                    switch (AbstractParallelCoordinatesController.this.getMode()) {
                        case Selection: {
                            if (this.selectOnRelease != null && event.isLeftMouseButton()) {
                                AbstractParallelCoordinatesController.this.getView().getModel().getSelection().clearSelection();
                                AbstractParallelCoordinatesController.this.addToSelection(this.selectOnRelease);
                                this.selectOnRelease = null;
                            }
                            if (this.zoomOnRelease != null) {
                                if (event.isLeftMouseButton()) {
                                    // empty if block
                                }
                                this.zoomOnRelease = null;
                            }
                            AbstractParallelCoordinatesController.this.getView().getRubberBand().stopRubberBand();
                            break;
                        }
                        case Toggle: {
                            if (this.selectOnRelease != null && event.isLeftMouseButton()) {
                                AbstractParallelCoordinatesController.this.getView().getModel().getSelection().clearSelection();
                                AbstractParallelCoordinatesController.this.addToSelection(this.selectOnRelease);
                                this.selectOnRelease = null;
                            }
                            if (this.zoomOnRelease != null) {
                                if (event.isLeftMouseButton()) {
                                    // empty if block
                                }
                                this.zoomOnRelease = null;
                            }
                            AbstractParallelCoordinatesController.this.getView().getRubberBand().stopRubberBand();
                            break;
                        }
                    }
                }
                this.last = null;
            }
        }

        public void mouseEntered(CPCanvas.MouseEvent e) {
        }

        public void mouseExited(CPCanvas.MouseEvent e) {
            if (AbstractParallelCoordinatesController.this.getView() != null && AbstractParallelCoordinatesController.this.getView().getModel() != null) {
                AbstractParallelCoordinatesController.this.getView().getModel().getProbing().clearSelection();
            }
        }

        public void mouseDragged(CPCanvas.MouseEvent event) {
            if (AbstractParallelCoordinatesController.this.getView() != null && AbstractParallelCoordinatesController.this.getView().getModel() != null) {
                Point point = new Point(event.getX(), event.getY());
                if (this.last != null) {
                    switch (AbstractParallelCoordinatesController.this.getMode()) {
                        case Selection: {
                            boolean isAlreadySelected;
                            if (!event.isLeftMouseButton()) break;
                            if (event.isAltKeyDown() || event.isShiftKeyDown()) {
                                AbstractParallelCoordinatesController.this.getView().getModel().getProbing().clearSelection();
                                if (!AbstractParallelCoordinatesController.this.getView().getRubberBand().getRubberBand().isActive()) {
                                    AbstractParallelCoordinatesController.this.getView().getRubberBand().startRubberBand(this.pressedPoint.x, this.pressedPoint.y);
                                }
                                AbstractParallelCoordinatesController.this.getView().getRubberBand().stretchRubberBand(event.getX(), event.getY());
                                Rectangle2D rect = AbstractParallelCoordinatesController.this.getView().getRubberBand().getRubberBandScreen();
                                if (rect == null) break;
                                Collection toSelect = AbstractParallelCoordinatesController.this.getView().getRows(rect);
                                if (event.isMultipleSelectionKey()) {
                                    AbstractParallelCoordinatesController.this.addToSelection(toSelect);
                                } else {
                                    AbstractParallelCoordinatesController.this.getView().getModel().getSelection().setSelectedIterable(toSelect);
                                }
                                this.selectOnRelease = null;
                                break;
                            }
                            Object observation = AbstractParallelCoordinatesController.this.getView().getClosestRow(point.x, point.y);
                            AbstractParallelCoordinatesController.this.getView().getModel().getProbing().setSelected(observation);
                            this.selectOnRelease = null;
                            boolean bl = isAlreadySelected = AbstractParallelCoordinatesController.this.getView().getModel().getSelection() != null && AbstractParallelCoordinatesController.this.getView().getModel().getSelection().isSelected(observation);
                            if (!isAlreadySelected && !event.isMenuShortcutKeyDown()) {
                                AbstractParallelCoordinatesController.this.getView().getModel().getSelection().clearSelection();
                            }
                            if (event.isMenuShortcutKeyDown()) {
                                AbstractParallelCoordinatesController.this.addToSelection(observation);
                                break;
                            }
                            if (isAlreadySelected) {
                                this.selectOnRelease = observation;
                                break;
                            }
                            AbstractParallelCoordinatesController.this.addToSelection(observation);
                        }
                    }
                }
                this.last = new Point(event.getX(), event.getY());
            }
        }

        public void mouseMoved(CPCanvas.MouseEvent event) {
            Object closest = AbstractParallelCoordinatesController.this.getView().getClosestRow(event.getX(), event.getY());
            AbstractParallelCoordinatesController.this.getView().getModel().getProbing().setSelected(closest);
        }
    }
}

