/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates.layout;

import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.hierarchy.Hierarchy;
import com.macrofocus.high_d.axis.Alignment;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesView;
import com.macrofocus.high_d.parallelcoordinates.layout.ParallelCoordinatesLayout;
import com.macrofocus.high_d.parallelcoordinates.layout.ParallelCoordinatesLayoutEngine;
import com.macrofocus.igraphics.CPColor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultParallelCoordinatesLayoutEngine
implements ParallelCoordinatesLayoutEngine {
    private final ParallelCoordinatesView<?, CPColor, ?, ?> view;

    public DefaultParallelCoordinatesLayoutEngine(ParallelCoordinatesView view) {
        this.view = view;
    }

    @Override
    public ParallelCoordinatesLayout doLayout(final int axisPreferredWidth, final int axisBeforeTrackGap, final int axisAfterTrackGap) {
        final Map<AxisGroupModel, Rectangle2D> verticalLayout = this.doVerticalLayout();
        final Map<AxisGroupModel, Rectangle2D> horizontalLayout = this.doHorizontalLayout();
        final List<List<AxisGroupModel>> axisGroupsPerLevels = this.doAxisGroupsPerLevel();
        final Map<Integer, Rectangle2D> levelsLayout = this.doLevelsLayout(axisGroupsPerLevels, verticalLayout);
        return new ParallelCoordinatesLayout(){

            @Override
            public int getAxisPreferredWidth() {
                return axisPreferredWidth;
            }

            @Override
            public int getAxisBeforeTrackGap() {
                return axisBeforeTrackGap;
            }

            @Override
            public int getAxisAfterTrackGap() {
                return axisAfterTrackGap;
            }

            @Override
            public Rectangle2D getBounds(AxisGroupModel axisGroup) {
                return ((Rectangle2D)verticalLayout.get(axisGroup)).createIntersection((Rectangle2D)horizontalLayout.get(axisGroup));
            }

            @Override
            public Rectangle2D getBounds(AxisGroupModel axisGroup, AxisModel axisModel) {
                Rectangle2D groupBounds = this.getBounds(axisGroup);
                double position = DefaultParallelCoordinatesLayoutEngine.this.getPosition(axisGroup, axisModel);
                double x = groupBounds.getX() + groupBounds.getWidth() * position;
                double width = 0.0;
                switch ((Alignment)DefaultParallelCoordinatesLayoutEngine.this.view.getAlignment().getValue()) {
                    case Left: {
                        width = groupBounds.getWidth() / (double)axisGroup.getVisibleAxisCount();
                        break;
                    }
                    case Center: {
                        width = groupBounds.getWidth() / (double)axisGroup.getVisibleAxisCount();
                        break;
                    }
                    case Fill: {
                        width = groupBounds.getWidth() / (double)(axisGroup.getVisibleAxisCount() - 1);
                        break;
                    }
                    case Right: {
                        width = groupBounds.getWidth() / (double)axisGroup.getVisibleAxisCount();
                    }
                }
                Rectangle2D.Double bounds = new Rectangle2D.Double(x, groupBounds.getY(), width, groupBounds.getHeight());
                return bounds;
            }

            @Override
            public Rectangle2D getHeaderBounds(AxisGroupModel axisGroup) {
                Rectangle2D bounds = this.getBounds(axisGroup);
                return new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), DefaultParallelCoordinatesLayoutEngine.this.view.getAxisGroupView(axisGroup) == null || DefaultParallelCoordinatesLayoutEngine.this.view.getModel().getAxisHierarchy().getAxisGroupHierarchy().isRoot((Object)axisGroup) ? 0.0 : (double)DefaultParallelCoordinatesLayoutEngine.this.view.getHeaderAxisGroupMaximumHeight());
            }

            @Override
            public Rectangle2D getHeaderBounds(AxisGroupModel axisGroup, AxisModel axisModel) {
                Rectangle2D axisGroupBounds = this.getHeaderBounds(axisGroup);
                Rectangle2D axisBounds = this.getBounds(axisGroup, axisModel);
                switch ((Alignment)DefaultParallelCoordinatesLayoutEngine.this.view.getAlignment().getValue()) {
                    case Left: {
                        return new Rectangle2D.Double(axisBounds.getX(), axisGroupBounds.getMaxY(), axisBounds.getWidth(), (double)DefaultParallelCoordinatesLayoutEngine.this.view.getHeaderAxisMaximumHeight());
                    }
                    case Center: {
                        return new Rectangle2D.Double(axisBounds.getX() - axisBounds.getWidth() / 2.0, axisGroupBounds.getMaxY(), axisBounds.getWidth(), (double)DefaultParallelCoordinatesLayoutEngine.this.view.getHeaderAxisMaximumHeight());
                    }
                    case Fill: {
                        double width;
                        double shift;
                        double p = DefaultParallelCoordinatesLayoutEngine.this.getPosition(axisGroup, axisModel);
                        if (p == 0.0) {
                            shift = 0.0;
                            width = axisBounds.getWidth() / 2.0;
                        } else if (p == 1.0) {
                            shift = axisBounds.getWidth() / 2.0;
                            width = axisBounds.getWidth() / 2.0;
                        } else {
                            shift = axisBounds.getWidth() / 2.0;
                            width = axisBounds.getWidth();
                        }
                        return new Rectangle2D.Double(axisBounds.getX() - shift, axisGroupBounds.getMaxY(), width, (double)DefaultParallelCoordinatesLayoutEngine.this.view.getHeaderAxisMaximumHeight());
                    }
                    case Right: {
                        return new Rectangle2D.Double(axisBounds.getX() - axisBounds.getWidth(), axisGroupBounds.getMaxY(), axisBounds.getWidth(), (double)DefaultParallelCoordinatesLayoutEngine.this.view.getHeaderAxisMaximumHeight());
                    }
                }
                return null;
            }

            @Override
            public Rectangle2D getSliderBounds(AxisGroupModel axisGroup, AxisModel axisModel) {
                Rectangle2D headerBounds = this.getHeaderBounds(axisGroup, axisModel);
                Rectangle2D axisBounds = this.getBounds(axisGroup, axisModel);
                switch ((Alignment)DefaultParallelCoordinatesLayoutEngine.this.view.getAlignment().getValue()) {
                    case Left: {
                        return new Rectangle2D.Double(axisBounds.getX(), headerBounds.getMaxY(), (double)axisPreferredWidth, axisBounds.getHeight() - (headerBounds.getMaxY() - axisBounds.getY()));
                    }
                    case Center: {
                        return new Rectangle2D.Double(axisBounds.getX() - (double)axisPreferredWidth / 2.0, headerBounds.getMaxY(), (double)axisPreferredWidth, axisBounds.getHeight() - (headerBounds.getMaxY() - axisBounds.getY()));
                    }
                    case Fill: {
                        int shift = axisBounds.getX() == 0.0 ? 0 : axisPreferredWidth;
                        return new Rectangle2D.Double(axisBounds.getX() - (double)shift, headerBounds.getMaxY(), (double)axisPreferredWidth, axisBounds.getHeight() - (headerBounds.getMaxY() - axisBounds.getY()));
                    }
                    case Right: {
                        return new Rectangle2D.Double(axisBounds.getX() - (double)axisPreferredWidth, headerBounds.getMaxY(), (double)axisPreferredWidth, axisBounds.getHeight() - (headerBounds.getMaxY() - axisBounds.getY()));
                    }
                }
                return null;
            }

            @Override
            public Rectangle2D getTrackBounds(AxisGroupModel axisGroup, AxisModel axisModel) {
                Rectangle2D sliderBounds = this.getSliderBounds(axisGroup, axisModel);
                return new Rectangle2D.Double(sliderBounds.getX(), sliderBounds.getY() + (double)axisBeforeTrackGap, sliderBounds.getWidth(), sliderBounds.getHeight() - (double)axisBeforeTrackGap - (double)axisAfterTrackGap);
            }

            @Override
            public Rectangle2D getLevelBounds(int level) {
                return (Rectangle2D)levelsLayout.get(level);
            }

            @Override
            public int getLevelCount() {
                return axisGroupsPerLevels.size();
            }

            @Override
            public Iterable<AxisGroupModel> getAxisGroups(int level) {
                return (Iterable)axisGroupsPerLevels.get(level);
            }
        };
    }

    private Map<AxisGroupModel, Rectangle2D> doHorizontalLayout() {
        HashMap<AxisGroupModel, Rectangle2D> horizontalLayout = new HashMap<AxisGroupModel, Rectangle2D>();
        ParallelCoordinatesModel<CPColor, ?, ?> model = this.view.getModel();
        Hierarchy hierarchy = model.getAxisHierarchy().getAxisGroupHierarchy();
        int sumAxisCount = 0;
        int sumRelativeCount = 0;
        int sumFixedCount = 0;
        int sumFixed = 0;
        for (AxisGroupModel axisGroup : hierarchy.leavesIterator()) {
            sumAxisCount += axisGroup.getVisibleAxisCount();
            if (axisGroup.isCollapsed()) {
                sumFixed += axisGroup.getVisibleAxisCount() * 4;
                sumFixedCount += axisGroup.getVisibleAxisCount();
                continue;
            }
            sumRelativeCount += axisGroup.getVisibleAxisCount();
        }
        double x = 0.0;
        for (AxisGroupModel axisGroup : hierarchy.leavesIterator()) {
            double width = axisGroup.isCollapsed() ? (double)(axisGroup.getVisibleAxisCount() * 4) : (double)((this.view.getWidth() - sumFixed) * axisGroup.getVisibleAxisCount()) / (double)(sumAxisCount - sumFixedCount);
            Rectangle2D.Double value = new Rectangle2D.Double(x, 0.0, width, (double)this.view.getHeight());
            horizontalLayout.put(axisGroup, (Rectangle2D)value);
            x += width;
        }
        for (AxisGroupModel axisGroup : hierarchy.depthFirstIterator()) {
            AxisGroupModel parent = (AxisGroupModel)hierarchy.getParent((Object)axisGroup);
            if (parent == null) continue;
            Rectangle2D groupBounds = (Rectangle2D)horizontalLayout.get(axisGroup);
            if (!horizontalLayout.containsKey(parent)) {
                horizontalLayout.put(parent, groupBounds);
                continue;
            }
            horizontalLayout.put(parent, ((Rectangle2D)horizontalLayout.get(parent)).createUnion(groupBounds));
        }
        return horizontalLayout;
    }

    double getPosition(AxisGroupModel axisGroup, AxisModel axisModel) {
        Double location = this.view.getModel().getAxisLocations(axisGroup).getLocation((Alignment)this.view.getAlignment().getValue(), axisModel);
        return location;
    }

    private Map<AxisGroupModel, Rectangle2D> doVerticalLayout() {
        HashMap<AxisGroupModel, Rectangle2D> verticalLayout = new HashMap<AxisGroupModel, Rectangle2D>();
        ParallelCoordinatesModel<CPColor, ?, ?> model = this.view.getModel();
        Hierarchy hierarchy = model.getAxisHierarchy().getAxisGroupHierarchy();
        int depth = hierarchy.getDepth();
        ArrayList<VerticalLayoutSize> layoutSizes = new ArrayList<VerticalLayoutSize>(depth + 1);
        for (int i = 0; i < depth + 1; ++i) {
            layoutSizes.add(new VerticalLayoutSize());
        }
        for (AxisGroupModel axisGroup : hierarchy.breadthFirstIterator()) {
            int level = this.getLevel((Hierarchy<AxisGroupModel>)hierarchy, axisGroup);
            VerticalLayoutSize layoutSize = (VerticalLayoutSize)layoutSizes.get(level);
            layoutSize.relative = axisGroup.getVisibleAxisCount() == 0 ? 0.0 : 1.0;
            layoutSize.fixed = hierarchy.isRoot((Object)axisGroup) ? 0 : Math.max(layoutSize.fixed, 18);
        }
        int sumFixed = 0;
        double sumRelative = 0.0;
        for (VerticalLayoutSize layoutSize : layoutSizes) {
            sumFixed += layoutSize.fixed;
            sumRelative += layoutSize.relative;
        }
        double remainingHeigh = this.view.getHeight() - sumFixed;
        int y = 0;
        for (VerticalLayoutSize layoutSize : layoutSizes) {
            layoutSize.y = y;
            layoutSize.height = (double)layoutSize.fixed + remainingHeigh * layoutSize.relative / sumRelative;
            y = (int)((double)y + layoutSize.height);
        }
        for (AxisGroupModel axisGroup : hierarchy.breadthFirstIterator()) {
            int level = this.getLevel((Hierarchy<AxisGroupModel>)hierarchy, axisGroup);
            VerticalLayoutSize layoutSize = (VerticalLayoutSize)layoutSizes.get(level);
            verticalLayout.put(axisGroup, (Rectangle2D)new Rectangle2D.Double(0.0, layoutSize.y, (double)this.view.getWidth(), layoutSize.height));
        }
        return verticalLayout;
    }

    List<List<AxisGroupModel>> doAxisGroupsPerLevel() {
        ParallelCoordinatesModel<CPColor, ?, ?> model = this.view.getModel();
        Hierarchy hierarchy = model.getAxisHierarchy().getAxisGroupHierarchy();
        int depth = hierarchy.getDepth();
        ArrayList<List<AxisGroupModel>> axisGroupsPerLevels = new ArrayList<List<AxisGroupModel>>(depth + 1);
        for (int i = 0; i < depth + 1; ++i) {
            axisGroupsPerLevels.add(new ArrayList());
        }
        for (AxisGroupModel axisGroup : hierarchy.breadthFirstIterator()) {
            int level = this.getLevel((Hierarchy<AxisGroupModel>)hierarchy, axisGroup);
            List axisGroups = (List)axisGroupsPerLevels.get(level);
            axisGroups.add(axisGroup);
        }
        return axisGroupsPerLevels;
    }

    private Map<Integer, Rectangle2D> doLevelsLayout(List<List<AxisGroupModel>> axisGroupsPerLevels, Map<AxisGroupModel, Rectangle2D> verticalLayout) {
        HashMap<Integer, Rectangle2D> levelsLayout = new HashMap<Integer, Rectangle2D>();
        for (int l = 0; l < axisGroupsPerLevels.size(); ++l) {
            List<AxisGroupModel> axisGroups = axisGroupsPerLevels.get(l);
            for (AxisGroupModel axisGroup : axisGroups) {
                if (levelsLayout.containsKey(l)) {
                    Rectangle2D bounds = ((Rectangle2D)levelsLayout.get(l)).createUnion(verticalLayout.get(axisGroup));
                    levelsLayout.put(l, bounds);
                    continue;
                }
                levelsLayout.put(l, verticalLayout.get(axisGroup));
            }
        }
        return levelsLayout;
    }

    private int getLevel(Hierarchy<AxisGroupModel> hierarchy, AxisGroupModel axisGroup) {
        return hierarchy.getLevel((Object)axisGroup);
    }

    private class VerticalLayoutSize {
        public int fixed;
        public double relative;
        public double y;
        public double height;

        private VerticalLayoutSize() {
        }
    }
}

