/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplot;

import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.BoundedIntervalEvent;
import com.macrofocus.common.interval.BoundedIntervalListener;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.properties.EnumProperties;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.scatterplot.ScatterPlotListener;
import com.macrofocus.high_d.scatterplot.ScatterPlotModel;
import com.macrofocus.high_d.scatterplot.ScatterPlotView;
import com.macrofocus.high_d.scatterplot.SizeProportion;
import com.macrofocus.igraphics.AbstractIDrawing;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.colortheme.LightColorTheme;
import com.macrofocus.igraphics.pressure.LinearPressure;
import com.macrofocus.igraphics.pressure.Pressure;
import com.macrofocus.palette.FixedPalette;
import com.macrofocus.plot.guide.Guide;
import com.macrofocus.rubberband.RubberBand;
import com.macrofocus.rubberband.RubberbandDrawing;
import com.macrofocus.rubberband.ScreenTransformRubberBand;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import com.macrofocus.timer.VisualizationExecutorService;
import com.macrofocus.transform.RangesScreenTransformCoordinator;
import com.macrofocus.transform.ScreenTransformEvent;
import com.macrofocus.transform.ScreenTransformListener;
import com.macrofocus.transform.twod.MutableTwoDScreenTransform;
import com.macrofocus.transform.twod.SimpleTwoDScreenTransform;
import com.macrofocus.transform.twod.TwoDScreenTransform;
import com.macrofocus.visual.VisualLayer;
import com.macrofocus.visual.VisualListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractScatterPlotView<Component, Color, Font, Row, Column>
implements ScatterPlotView<Component, Color, Font, Row, Column> {
    protected ScatterPlotModel<Color, Row, Column> model;
    protected final MutableProperties<ScatterPlotView.PropertyType> properties = new EnumProperties(ScatterPlotView.PropertyType.class);
    protected CPCanvas<Component> canvas;
    private CPFactory<?, ?, ?, Color> factory;
    protected final CPTimer timer;
    private final MutableBoundedInterval xRangeModel;
    private final MutableBoundedInterval yRangeModel;
    protected final MutableTwoDScreenTransform screenTransform;
    protected RangesScreenTransformCoordinator rangesScreenTransformCoordinator = null;
    protected Guide<Component, Color, Font> xGuide;
    protected Guide<Component, Color, Font> yGuide;
    private boolean isSelectionMode = true;
    private RubberBand rubberBand;
    private static final boolean MULTITHREADED = true;
    private static final VisualizationExecutorService executor = VisualizationExecutorService.getInstance();
    private final PropertiesListener<ScatterPlotView.PropertyType> propertiesListener = new PropertiesListener<ScatterPlotView.PropertyType>(){

        public void propertyChanged(ScatterPlotView.PropertyType name, PropertyEvent event) {
            AbstractScatterPlotView.this.createOverplots();
            AbstractScatterPlotView.this.scheduleUpdate();
        }
    };
    private final ScatterPlotListener listener = new ScatterPlotListener(){

        @Override
        public void scatterPlotChanged() {
            AbstractScatterPlotView.this.resetXAxis();
            AbstractScatterPlotView.this.resetYAxis();
            AbstractScatterPlotView.this.scheduleUpdate();
        }
    };
    private final BoundedIntervalListener intervalListener = new BoundedIntervalListener(){

        public void boundedIntervalChanged(BoundedIntervalEvent event) {
            AbstractScatterPlotView.this.updateIntervals();
        }
    };
    private final SingleSelectionListener<AxisModel<Row, Column>> axisSelectionListener = new SingleSelectionListener<AxisModel<Row, Column>>(){

        public void selectionChanged(SingleSelectionEvent<AxisModel<Row, Column>> event) {
            if (event.getPreviousSelection() != null && ((AxisModel)event.getPreviousSelection()).getScaledInterval() != null) {
                ((AxisModel)event.getPreviousSelection()).getScaledInterval().removeBoundedIntervalListener(AbstractScatterPlotView.this.intervalListener);
            }
            if (event.getCurrentSelection() != null && ((AxisModel)event.getCurrentSelection()).getScaledInterval() != null) {
                ((AxisModel)event.getCurrentSelection()).getScaledInterval().addBoundedIntervalListener(AbstractScatterPlotView.this.intervalListener);
            }
            AbstractScatterPlotView.this.updateAxisType();
            AbstractScatterPlotView.this.updateIntervals();
        }
    };

    public AbstractScatterPlotView(CPCanvas canvas, CPFactory<?, ?, ?, Color> factory) {
        this.canvas = canvas;
        this.factory = factory;
        this.properties.createProperty((Object)ScatterPlotView.PropertyType.ShowFiltered, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)ScatterPlotView.PropertyType.ShowGrid, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)ScatterPlotView.PropertyType.Antialiasing, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)ScatterPlotView.PropertyType.Rendering, (Object)CPCanvas.Rendering.AlphaBlended);
        this.properties.createProperty((Object)ScatterPlotView.PropertyType.GridThickness, (Object)Float.valueOf(0.1f));
        this.properties.createProperty((Object)ScatterPlotView.PropertyType.ShowColor, (Object)factory.createRGBColor(128, 128, 128));
        this.properties.createProperty((Object)ScatterPlotView.PropertyType.Regression, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)ScatterPlotView.PropertyType.MarkerSize, (Object)8.0);
        this.properties.createProperty((Object)ScatterPlotView.PropertyType.MarkerExtraSizeHighlight, (Object)2);
        this.properties.createProperty((Object)ScatterPlotView.PropertyType.ColorTheme, (Object)new LightColorTheme(factory));
        this.properties.createProperty((Object)ScatterPlotView.PropertyType.DisplayLabels, (Object)Boolean.TRUE);
        this.properties.createProperty((Object)ScatterPlotView.PropertyType.SizeProportion, (Object)SizeProportion.Area);
        this.properties.addPropertiesListener(this.propertiesListener);
        this.timer = factory.createTimer("ScatterPlotResizer", 50, true, new CPTimerListener(){

            public void timerTriggered() {
                if (AbstractScatterPlotView.this.getWidth() > 0 && AbstractScatterPlotView.this.getHeight() > 0) {
                    AbstractScatterPlotView.this.refresh();
                }
            }
        });
        this.xRangeModel = new SimpleBoundedInterval(0.0, 1.0, 0.0, 1.0);
        this.yRangeModel = new SimpleBoundedInterval(0.0, 1.0, 0.0, 1.0);
        this.screenTransform = new SimpleTwoDScreenTransform((BoundedInterval)this.xRangeModel, (BoundedInterval)this.yRangeModel);
        this.screenTransform.getX().setScreenMargins(8);
        this.screenTransform.getY().setScreenMargins(8);
        this.rubberBand = new ScreenTransformRubberBand((TwoDScreenTransform)this.screenTransform);
        canvas.addCanvasListener(new CPCanvas.CanvasListener(){

            public void sizeChange(int width, int height) {
                AbstractScatterPlotView.this.screenTransform.setScreenSize(width, height);
            }
        });
        this.screenTransform.addScreenTransformListener(new ScreenTransformListener(){

            public void transformChanged(ScreenTransformEvent event) {
                AbstractScatterPlotView.this.timer.restart();
            }
        });
    }

    @Override
    public Guide<Component, Color, Font> getXGuide() {
        return this.xGuide;
    }

    @Override
    public Guide<Component, Color, Font> getYGuide() {
        return this.yGuide;
    }

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract void refresh();

    protected abstract void repaint();

    protected abstract void scheduleUpdate();

    @Override
    public void addMouseListener(CPCanvas.MouseListener l) {
        this.canvas.addMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.canvas.addMouseMotionListener(l);
    }

    @Override
    public void addMouseWheelListener(CPCanvas.MouseWheelListener l) {
        this.canvas.addMouseWheelListener(l);
    }

    @Override
    public void addKeyListener(CPCanvas.KeyListener listener) {
        this.canvas.addKeyListener(listener);
    }

    public void createOverplots() {
        if (this.model != null) {
            this.canvas.removeAllLayers();
            this.populateOverplots();
        }
    }

    protected void populateOverplots() {
        AbstractVisualLayerIDrawing filteredDrawing = new AbstractVisualLayerIDrawing(this.model.getVisual().getFiltered()){

            @Override
            public boolean isActive() {
                return (Boolean)AbstractScatterPlotView.this.getShowFiltered().getValue() != false && super.isActive();
            }

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                Point2D mp = AbstractScatterPlotView.this.getPoint(0, row);
                if (mp != null) {
                    if (AbstractScatterPlotView.this.model.getSizeAxisModel() != null) {
                        AbstractScatterPlotView.this.fillMarker(AbstractScatterPlotView.this.getMarkerSize(0, row), g, mp);
                    } else {
                        AbstractScatterPlotView.this.fillMarker(Math.max(1.0, AbstractScatterPlotView.this.getMarkerSize(0, row) / 2.0), g, mp);
                    }
                }
            }
        };
        AbstractVisualLayerIDrawing visibleDrawing = new AbstractVisualLayerIDrawing(this.model.getVisual().getVisible()){

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                Point2D mp = AbstractScatterPlotView.this.getPoint(0, row);
                if (mp != null) {
                    AbstractScatterPlotView.this.fillMarker(AbstractScatterPlotView.this.getMarkerSize(0, row), g, mp);
                }
            }
        };
        AbstractVisualLayerIDrawing visibleDrawing2 = new AbstractVisualLayerIDrawing(this.model.getVisual().getVisible()){

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                Point2D mp = AbstractScatterPlotView.this.getPoint2(0, row);
                if (mp != null) {
                    double size = AbstractScatterPlotView.this.getMarkerSize(0, row);
                    double radius = size / 2.0;
                    g.setColor(AbstractScatterPlotView.this.factory.getDarkGray());
                    g.drawLine(mp.getX() - radius, mp.getY(), mp.getX() + radius, mp.getY());
                }
            }
        };
        AbstractVisualLayerIDrawing colorMappedDrawing = new AbstractVisualLayerIDrawing(this.model.getVisual().getColorMapped()){

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                Point2D mp = AbstractScatterPlotView.this.getPoint(0, row);
                if (mp != null) {
                    g.setColor(AbstractScatterPlotView.this.model.getColorMapping().getColor(row));
                    AbstractScatterPlotView.this.fillMarker(AbstractScatterPlotView.this.getMarkerSize(0, row), g, mp);
                }
            }
        };
        AbstractVisualLayerIDrawing coloredDrawing = new AbstractVisualLayerIDrawing(this.model.getVisual().getColored()){

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                Point2D mp = AbstractScatterPlotView.this.getPoint(0, row);
                if (mp != null) {
                    g.setColor(AbstractScatterPlotView.this.model.getColoring().getColor(row));
                    AbstractScatterPlotView.this.fillMarker(AbstractScatterPlotView.this.getMarkerSize(0, row), g, mp);
                }
            }
        };
        AbstractVisualLayerIDrawing singleSelectedDrawing = new AbstractVisualLayerIDrawing(this.model.getVisual().getSingleSelected()){

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                Point2D mp = AbstractScatterPlotView.this.getPoint(0, row);
                if (mp != null) {
                    g.setColor(((ColorTheme)AbstractScatterPlotView.this.getColorTheme().getValue()).getSelection());
                    if (AbstractScatterPlotView.this.model.getSizeAxisModel() != null) {
                        AbstractScatterPlotView.this.fillMarker(AbstractScatterPlotView.this.getMarkerSize(0, row) + (double)((Integer)AbstractScatterPlotView.this.getMarkerExtraSizeHighlight().getValue()).intValue(), g, mp);
                    } else {
                        AbstractScatterPlotView.this.fillMarker(AbstractScatterPlotView.this.getMarkerSize(0, row) + (double)((Integer)AbstractScatterPlotView.this.getMarkerExtraSizeHighlight().getValue()).intValue(), g, mp);
                    }
                }
            }
        };
        AbstractVisualLayerIDrawing singleSelectedDrawing2 = new AbstractVisualLayerIDrawing(this.model.getVisual().getSingleSelected()){

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                Point2D mp = AbstractScatterPlotView.this.getPoint2(0, row);
                if (mp != null) {
                    g.setColor(((ColorTheme)AbstractScatterPlotView.this.getColorTheme().getValue()).getSelection());
                    if (AbstractScatterPlotView.this.model.getSizeAxisModel() != null) {
                        double size = AbstractScatterPlotView.this.getMarkerSize(0, row) + (double)((Integer)AbstractScatterPlotView.this.getMarkerExtraSizeHighlight().getValue()).intValue();
                        double radius = size / 2.0;
                        g.drawLine(mp.getX() - radius, mp.getY(), mp.getX() + radius, mp.getY());
                    } else {
                        double size = AbstractScatterPlotView.this.getMarkerSize(0, row) + (double)((Integer)AbstractScatterPlotView.this.getMarkerExtraSizeHighlight().getValue()).intValue();
                        double radius = size / 2.0;
                        g.drawLine(mp.getX() - radius, mp.getY(), mp.getX() + radius, mp.getY());
                    }
                }
            }
        };
        AbstractVisualLayerIDrawing multiSelectedDrawing = new AbstractVisualLayerIDrawing(this.model.getVisual().getMultipleSelected()){

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                Point2D mp = AbstractScatterPlotView.this.getPoint(0, row);
                if (mp != null) {
                    g.setColor(((ColorTheme)AbstractScatterPlotView.this.getColorTheme().getValue()).getSelection());
                    if (AbstractScatterPlotView.this.model.getSizeAxisModel() != null) {
                        AbstractScatterPlotView.this.fillMarker(AbstractScatterPlotView.this.getMarkerSize(0, row) + (double)((Integer)AbstractScatterPlotView.this.getMarkerExtraSizeHighlight().getValue()).intValue(), g, mp);
                    } else {
                        AbstractScatterPlotView.this.fillMarker(AbstractScatterPlotView.this.getMarkerSize(0, row) + (double)((Integer)AbstractScatterPlotView.this.getMarkerExtraSizeHighlight().getValue()).intValue(), g, mp);
                    }
                }
            }
        };
        AbstractVisualLayerIDrawing probedDrawing = new AbstractVisualLayerIDrawing(this.model.getVisual().getProbed()){

            @Override
            public void draw(IGraphics g, Row row, double width, double height) {
                Point2D mp = AbstractScatterPlotView.this.getPoint(0, row);
                if (mp != null) {
                    if (AbstractScatterPlotView.this.model.getSizeAxisModel() != null) {
                        g.setColor(((ColorTheme)AbstractScatterPlotView.this.getColorTheme().getValue()).getProbing());
                        AbstractScatterPlotView.this.fillMarker(AbstractScatterPlotView.this.getMarkerSize(0, row) + (double)((Integer)AbstractScatterPlotView.this.getMarkerExtraSizeHighlight().getValue()).intValue(), g, mp);
                        if (AbstractScatterPlotView.this.model.getSelection().isSelected(row)) {
                            g.setColor(((ColorTheme)AbstractScatterPlotView.this.getColorTheme().getValue()).getSelection());
                            AbstractScatterPlotView.this.fillMarker(AbstractScatterPlotView.this.getMarkerSize(0, row), g, mp);
                        }
                    } else {
                        g.setColor(((ColorTheme)AbstractScatterPlotView.this.getColorTheme().getValue()).getProbing());
                        AbstractScatterPlotView.this.fillMarker(AbstractScatterPlotView.this.getMarkerSize(0, row) + (double)((Integer)AbstractScatterPlotView.this.getMarkerExtraSizeHighlight().getValue()).intValue(), g, mp);
                        if (AbstractScatterPlotView.this.model.getSelection().isSelected(row)) {
                            g.setColor(((ColorTheme)AbstractScatterPlotView.this.getColorTheme().getValue()).getSelection());
                            AbstractScatterPlotView.this.fillMarker(AbstractScatterPlotView.this.getMarkerSize(0, row), g, mp);
                        }
                    }
                }
            }
        };
        this.canvas.addLayer((IDrawing)new AbstractIDrawing(){

            public void draw(IGraphics g, Point2D point, double width, double height, Rectangle clipBounds) {
                CPColor background = ((ColorTheme)AbstractScatterPlotView.this.getColorTheme().getValue()).getBackground();
                if (background != null) {
                    g.setColor(background);
                    g.fillRectangle2D((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, width, height));
                }
            }
        });
        if (((Boolean)this.getShowFiltered().getValue()).booleanValue()) {
            this.canvas.addDensityLayer((CPCanvas.Rendering)this.getRendering().getValue(), (IDrawing)filteredDrawing, (Pressure)new LinearPressure(), new CPCanvas.PaletteProvider(){

                public FixedPalette getPalette() {
                    return ((ColorTheme)AbstractScatterPlotView.this.getColorTheme().getValue()).getGhostedPalette();
                }
            });
        }
        this.canvas.addDensityLayer((CPCanvas.Rendering)this.getRendering().getValue(), (IDrawing)visibleDrawing, (Pressure)new LinearPressure(), new CPCanvas.PaletteProvider(){

            public FixedPalette getPalette() {
                return ((ColorTheme)AbstractScatterPlotView.this.getColorTheme().getValue()).getVisiblePalette();
            }
        });
        this.canvas.addAveragingLayer((CPCanvas.Rendering)this.getRendering().getValue(), (IDrawing)colorMappedDrawing);
        this.canvas.addBufferedLayer((IDrawing)coloredDrawing);
        this.canvas.addDensityLayer((CPCanvas.Rendering)this.getRendering().getValue(), (IDrawing)multiSelectedDrawing, (Pressure)new LinearPressure(), new CPCanvas.PaletteProvider(){

            public FixedPalette getPalette() {
                return ((ColorTheme)AbstractScatterPlotView.this.getColorTheme().getValue()).getSelectedPalette();
            }
        });
        this.canvas.addLayer((IDrawing)singleSelectedDrawing);
        this.canvas.addLayer((IDrawing)probedDrawing);
        this.canvas.addDensityLayer((CPCanvas.Rendering)this.getRendering().getValue(), (IDrawing)visibleDrawing2, (Pressure)new LinearPressure(), new CPCanvas.PaletteProvider(){

            public FixedPalette getPalette() {
                return ((ColorTheme)AbstractScatterPlotView.this.getColorTheme().getValue()).getVisiblePalette();
            }
        });
        this.canvas.addLayer((IDrawing)singleSelectedDrawing2);
        this.canvas.addLayer((IDrawing)new AnnotationIDrawing((Selection<Object>)this.model.getVisual().getAnnotationProbing(), this.factory.createRGBAColor(255, 150, 0, 200)));
        this.canvas.addLayer((IDrawing)new AnnotationIDrawing((Selection<Object>)this.model.getVisual().getAnnotationSelection(), this.factory.createRGBAColor(255, 100, 0, 200)));
        this.canvas.addLayer((IDrawing)new RubberbandDrawing((CPColorFactory)this.factory, this.getRubberBand()){

            protected Property<ColorTheme<Color>> getColorTheme() {
                return AbstractScatterPlotView.this.getColorTheme();
            }
        });
    }

    private void fillMarker(double DATA, IGraphics g, Point2D mp) {
        double size = DATA;
        double radius = size / 2.0;
        g.fillCircle((Rectangle2D)new Rectangle2D.Double(mp.getX() - radius, mp.getY() - radius, size, size));
    }

    @Override
    public void setModel(ScatterPlotModel model) {
        if (this.model != null) {
            this.model.removeScatterPlotListener(this.listener);
            if (this.model.getX() != null) {
                this.model.getX().removeSingleSelectionListener(this.axisSelectionListener);
            }
            if (this.model.getY() != null) {
                this.model.getY().removeSingleSelectionListener(this.axisSelectionListener);
            }
        }
        this.model = model;
        this.createOverplots();
        if (this.model != null) {
            this.model.addScatterPlotListener(this.listener);
            if (this.model.getX() != null) {
                MutableSingleSelection<AxisModel<Row, Column>> x = this.model.getX();
                x.addSingleSelectionListener(this.axisSelectionListener);
                if (x.isActive() && ((AxisModel)x.getSelected()).getScaledInterval() != null) {
                    ((AxisModel)x.getSelected()).getScaledInterval().addBoundedIntervalListener(this.intervalListener);
                }
            }
            if (this.model.getY() != null) {
                MutableSingleSelection<AxisModel<Row, Column>> y = this.model.getY();
                y.addSingleSelectionListener(this.axisSelectionListener);
                if (y.isActive() && ((AxisModel)y.getSelected()).getScaledInterval() != null) {
                    ((AxisModel)y.getSelected()).getScaledInterval().addBoundedIntervalListener(this.intervalListener);
                }
            }
        }
        this.updateIntervals();
        this.updateAxisType();
        this.resetXAxis();
        this.resetYAxis();
        this.timer.restart();
    }

    @Override
    public ScatterPlotModel getModel() {
        return this.model;
    }

    @Override
    public MutableBoundedInterval getXRangeModel() {
        return this.xRangeModel;
    }

    @Override
    public MutableBoundedInterval getYRangeModel() {
        return this.yRangeModel;
    }

    @Override
    public MutableTwoDScreenTransform getScreenTransform() {
        return this.screenTransform;
    }

    @Override
    public RubberBand getRubberBand() {
        return this.rubberBand;
    }

    public void resetXAxis() {
        if (this.model.getXAxisModel() != null) {
            if (this.model.getXAxisModel().getScaledInterval() != null) {
                double min = this.model.getXAxisModel().getScaledInterval().getMinimum();
                double max = this.model.getXAxisModel().getScaledInterval().getMaximum();
                this.xRangeModel.setMinMax(min, max);
                this.xRangeModel.setValue(min, max - min);
            } else {
                double min = this.model.getXAxisModel().getMinimum();
                double max = this.model.getXAxisModel().getMaximum();
                this.xRangeModel.setMinMax(min, max);
                this.xRangeModel.setValue(min, max - min);
            }
        }
    }

    public void resetYAxis() {
        if (this.model.getYAxisModel() != null) {
            if (this.model.getXAxisModel().getScaledInterval() != null) {
                double min = this.model.getYAxisModel().getScaledInterval().getMinimum();
                double max = this.model.getYAxisModel().getScaledInterval().getMaximum();
                this.yRangeModel.setMinMax(min, max);
                this.yRangeModel.setValue(min, max - min);
            } else {
                double min = this.model.getYAxisModel().getMinimum();
                double max = this.model.getYAxisModel().getMaximum();
                this.yRangeModel.setMinMax(min, max);
                this.yRangeModel.setValue(min, max - min);
            }
        }
    }

    @Override
    public void zoom(boolean animate, double x1, double x2, double y1, double y2) {
        this.getXRangeModel().setValue(x1, x2 - x1);
        this.getYRangeModel().setValue(y1, y2 - y1);
    }

    protected void updateIntervals() {
        double max;
        double min;
        MutableSingleSelection<AxisModel<Row, Column>> x = this.model.getX();
        MutableSingleSelection<AxisModel<Row, Column>> y = this.model.getY();
        if (x.isActive() && ((AxisModel)x.getSelected()).getScaledInterval() != null) {
            min = ((AxisModel)x.getSelected()).getScaledInterval().getMinimum();
            max = ((AxisModel)x.getSelected()).getScaledInterval().getMaximum();
            this.xRangeModel.setMinMax(min, max);
            this.xRangeModel.setValue(min, max - min);
        } else {
            this.resetXAxis();
        }
        if (y.isActive() && ((AxisModel)y.getSelected()).getScaledInterval() != null) {
            min = ((AxisModel)y.getSelected()).getScaledInterval().getMinimum();
            max = ((AxisModel)y.getSelected()).getScaledInterval().getMaximum();
            this.yRangeModel.setMinMax(min, max);
            this.yRangeModel.setValue(min, max - min);
        } else {
            this.resetYAxis();
        }
        if (this.rangesScreenTransformCoordinator != null) {
            this.rangesScreenTransformCoordinator.setRanges(this.xRangeModel, this.yRangeModel);
        }
        this.scheduleUpdate();
    }

    protected abstract void updateAxisType();

    @Override
    public Row getClosestRow(int x, int y) {
        double bestdistance = Double.MAX_VALUE;
        Row bestrow = null;
        VisualLayer visible = this.model.getVisual().getActive();
        for (Object row : visible) {
            double distance;
            Point2D p = this.getPoint(0, row);
            if (p == null || !((distance = Point2D.distance((double)p.getX(), (double)p.getY(), (double)x, (double)y)) < bestdistance)) continue;
            bestdistance = distance;
            bestrow = (Row)row;
        }
        return bestrow;
    }

    @Override
    public List<Row> getRows(Rectangle2D rect) {
        VisualLayer visible = this.model.getVisual().getActive();
        ArrayList list = new ArrayList();
        for (Object row : visible) {
            Point2D p = this.getPoint(0, row);
            if (p == null || !rect.contains(p)) continue;
            list.add(row);
        }
        return list;
    }

    @Override
    public MutableProperty<Boolean> getShowFiltered() {
        return this.properties.getProperty((Object)ScatterPlotView.PropertyType.ShowFiltered);
    }

    @Override
    public MutableProperty<Boolean> getShowGrid() {
        return this.properties.getProperty((Object)ScatterPlotView.PropertyType.ShowGrid);
    }

    @Override
    public MutableProperty<Boolean> getAntialiasing() {
        return this.properties.getProperty((Object)ScatterPlotView.PropertyType.Antialiasing);
    }

    @Override
    public MutableProperty<CPCanvas.Rendering> getRendering() {
        return this.properties.getProperty((Object)ScatterPlotView.PropertyType.Rendering);
    }

    @Override
    public MutableProperty<Float> getGridThickness() {
        return this.properties.getProperty((Object)ScatterPlotView.PropertyType.GridThickness);
    }

    @Override
    public MutableProperty<CPColor<Color>> getShowColor() {
        return this.properties.getProperty((Object)ScatterPlotView.PropertyType.ShowColor);
    }

    @Override
    public MutableProperty<Boolean> getRegression() {
        return this.properties.getProperty((Object)ScatterPlotView.PropertyType.Regression);
    }

    @Override
    public MutableProperty<Double> getMarkerSize() {
        return this.properties.getProperty((Object)ScatterPlotView.PropertyType.MarkerSize);
    }

    @Override
    public MutableProperty<Integer> getMarkerExtraSizeHighlight() {
        return this.properties.getProperty((Object)ScatterPlotView.PropertyType.MarkerExtraSizeHighlight);
    }

    @Override
    public MutableProperty<ColorTheme<Color>> getColorTheme() {
        return this.properties.getProperty((Object)ScatterPlotView.PropertyType.ColorTheme);
    }

    @Override
    public MutableProperty<Boolean> getDisplayLabels() {
        return this.properties.getProperty((Object)ScatterPlotView.PropertyType.DisplayLabels);
    }

    @Override
    public MutableProperty<SizeProportion> getSizeProportion() {
        return this.properties.getProperty((Object)ScatterPlotView.PropertyType.SizeProportion);
    }

    @Override
    public void setShowFiltered(MutableProperty<Boolean> showFiltered) {
        this.properties.replaceProperty((Object)ScatterPlotView.PropertyType.ShowFiltered, showFiltered);
    }

    @Override
    public void setRendering(MutableProperty<CPCanvas.Rendering> rendering) {
        this.properties.replaceProperty((Object)ScatterPlotView.PropertyType.Rendering, rendering);
    }

    @Override
    public void setAntialiasing(MutableProperty<Boolean> antialiasing) {
        this.properties.replaceProperty((Object)ScatterPlotView.PropertyType.Antialiasing, antialiasing);
    }

    @Override
    public void setColorTheme(MutableProperty<ColorTheme<Color>> colorTheme) {
        this.properties.replaceProperty((Object)ScatterPlotView.PropertyType.ColorTheme, colorTheme);
    }

    @Override
    public boolean isSelectionMode() {
        return this.isSelectionMode;
    }

    @Override
    public void setSelectionMode(boolean value) {
        this.isSelectionMode = value;
    }

    Point2D getPoint(int layer, Row row) {
        if (this.model.getXAxisModel() != null && this.model.getYAxisModel() != null) {
            Number v1 = this.model.getXAxisModel().getScaledValue(layer, row);
            Number v2 = this.model.getYAxisModel().getScaledValue(layer, row);
            if (v1 != null && v2 != null) {
                return new Point2D.Double(this.screenTransform.getX().worldToScreenPrecise(v1.doubleValue()), this.screenTransform.getY().worldToScreenPrecise(v2.doubleValue()));
            }
            return null;
        }
        return null;
    }

    Point2D getPoint2(int layer, Row row) {
        if (this.model.getXAxisModel() != null && this.model.getY2AxisModel() != null) {
            Number v1 = this.model.getXAxisModel().getScaledValue(layer, row);
            Number v2 = this.model.getY2AxisModel().getScaledValue(layer, row);
            if (v1 != null && v2 != null) {
                return new Point2D.Double(this.screenTransform.getX().worldToScreenPrecise(v1.doubleValue()), this.screenTransform.getY().worldToScreenPrecise(v2.doubleValue()));
            }
            return null;
        }
        return null;
    }

    Double getXLine(int layer, Row row) {
        if (this.model.getXAxisModel() != null) {
            Number v1 = this.model.getXAxisModel().getScaledValue(layer, row);
            if (v1 != null) {
                return this.screenTransform.getX().worldToScreenPrecise(v1.doubleValue());
            }
            return null;
        }
        return null;
    }

    Double getYLine(int layer, Row row) {
        if (this.model.getYAxisModel() != null) {
            Number v2 = this.model.getYAxisModel().getScaledValue(layer, row);
            if (v2 != null) {
                return this.screenTransform.getY().worldToScreenPrecise(v2.doubleValue());
            }
            return null;
        }
        return null;
    }

    private double getMarkerSize(int layer, Object row) {
        AxisModel<Row, Column> sizeAxisModel = this.model.getSizeAxisModel();
        if (sizeAxisModel != null) {
            Number v1 = sizeAxisModel.getValue(layer, row);
            if (v1 != null) {
                if (this.getSizeProportion().getValue() == SizeProportion.Area) {
                    double range = 2.0 * Math.sqrt((sizeAxisModel.getMaximum() - sizeAxisModel.getMinimum()) / Math.PI);
                    double v = 2.0 * Math.sqrt((v1.doubleValue() - sizeAxisModel.getMinimum()) / Math.PI);
                    return v * ((double)((Double)this.getMarkerSize().getValue()).intValue() - 1.0) / range + 1.0;
                }
                double range = sizeAxisModel.getMaximum() - sizeAxisModel.getMinimum();
                double v = v1.doubleValue() - sizeAxisModel.getMinimum();
                return v * ((double)((Double)this.getMarkerSize().getValue()).intValue() - 1.0) / range + 1.0;
            }
            return 0.0;
        }
        return ((Double)this.getMarkerSize().getValue()).intValue();
    }

    private class AnnotationIDrawing
    extends AbstractIDrawing {
        private final Selection<Object> selection;
        private final CPColor<Color> color;
        private final SelectionListener<Object> selectionListener = new SelectionListener<Object>(){

            public void selectionChanged(SelectionEvent<Object> event) {
                AnnotationIDrawing.this.notifyIDrawingChanged();
            }
        };

        public AnnotationIDrawing(Selection<Object> selection, CPColor<Color> color) {
            this.selection = selection;
            this.color = color;
            selection.addWeakSelectionListener(this.selectionListener);
        }

        public boolean isActive() {
            return true;
        }

        public void draw(IGraphics g, Point2D point, double width, double height, Rectangle clipBounds) {
            g.setColor(this.color);
            for (Object row : this.selection) {
                Point2D mp = AbstractScatterPlotView.this.getPoint(1, row);
                if (mp != null) {
                    g.drawLine(mp.getX(), 0.0, mp.getX(), height);
                    g.drawLine(0.0, mp.getY(), width, mp.getY());
                    if (AbstractScatterPlotView.this.model.getSizeAxisModel() != null) {
                        AbstractScatterPlotView.this.fillMarker(AbstractScatterPlotView.this.getMarkerSize(1, row), g, mp);
                        continue;
                    }
                    AbstractScatterPlotView.this.fillMarker(AbstractScatterPlotView.this.getMarkerSize(1, row) + (double)((Integer)AbstractScatterPlotView.this.getMarkerExtraSizeHighlight().getValue()).intValue(), g, mp);
                    continue;
                }
                Double y = AbstractScatterPlotView.this.getYLine(1, row);
                if (y != null) {
                    g.drawLine(0.0, y.doubleValue(), width, y.doubleValue());
                    continue;
                }
                Double x = AbstractScatterPlotView.this.getXLine(1, row);
                if (x == null) continue;
                g.drawLine(x.doubleValue(), 0.0, x.doubleValue(), height);
            }
        }
    }

    public abstract class AbstractVisualLayerIDrawing
    extends AbstractIDrawing {
        private final VisualLayer<Row> visualLayer;

        protected AbstractVisualLayerIDrawing(VisualLayer<Row> visualLayer) {
            this.visualLayer = visualLayer;
            visualLayer.addVisualListener(new VisualListener(){

                public void visualChanged() {
                    AbstractVisualLayerIDrawing.this.notifyIDrawingChanged();
                }
            });
        }

        public boolean isActive() {
            return this.visualLayer.isActive();
        }

        public void draw(final IGraphics g, Point2D point, final double gw, final double gh, Rectangle clipBounds) {
            block11: {
                if (this.visualLayer.getObjectCount() <= 0) break block11;
                if (!g.isThreadSafe()) {
                    for (Object row : this.visualLayer) {
                        this.draw(g, row, gw, gh);
                    }
                } else {
                    int nTasks = Math.min(executor.getAvailableProcessors(), this.visualLayer.getObjectCount());
                    int nRowsPerTask = this.visualLayer.getObjectCount() / nTasks;
                    ArrayList<2> todo = new ArrayList<2>(nTasks);
                    for (int nTask = 0; nTask < nTasks; ++nTask) {
                        final int fromRow = nTask * nRowsPerTask;
                        final int toRow = nTask < nTasks - 1 ? fromRow + nRowsPerTask : this.visualLayer.getObjectCount();
                        todo.add(new Callable<Object>(){
                            private final int from;
                            private final int to;
                            {
                                this.from = fromRow;
                                this.to = toRow;
                            }

                            @Override
                            public Object call() throws Exception {
                                for (Object row : AbstractVisualLayerIDrawing.this.visualLayer.iterable(this.from, this.to - 1)) {
                                    AbstractVisualLayerIDrawing.this.draw(g, row, gw, gh);
                                }
                                return null;
                            }
                        });
                    }
                    try {
                        List answers = executor.getExecutor().invokeAll(todo);
                        for (Future answer : answers) {
                            try {
                                answer.get();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            catch (ExecutionException e) {
                                e.getCause().printStackTrace();
                            }
                        }
                    }
                    catch (InterruptedException answers) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        public abstract void draw(IGraphics var1, Row var2, double var3, double var5);
    }
}

