/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplotmatrix;

import com.macrofocus.coloring.MutableColoring;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.SimpleProperties;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.high_d.axis.Alignment;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.group.DefaultAxisGroupModel;
import com.macrofocus.high_d.axis.locations.AxisLocations;
import com.macrofocus.high_d.axis.locations.DefaultAxisLocations;
import com.macrofocus.high_d.scatterplotmatrix.AbstractScatterPlotMatrixModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import com.macrofocus.visual.Visual;
import com.macrofocus.visual.VisualObjects;

public class DefaultScatterPlotMatrixModel<Color, Row, C>
extends AbstractScatterPlotMatrixModel<Color, Row, C> {
    private final DataFrame<Row, C, ?> dataFrame;
    private final Visual<Color, Row, C> visual;
    private final AxisGroupModel<Row, C> axisGroupModel;
    private final AxisLocations axisLocations;
    private final MutableProperties properties = new SimpleProperties();
    private final Property<Integer> maxDimensions = this.properties.createProperty((Object)"maxDimensions", (Object)40);

    public DefaultScatterPlotMatrixModel(DataFrame<Row, C, ?> dataFrame, CPFactory<?, ?, ?, Color> factory) {
        this(dataFrame, (MutableColorMapping<Color, Row, C>)new SimpleColorMapping((ColorMapFactory)factory, dataFrame), factory);
    }

    public DefaultScatterPlotMatrixModel(DataFrame<Row, C, ?> dataFrame, MutableColorMapping<Color, Row, C> colorMapping, CPFactory<?, ?, ?, Color> factory) {
        this(dataFrame, (Visual<Color, Row, C>)new SimpleVisual((VisualObjects)new SimpleVisualObjects(dataFrame), colorMapping), factory);
    }

    public DefaultScatterPlotMatrixModel(DataFrame<Row, C, ?> dataFrame, Visual<Color, Row, C> visual, CPFactory<?, ?, ?, Color> factory) {
        this(dataFrame, visual, (AxisGroupModel<Row, C>)new DefaultAxisGroupModel(factory, "Root", dataFrame, null, (SingleSelection)visual.getProbing(), (Selection)visual.getSelection(), (MutableFilter)visual.getFilter()));
    }

    public DefaultScatterPlotMatrixModel(DataFrame<Row, C, ?> dataFrame, Visual<Color, Row, C> visual, AxisGroupModel<Row, C> axisGroupModel) {
        this.dataFrame = dataFrame;
        this.axisGroupModel = axisGroupModel;
        this.axisLocations = new DefaultAxisLocations(axisGroupModel.getAxisOrder(), this.maxDimensions);
        this.visual = visual;
    }

    @Override
    public Visual<Color, Row, C> getVisual() {
        return this.visual;
    }

    @Override
    public int getObjectCount() {
        return this.dataFrame.getRowCount();
    }

    @Override
    public MutableSingleSelection<Row> getProbing() {
        return this.visual.getProbing();
    }

    @Override
    public MutableSelection<Row> getSelection() {
        return this.visual.getSelection();
    }

    @Override
    public MutableFilter<Row> getFilter() {
        return this.visual.getFilter();
    }

    @Override
    public MutableColorMapping<Color, Row, C> getColorMapping() {
        return this.visual.getColorMapping();
    }

    @Override
    public MutableColoring<Color, Row> getColoring() {
        return this.visual.getColoring();
    }

    @Override
    public Row getObject(int index) {
        return (Row)this.dataFrame.getRowKey(index);
    }

    @Override
    public AxisModel getAxisModel(int c) {
        return (AxisModel)this.axisGroupModel.getAxisOrder().get(c);
    }

    @Override
    public int getAxisCount() {
        return Math.min((Integer)this.maxDimensions.getValue(), this.axisGroupModel.getAxisOrder().size());
    }

    @Override
    public Double getLocation(AxisModel axisModel) {
        return this.axisLocations.getLocation(Alignment.Left, axisModel);
    }

    @Override
    public AxisGroupModel getAxisGroupModel() {
        return this.axisGroupModel;
    }

    @Override
    public void setLocation(AxisModel axisModel, double l) {
        this.axisLocations.setLocation(Alignment.Left, axisModel, l);
        this.firedScatterPlotMatrixChanged();
    }

    public int getVisibleAxisCount() {
        return this.axisGroupModel.getAxisOrder().size();
    }
}

