/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.statistics;

import com.macrofocus.coloring.ColoringListener;
import com.macrofocus.coloring.MutableColoring;
import com.macrofocus.coloring.implementation.ColoringEvent;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.filter.Filter;
import com.macrofocus.filter.FilterEvent;
import com.macrofocus.filter.FilterListener;
import com.macrofocus.molap.aggregates.cube.UnivariateStatistics;
import com.macrofocus.molap.dataframe.AbstractDataFrame;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.UniqueIndex;
import com.macrofocus.molap.series.Series;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StatisticsDataFrame<Row, C>
extends AbstractDataFrame<Stat, C, Object> {
    private final DataFrame<Row, C, ?> dataFrame;
    private final MutableSingleSelection<Row> probing;
    private final MutableSelection<Row> selection;
    private final Filter<Row> filter;
    private final MutableColorMapping<?, Row, C> colorMapping;
    private final MutableColoring<?, Row> coloring;
    private final Map<C, UnivariateStatistics> statisticsMap;
    private final SingleSelectionListener<Row> probingListener = new SingleSelectionListener<Row>(){

        public void selectionChanged(SingleSelectionEvent<Row> event) {
            StatisticsDataFrame.this.scheduleTableDataChanged();
        }
    };
    private final SelectionListener<Row> selectionListener = new SelectionListener<Row>(){

        public void selectionChanged(SelectionEvent<Row> event) {
            StatisticsDataFrame.this.scheduleTableDataChanged();
        }
    };
    private final ColoringListener<Row> coloringListener = new ColoringListener<Row>(){

        public void coloringChanged(ColoringEvent<Row> event) {
            StatisticsDataFrame.this.scheduleTableDataChanged();
        }
    };
    private final FilterListener<Row> filterListener = new FilterListener<Row>(){

        public void filterChanged(FilterEvent<Row> event) {
            StatisticsDataFrame.this.scheduleTableDataChanged();
        }
    };
    private final UniqueIndex<Stat> rowIndex = new DefaultUniqueIndex((Object[])Stat.values());
    private Type type;
    private final CPTimer structureChangedTimer;
    private final CPTimer dataChangedTimer;

    public StatisticsDataFrame(CPFactory factory, DataFrame<Row, C, ?> dataFrame, MutableSingleSelection<Row> probing, MutableSelection<Row> selection, Filter<Row> filter, MutableColorMapping<?, Row, C> colorMapping, MutableColoring<?, Row> coloring) {
        this.dataFrame = dataFrame;
        this.probing = probing;
        this.selection = selection;
        this.filter = filter;
        this.colorMapping = colorMapping;
        this.coloring = coloring;
        this.statisticsMap = new HashMap<C, UnivariateStatistics>();
        this.structureChangedTimer = factory.createTimer("Statistics$Structure", 50, true, new CPTimerListener(){

            public void timerTriggered() {
                StatisticsDataFrame.this.notifyDataFrameChanged(new DataFrameEvent(null, null, true));
            }
        });
        this.dataChangedTimer = factory.createTimer("Statistics$Data", 50, true, new CPTimerListener(){

            public void timerTriggered() {
                StatisticsDataFrame.this.statisticsMap.clear();
                StatisticsDataFrame.this.notifyDataFrameChanged(new DataFrameEvent(null, null, false));
            }
        });
        this.setType(Type.Active);
    }

    private void scheduleTableStructureChanged() {
        this.structureChangedTimer.restart();
    }

    private void scheduleTableDataChanged() {
        this.dataChangedTimer.restart();
    }

    public void setType(Type type) {
        if (this.type != null) {
            switch (this.type.ordinal()) {
                case 0: {
                    this.probing.removeSingleSelectionListener(this.probingListener);
                    break;
                }
                case 1: {
                    this.selection.removeSelectionListener(this.selectionListener);
                    break;
                }
                case 2: {
                    this.coloring.removeColoringListener(this.coloringListener);
                    break;
                }
                case 3: {
                    this.filter.removeFilterListener(this.filterListener);
                    break;
                }
                case 4: {
                    this.filter.removeFilterListener(this.filterListener);
                    break;
                }
            }
        }
        if (this.type != type) {
            this.type = type;
            switch (type.ordinal()) {
                case 0: {
                    this.probing.addSingleSelectionListener(this.probingListener);
                    break;
                }
                case 1: {
                    this.selection.addSelectionListener(this.selectionListener);
                    break;
                }
                case 2: {
                    this.coloring.addColoringListener(this.coloringListener);
                    break;
                }
                case 3: {
                    this.filter.addFilterListener(this.filterListener);
                    break;
                }
                case 4: {
                    this.filter.addFilterListener(this.filterListener);
                    break;
                }
            }
            this.statisticsMap.clear();
            this.notifyDataFrameChanged(new DataFrameEvent(null, null, false));
        }
    }

    public DataFrame<Row, C, ?> getDataFrame() {
        return this.dataFrame;
    }

    public String getColumnName(C column) {
        return this.dataFrame.getColumnName(column);
    }

    public Class<?> getColumnClass(C column) {
        return this.dataFrame.getColumnClass(column);
    }

    public int getRowCount() {
        return Stat.values().length;
    }

    public int getColumnCount() {
        return this.dataFrame.getColumnCount();
    }

    public Object getValueAt(Stat rowIndex, C columnIndex) {
        UnivariateStatistics statistics = this.getStatistics(columnIndex);
        if (rowIndex == Stat.ThreeSignma) {
            return statistics.getSigma(3.0);
        }
        if (rowIndex == Stat.TwoSigma) {
            return statistics.getSigma(2.0);
        }
        if (rowIndex == Stat.OneSigma) {
            return statistics.getSigma(1.0);
        }
        if (rowIndex == Stat.Mean) {
            return statistics.getMean();
        }
        if (rowIndex == Stat.MinusOneSigma) {
            return statistics.getSigma(-1.0);
        }
        if (rowIndex == Stat.MinusTwoSigma) {
            return statistics.getSigma(-2.0);
        }
        if (rowIndex == Stat.MinusThreeSigma) {
            return statistics.getSigma(-3.0);
        }
        if (rowIndex == Stat.Maximum) {
            return statistics.getPercentile(100.0);
        }
        if (rowIndex == Stat.P995) {
            return statistics.getPercentile(99.5);
        }
        if (rowIndex == Stat.P975) {
            return statistics.getPercentile(97.5);
        }
        if (rowIndex == Stat.P900) {
            return statistics.getPercentile(90.0);
        }
        if (rowIndex == Stat.P750) {
            return statistics.getPercentile(75.0);
        }
        if (rowIndex == Stat.Median) {
            return statistics.getPercentile(50.0);
        }
        if (rowIndex == Stat.P250) {
            return statistics.getPercentile(25.0);
        }
        if (rowIndex == Stat.P100) {
            return statistics.getPercentile(10.0);
        }
        if (rowIndex == Stat.P025) {
            return statistics.getPercentile(2.5);
        }
        if (rowIndex == Stat.P050) {
            return statistics.getPercentile(0.5);
        }
        if (rowIndex == Stat.Minimum) {
            return statistics.getPercentile(0.0);
        }
        if (rowIndex == Stat.Sum) {
            return statistics.getSum();
        }
        if (rowIndex == Stat.Origin) {
            return statistics.getMean() != null ? Double.valueOf(0.0) : null;
        }
        if (rowIndex == Stat.N) {
            return statistics.getCount();
        }
        return null;
    }

    public UniqueIndex<Stat> getRowIndex() {
        return this.rowIndex;
    }

    public UniqueIndex<C> getColumnIndex() {
        return this.dataFrame.getColumnIndex();
    }

    public Class getRowClass(Stat integer) {
        return Object.class;
    }

    public Series<C, ?> getRow(Stat integer) {
        return null;
    }

    public DataFrame join(Series series, C[] cs) {
        return null;
    }

    public UnivariateStatistics getStatistics(C column) {
        if (this.statisticsMap.containsKey(column)) {
            return this.statisticsMap.get(column);
        }
        UnivariateStatistics univariateStatistics = new UnivariateStatistics(this.getRows(), this.dataFrame.getColumn(column));
        this.statisticsMap.put(column, univariateStatistics);
        return univariateStatistics;
    }

    private Iterable<Row> getRows() {
        switch (this.type.ordinal()) {
            case 0: {
                return this.probing;
            }
            case 1: {
                return this.selection;
            }
            case 2: {
                return this.coloring;
            }
            case 3: {
                return new TableIterable(0, this.dataFrame.getRowCount() - 1){

                    @Override
                    public boolean condition(Row row) {
                        return !StatisticsDataFrame.this.filter.isFiltered(row);
                    }
                };
            }
            case 4: {
                return new TableIterable(0, this.dataFrame.getRowCount() - 1){

                    @Override
                    public boolean condition(Row row) {
                        return StatisticsDataFrame.this.filter.isFiltered(row);
                    }
                };
            }
            case 5: {
                return new TableIterable(0, this.dataFrame.getRowCount() - 1);
            }
        }
        return null;
    }

    public static enum Stat {
        ThreeSignma{

            public String toString() {
                return "3\u03c3";
            }
        }
        ,
        TwoSigma{

            public String toString() {
                return "2\u03c3";
            }
        }
        ,
        OneSigma{

            public String toString() {
                return "1\u03c3";
            }
        }
        ,
        Mean{

            public String toString() {
                return "Mean";
            }
        }
        ,
        MinusOneSigma{

            public String toString() {
                return "-1\u03c3";
            }
        }
        ,
        MinusTwoSigma{

            public String toString() {
                return "-2\u03c3";
            }
        }
        ,
        MinusThreeSigma{

            public String toString() {
                return "-3\u03c3";
            }
        }
        ,
        Maximum{

            public String toString() {
                return "100.0% (maximum)";
            }
        }
        ,
        P995{

            public String toString() {
                return "99.5%";
            }
        }
        ,
        P975{

            public String toString() {
                return "97.5%";
            }
        }
        ,
        P900{

            public String toString() {
                return "90.0%";
            }
        }
        ,
        P750{

            public String toString() {
                return "75.0% (quartile)";
            }
        }
        ,
        Median{

            public String toString() {
                return "50.0% (median)";
            }
        }
        ,
        P250{

            public String toString() {
                return "25.0% (quartile)";
            }
        }
        ,
        P100{

            public String toString() {
                return "10.0%";
            }
        }
        ,
        P025{

            public String toString() {
                return "2.5%";
            }
        }
        ,
        P050{

            public String toString() {
                return "0.5%";
            }
        }
        ,
        Minimum{

            public String toString() {
                return "0.0% (minimum)";
            }
        }
        ,
        Sum{

            public String toString() {
                return "Sum";
            }
        }
        ,
        Origin{

            public String toString() {
                return "Origin";
            }
        }
        ,
        N{

            public String toString() {
                return "N";
            }
        };

    }

    private static enum Type {
        Probed,
        Selected,
        Colored,
        Active,
        Filtered,
        All;

    }

    protected class TableIterable
    implements Iterable<Row> {
        private final int from;
        private final int to;

        public TableIterable(int from, int to) {
            this.from = from;
            this.to = to;
        }

        public boolean condition(Row row) {
            return true;
        }

        @Override
        public Iterator<Row> iterator() {
            return new Iterator<Row>(){
                int index;
                Row next;
                boolean queryNext;
                {
                    this.index = TableIterable.this.from;
                    this.next = null;
                    this.queryNext = true;
                }

                @Override
                public boolean hasNext() {
                    if (this.queryNext) {
                        this.next = this.findNext();
                        this.queryNext = false;
                    }
                    return this.next != null;
                }

                @Override
                public Row next() {
                    if (this.queryNext) {
                        this.next = this.findNext();
                    }
                    this.queryNext = true;
                    return this.next;
                }

                private Row findNext() {
                    while (this.index <= TableIterable.this.to) {
                        Object object = StatisticsDataFrame.this.dataFrame.getRowKey(this.index);
                        if (TableIterable.this.condition(object)) {
                            ++this.index;
                            return object;
                        }
                        ++this.index;
                    }
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

