/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.tablelens;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.high_d.tablelens.TableLens;
import com.macrofocus.high_d.tablelens.TableLensController;
import com.macrofocus.high_d.tablelens.TableLensModel;
import com.macrofocus.high_d.tablelens.TableLensView;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;

public abstract class AbstractTableLens<Component, Color, R, C>
implements TableLens<Component, Color, R, C> {
    protected static LicenseModel licenseModel;
    private TableLensModel<Color, R, C> model;
    protected TableLensView<Component, Color, R, C> view;
    protected TableLensController<Component, Color, R, C> controller;

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.HIGHD_API_V1, username, key);
    }

    protected void load(DataFrame dataFrame) {
        this.setModel(this.createModel(dataFrame));
    }

    @Override
    public TableLensModel getModel() {
        return this.model;
    }

    @Override
    public void setModel(TableLensModel model) {
        if (this.model != model) {
            this.model = model;
            if (this.view != null) {
                this.view.setModel(model);
            }
        }
    }

    @Override
    public TableLensView<Component, Color, R, C> getView() {
        return this.view;
    }

    @Override
    public void setView(TableLensView<Component, Color, R, C> view) {
        if (this.view != view) {
            if (this.view != null) {
                this.view.setModel(null);
            }
            this.view = view;
            if (view != null) {
                view.setModel(this.model);
                this.view.setLicenseModel(licenseModel);
            }
        }
    }

    @Override
    public TableLensController getController() {
        return this.controller;
    }

    @Override
    public void setController(TableLensController controller) {
        if (this.controller != controller) {
            if (this.controller != null) {
                this.controller.setView(null);
            }
            this.controller = controller;
            if (controller != null) {
                controller.setView(this.view);
            }
        }
    }

    protected abstract TableLensModel<Color, R, C> createModel(DataFrame var1);

    protected abstract TableLensView<Component, Color, R, C> createView();

    protected abstract TableLensController createController(TableLensView var1);
}

