/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.tablelens;

import com.macrofocus.coloring.MutableColoring;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.SimpleProperties;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.filter.FilterEvent;
import com.macrofocus.filter.FilterListener;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.high_d.axis.Alignment;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.group.DefaultAxisGroupModel;
import com.macrofocus.high_d.axis.locations.AxisLocations;
import com.macrofocus.high_d.axis.locations.DefaultAxisLocations;
import com.macrofocus.high_d.tablelens.AbstractTableLensModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.dataframe.DataFrameListener;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.UniqueIndex;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import com.macrofocus.visual.Visual;
import com.macrofocus.visual.VisualObjects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DefaultTableLensModel<Color, Row, C>
extends AbstractTableLensModel<Color, Row, C>
implements VisualObjects<Row> {
    private final DataFrame<Row, C, ?> dataFrame;
    private final Visual<Color, Row, C> visual;
    private final AxisGroupModel<Row, C> axisGroupModel;
    private final AxisLocations axisLocations;
    private AxisModel order = null;
    private List<Row> sortedRows = null;
    private UniqueIndex<Row> index = null;
    private RowComparator rowComparator;
    private boolean rowsDirty = true;
    private boolean sortedRowsDirty = true;
    private final MutableProperties properties = new SimpleProperties();
    private final Property<Integer> maxDimensions = this.properties.createProperty((Object)"maxDimensions", (Object)Integer.MAX_VALUE);
    private MutableProperty<Boolean> showFiltered = this.properties.createProperty((Object)"showFiltered", (Object)Boolean.TRUE);
    private final CPTimer _timer;

    public DefaultTableLensModel(CPFactory factory, ColorMapFactory<Color> colorMapFactory, DataFrame<Row, C, ?> dataFrame) {
        this(factory, dataFrame, (Visual<Color, Row, C>)new SimpleVisual((VisualObjects)new SimpleVisualObjects(dataFrame), (MutableColorMapping)new SimpleColorMapping(colorMapFactory, dataFrame)));
    }

    public DefaultTableLensModel(CPFactory factory, DataFrame<Row, C, ?> dataFrame, Visual<Color, Row, C> visual) {
        this(factory, dataFrame, visual, (AxisGroupModel<Row, C>)new DefaultAxisGroupModel(factory, "Root", dataFrame, null, (SingleSelection)visual.getProbing(), (Selection)visual.getSelection(), (MutableFilter)visual.getFilter()));
    }

    public DefaultTableLensModel(CPFactory factory, DataFrame<Row, C, ?> dataFrame, Visual<Color, Row, C> visual, AxisGroupModel<Row, C> axisGroupModel) {
        this.dataFrame = dataFrame;
        this.axisGroupModel = axisGroupModel;
        this._timer = factory.createTimer("TableLensUpdater", 10, true, new CPTimerListener(){

            public void timerTriggered() {
                DefaultTableLensModel.this.updateRows();
                DefaultTableLensModel.this.firedTableLensChanged();
            }
        });
        this.axisLocations = new DefaultAxisLocations(axisGroupModel.getAxisOrder(), this.maxDimensions);
        this.visual = visual;
        visual.getFilter().addFilterListener(new FilterListener<Row>(){

            public void filterChanged(FilterEvent<Row> event) {
                if (!((Boolean)DefaultTableLensModel.this.showFiltered.getValue()).booleanValue()) {
                    DefaultTableLensModel.this._timer.restart();
                }
            }
        });
        this.properties.addPropertiesListener((PropertiesListener)new PropertiesListener<String>(){

            public void propertyChanged(String name, PropertyEvent event) {
                DefaultTableLensModel.this._timer.restart();
            }
        });
        this.rowComparator = new RowComparator(this.order);
        dataFrame.addDataFrameListener(new DataFrameListener(){

            public void dataFrameChanged(DataFrameEvent e) {
                DefaultTableLensModel.this.updateRows();
                DefaultTableLensModel.this.firedTableLensChanged();
            }
        });
        this.updateRows();
    }

    private void updateRows() {
        this.rowsDirty = true;
        this.updateOrder();
    }

    private void updateOrder() {
        this.sortedRowsDirty = true;
    }

    @Override
    public synchronized UniqueIndex<Row> getSortedRows() {
        if (this.rowsDirty || this.sortedRowsDirty) {
            List<Row> sortedRows;
            if (this.rowsDirty) {
                sortedRows = new ArrayList<Row>();
                for (Object row : this.dataFrame.rows()) {
                    if (!((Boolean)this.showFiltered.getValue()).booleanValue() && this.visual.getFilter().isFiltered(row)) continue;
                    sortedRows.add(row);
                }
                this.rowsDirty = false;
            } else {
                sortedRows = this.sortedRows;
            }
            if (this.sortedRowsDirty) {
                Collections.sort(sortedRows, this.rowComparator);
                this.sortedRowsDirty = false;
            }
            this.sortedRows = sortedRows;
            this.index = new DefaultUniqueIndex(sortedRows);
        }
        return this.index;
    }

    @Override
    public Visual<Color, Row, C> getVisual() {
        return this.visual;
    }

    @Override
    public int getObjectCount() {
        return this.getSortedRows().getSize();
    }

    @Override
    public MutableSingleSelection<Row> getProbing() {
        return this.visual.getProbing();
    }

    @Override
    public MutableSelection<Row> getSelection() {
        return this.visual.getSelection();
    }

    @Override
    public MutableFilter<Row> getFilter() {
        return this.visual.getFilter();
    }

    @Override
    public MutableColorMapping<Color, Row, C> getColorMapping() {
        return this.visual.getColorMapping();
    }

    @Override
    public MutableColoring<Color, Row> getColoring() {
        return this.visual.getColoring();
    }

    @Override
    public Row getObject(int index) {
        return (Row)this.getSortedRows().getKey(index);
    }

    @Override
    public int getIndex(Row row) {
        return this.getSortedRows().getAddress(row);
    }

    private AxisModel getAxisModel(int c) {
        return (AxisModel)this.axisGroupModel.getAxisOrder().get(c);
    }

    @Override
    public int getAxisCount() {
        return this.axisGroupModel.getAxisOrder().size();
    }

    @Override
    public Iterable<AxisModel> getSelectedAxis() {
        ArrayList<AxisModel> list = new ArrayList<AxisModel>();
        return list;
    }

    @Override
    public Double getLocation(AxisModel axisModel) {
        return this.axisLocations.getLocation(Alignment.Left, axisModel);
    }

    @Override
    public AxisGroupModel getAxisGroupModel() {
        return this.axisGroupModel;
    }

    @Override
    public void setLocation(AxisModel axisModel, double l) {
        this.axisLocations.setLocation(Alignment.Left, axisModel, l);
        this.firedTableLensChanged();
    }

    @Override
    public Property<Boolean> getShowFiltered() {
        return this.showFiltered;
    }

    @Override
    public void setShowFiltered(MutableProperty<Boolean> showFiltered) {
        this.showFiltered = showFiltered;
        this.properties.replaceProperty((Object)"showFiltered", showFiltered);
    }

    @Override
    public void setOrder(AxisModel axisModel) {
        if (this.order != axisModel) {
            this.order = axisModel;
            this.rowComparator = new RowComparator(axisModel);
            this.updateOrder();
            this.firedTableLensChanged();
        }
    }

    private class RowComparator
    implements Comparator<Row> {
        private final AxisModel axisModel;

        public RowComparator(AxisModel axisModel) {
            this.axisModel = axisModel;
        }

        @Override
        public int compare(Row o1, Row o2) {
            if (this.axisModel != null) {
                Number v1 = this.axisModel.getValue(o1);
                if (v1 != null) {
                    Number v2 = this.axisModel.getValue(o2);
                    if (v2 != null) {
                        int c = Double.compare(v1.doubleValue(), v2.doubleValue());
                        if (c == 0) {
                            if (o1 instanceof Comparable) {
                                return ((Comparable)o1).compareTo(o2);
                            }
                            return Integer.compare(DefaultTableLensModel.this.dataFrame.getRowAddress(o1), DefaultTableLensModel.this.dataFrame.getRowAddress(o2));
                        }
                        return -c;
                    }
                    return -1;
                }
                Number v2 = this.axisModel.getValue(o2);
                if (v2 != null) {
                    return 1;
                }
                if (o1 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return Integer.compare(DefaultTableLensModel.this.dataFrame.getRowAddress(o1), DefaultTableLensModel.this.dataFrame.getRowAddress(o2));
            }
            if (o1 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            return Integer.compare(DefaultTableLensModel.this.dataFrame.getRowAddress(o1), DefaultTableLensModel.this.dataFrame.getRowAddress(o2));
        }
    }
}

