/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.javafx;

import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.javafx.JavaFXColorMapFactory;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.igraphics.CPImageFactory;
import com.macrofocus.igraphics.javafx.JavaFXImageFactory;
import com.macrofocus.license.SimpleLicenseModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.treemap.AbstractTreeMap;
import com.treemap.DefaultTreeMapModel;
import com.treemap.TreeMapController;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.javafx.JavaFXTreeMapController;
import com.treemap.javafx.JavaFXTreeMapView;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class JavaFXTreeMap<N, Row, Column>
extends AbstractTreeMap<Node, N, Row, Column, Color, Font> {
    private final StackPane nativeComponent = new StackPane();

    public JavaFXTreeMap() {
        this.view = this.createView();
        this.view.setLicenseModel(licenseModel);
        this.controller = this.createController(this.view);
        this.nativeComponent.getChildren().add((Object)((Node)this.view.getNativeComponent()));
    }

    public JavaFXTreeMap(TreeMapModel<N, Row, Column, Color, Font> model) {
        this();
        this.setModel(model);
    }

    public JavaFXTreeMap(DataFrame<Row, Column, ?> dataFrame) {
        this();
        this.load(dataFrame);
    }

    public static void setLicenseKey(String username, String key) {
        licenseModel = new SimpleLicenseModel(ApplicationModelFactory.TREEMAP_API, username, key);
    }

    void load(DataFrame<Row, Column, ?> dataFrame) {
        this.setModel(this.createTreeMapModel(dataFrame));
    }

    protected TreeMapModel<N, Row, Column, Color, Font> createTreeMapModel(DataFrame<Row, Column, ?> dataFrame) {
        return new DefaultTreeMapModel(dataFrame, (CPFactory)JavaFXFactory.getInstance(), (ColorMapFactory)JavaFXColorMapFactory.getInstance(), (CPImageFactory)JavaFXImageFactory.getInstance());
    }

    protected TreeMapView<Node, N, Row, Column, Color, Font> createView() {
        JavaFXTreeMapView view = new JavaFXTreeMapView();
        return view;
    }

    protected TreeMapController<Node, N, Row, Column, Color, Font> createController(TreeMapView<Node, N, Row, Column, Color, Font> view) {
        return new JavaFXTreeMapController<N, Row, Column>(view);
    }

    public Node getNativeComponent() {
        return this.nativeComponent;
    }
}

