/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.javafx.treetable;

import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.treemap.TreeMapEvent;
import com.treemap.TreeMapField;
import com.treemap.TreeMapListener;
import com.treemap.TreeMapModel;
import com.treemap.treetable.AbstractTreeTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTablePosition;
import javafx.scene.control.TreeTableView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class JavaFXTreeTable<N, Row, Column>
extends AbstractTreeTable<Node, N, Row, Column, Color, Font> {
    private final StackPane nativeComponent;
    private final TreeMapModel<N, Row, Column, Color, Font> treeMapModel;
    private final TreeTableView<N> treeTableView;
    private final Map<N, TreeItem<N>> map = new HashMap<N, TreeItem<N>>();

    public JavaFXTreeTable(final TreeMapModel<N, Row, Column, Color, Font> treeMapModel) {
        this.treeMapModel = treeMapModel;
        this.nativeComponent = new StackPane();
        this.treeTableView = new TreeTableView();
        this.treeTableView.setShowRoot(false);
        this.nativeComponent.getChildren().add(this.treeTableView);
        ArrayList<TreeTableColumn> columns = new ArrayList<TreeTableColumn>();
        for (Object column : treeMapModel.columns()) {
            TreeMapField field = treeMapModel.getTreeMapField(column);
            TreeTableColumn c = new TreeTableColumn(treeMapModel.getColumnName(column));
            c.setCellValueFactory(param -> {
                Object node = param.getValue().getValue();
                TreeTableColumn hierarchyTreeTableColumn = this.treeTableView.getTreeColumn();
                if (hierarchyTreeTableColumn == null) {
                    hierarchyTreeTableColumn = (TreeTableColumn)this.treeTableView.getColumns().get(0);
                }
                Object value = c == hierarchyTreeTableColumn ? treeMapModel.getLabelName(node) : treeMapModel.getAggregateValue(node, field);
                return new ReadOnlyObjectWrapper(value);
            });
            columns.add(c);
        }
        this.treeTableView.getColumns().setAll(columns);
        treeMapModel.addListener(new TreeMapListener(){

            public void tableModelChanged() {
            }

            public void treeMapChanged(TreeMapEvent event) {
                if (event.isGroupByChanged()) {
                    Object currentRoot = treeMapModel.getCurrentRoot();
                    TreeItem<Object> treeItem = JavaFXTreeTable.this.createTreeItem(currentRoot);
                    Platform.runLater(() -> JavaFXTreeTable.this.treeTableView.setRoot(treeItem));
                }
            }
        });
        Object currentRoot = treeMapModel.getCurrentRoot();
        TreeItem<Object> treeItem = this.createTreeItem(currentRoot);
        this.treeTableView.setRoot(treeItem);
        treeMapModel.getSelection().addSelectionListener(new SelectionListener<N>(){

            public void selectionChanged(SelectionEvent<N> event) {
                for (final Object n : event.getUnselected()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TreeItem<Object> treeItem = JavaFXTreeTable.this.createTreeItem(n);
                            int row = JavaFXTreeTable.this.treeTableView.getRow(treeItem);
                            JavaFXTreeTable.this.treeTableView.getSelectionModel().clearSelection(row);
                            System.err.println("Unselecting " + String.valueOf(treeItem) + ", " + row);
                        }
                    });
                }
                for (final Object n : event.getSelected()) {
                    TreeItem treeItem = JavaFXTreeTable.this.createTreeItem(n);
                    JavaFXTreeTable.this.expandParent(treeItem);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TreeItem<Object> treeItem = JavaFXTreeTable.this.createTreeItem(n);
                            int row = JavaFXTreeTable.this.treeTableView.getRow(treeItem);
                            JavaFXTreeTable.this.treeTableView.scrollTo(row);
                            JavaFXTreeTable.this.treeTableView.getSelectionModel().select(row);
                            System.err.println("Selecting " + String.valueOf(treeItem) + ", " + row);
                        }
                    });
                }
            }
        });
    }

    private void expandParent(TreeItem<N> item) {
        Object parentNode = this.treeMapModel.getParent(item.getValue());
        if (parentNode != null) {
            final TreeItem<Object> parent = this.createTreeItem(parentNode);
            this.expandParent(parent);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    parent.setExpanded(true);
                    System.err.println("Expanding " + String.valueOf(parent));
                }
            });
        }
    }

    private TreeItem<N> createTreeItem(N node) {
        if (this.map.containsKey(node)) {
            return this.map.get(node);
        }
        NTreeItem treeItem = new NTreeItem(node);
        this.map.put(node, treeItem);
        return treeItem;
    }

    public Node getNativeComponent() {
        return this.nativeComponent;
    }

    private class NTreeItem
    extends TreeItem<N> {
        private boolean isLeaf;
        private boolean isFirstTimeChildren;
        private boolean isFirstTimeLeaf;

        public NTreeItem(N f) {
            super(f);
            this.isFirstTimeChildren = true;
            this.isFirstTimeLeaf = true;
        }

        public ObservableList<TreeItem<N>> getChildren() {
            if (this.isFirstTimeChildren) {
                this.isFirstTimeChildren = false;
                super.getChildren().setAll(this.buildChildren(this));
            }
            return super.getChildren();
        }

        public boolean isLeaf() {
            if (this.isFirstTimeLeaf) {
                this.isFirstTimeLeaf = false;
                Object f = this.getValue();
                this.isLeaf = JavaFXTreeTable.this.treeMapModel.hasNoChildren(f);
            }
            return this.isLeaf;
        }

        private ObservableList<TreeItem<N>> buildChildren(TreeItem<N> treeItem) {
            Iterable files;
            Object f = treeItem.getValue();
            if (f != null && !JavaFXTreeTable.this.treeMapModel.hasNoChildren(f) && (files = JavaFXTreeTable.this.treeMapModel.getChildren(f)) != null) {
                ObservableList children = FXCollections.observableArrayList();
                for (Object childFile : files) {
                    children.add(JavaFXTreeTable.this.createTreeItem(childFile));
                }
                return children;
            }
            return FXCollections.emptyObservableList();
        }

        public int hashCode() {
            return this.getValue().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj != null) {
                return this.getValue().equals(((TreeItem)obj).getValue());
            }
            return false;
        }
    }

    private static class TreeMapTreeTableViewSelectionModel
    extends TreeTableView.TreeTableViewSelectionModel {
        public TreeMapTreeTableViewSelectionModel(TreeTableView treeTableView) {
            super(treeTableView);
        }

        public ObservableList<TreeTablePosition> getSelectedCells() {
            return null;
        }

        public boolean isSelected(int row, TableColumnBase column) {
            return false;
        }

        public void select(int row, TableColumnBase column) {
        }

        public void clearAndSelect(int row, TableColumnBase column) {
        }

        public void clearSelection(int row, TableColumnBase column) {
        }

        public void selectLeftCell() {
        }

        public void selectRightCell() {
        }

        public void selectAboveCell() {
        }

        public void selectBelowCell() {
        }
    }
}

