/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;

public class RectangularTransform {
    double a = 0.0;
    double b = 0.0;
    double c = 1.0;
    double d = 1.0;

    public RectangularTransform() {
    }

    public RectangularTransform(Rectangle2D oldRect, Rectangle2D newRect) {
        this.setTransform(oldRect, newRect);
    }

    public RectangularTransform(double sx, double sy, double tx, double ty) {
        this.c = sx;
        this.d = sy;
        this.a = tx;
        this.b = ty;
    }

    public Rectangle2D transform(Rectangle2D src) {
        return new Rectangle2D.Double(src.getX() * this.c + this.a, src.getY() * this.d + this.b, src.getWidth() * this.c, src.getHeight() * this.d);
    }

    public Point2D transform(Point2D src) {
        return new Point2D.Double(src.getX() * this.c + this.a, src.getY() * this.d + this.b);
    }

    public static AffineTransform create(Rectangle2D oldRect, Rectangle2D newRect) {
        double d2 = newRect.getWidth() / oldRect.getWidth();
        double d3 = newRect.getHeight() / oldRect.getHeight();
        double d4 = -oldRect.getX() * d2 + newRect.getX();
        double d5 = -oldRect.getY() * d3 + newRect.getY();
        return new AffineTransform(d2, 0.0, 0.0, d3, d4, d5);
    }

    public void setTransform(Rectangle2D oldRect, Rectangle2D newRect) {
        this.c = newRect.getWidth() / oldRect.getWidth();
        this.d = newRect.getHeight() / oldRect.getHeight();
        this.a = -oldRect.getX() * this.c + newRect.getX();
        this.b = -oldRect.getY() * this.d + newRect.getY();
    }

    public void translate(double tx, double ty) {
        this.a = tx * this.c + this.a;
        this.b = ty * this.d + this.b;
    }

    public double getScaleX() {
        return this.c;
    }

    public double getScaleY() {
        return this.d;
    }

    public double getTranslateX() {
        return this.a;
    }

    public double getTranslateY() {
        return this.b;
    }

    public void scale(double sx, double sy) {
        this.c *= sx;
        this.d *= sy;
    }

    public AffineTransform createAffineTransform() {
        return new AffineTransform(this.c, 0.0, 0.0, this.d, this.a, this.b);
    }

    public RectangularTransform createInverse() {
        return new RectangularTransform(1.0 / this.c, 1.0 / this.d, -this.a / this.c, -this.b / this.d);
    }
}

