/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.distributions.javafx;

import com.macrofocus.crossplatform.AbsoluteCPContainer;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.Layout;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.crossplatform.javafx.JavaFXAbsoluteContainer;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.distributions.AbstractDistributionsView;
import com.macrofocus.high_d.distributions.DistributionsComponent;
import com.macrofocus.high_d.distributions.javafx.JavaFXDistributionsComponent;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.molap.subset.DistributionDimension;
import com.macrofocus.order.MutableVisibleOrder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.paint.Color;

public class JavaFXDistributionsView<Row, Column, Value, Bin>
extends AbstractDistributionsView<Node, Color, Row, Column, Value, Bin> {
    private final JavaFXAbsoluteContainer nativeComponent;
    private final DistributionsComponent<Node, Color, Row, Column, Value, Bin> distributionsComponent;
    private final Map<AxisModel, Button> axisLabels = new HashMap<AxisModel, Button>();

    public JavaFXDistributionsView(CPColorFactory<Color> factory) {
        super(factory);
        this.nativeComponent = new JavaFXAbsoluteContainer(new Layout(){

            public void layout(AbsoluteCPContainer container, int width, int height) {
                JavaFXDistributionsView.this.runLayout();
            }
        });
        this.distributionsComponent = new JavaFXDistributionsComponent(this);
        this.nativeComponent.addComponent(this.distributionsComponent);
    }

    protected void refresh() {
        this.runLayout();
    }

    protected DistributionsComponent getDistributionsComponent() {
        return this.distributionsComponent;
    }

    public DistributionDimension<Row, Value, Bin> getClosestDistribution(int x, int y) {
        Bounds b = ((Node)this.distributionsComponent.getNativeComponent()).getBoundsInParent();
        if (b.contains((double)x, (double)y)) {
            return this.distributionsComponent.getClosestDistribution((int)((double)x - b.getMinX()), (int)((double)y - b.getMinY()));
        }
        return null;
    }

    public Bin getClosestBin(int x, int y) {
        Bounds b = ((Node)this.distributionsComponent.getNativeComponent()).getBoundsInParent();
        if (b.contains((double)x, (double)y)) {
            return (Bin)this.distributionsComponent.getClosestBin((int)((double)x - b.getMinX()), (int)((double)y - b.getMinY()));
        }
        return null;
    }

    public List<Bin> getBins(Rectangle2D rect) {
        Bounds b = ((Node)this.distributionsComponent.getNativeComponent()).getBoundsInParent();
        if (b.contains(rect.getX(), rect.getY())) {
            return this.distributionsComponent.getBins((Rectangle2D)new Rectangle2D.Double(rect.getX() - b.getMinX(), rect.getY() - b.getMinY(), rect.getWidth(), rect.getHeight()));
        }
        return null;
    }

    public Row getClosestRow(int x, int y) {
        Bounds b = ((Node)this.distributionsComponent.getNativeComponent()).getBoundsInParent();
        if (b.contains((double)x, (double)y)) {
            return (Row)this.distributionsComponent.getClosestRow((int)((double)x - b.getMinX()), (int)((double)y - b.getMinY()));
        }
        return null;
    }

    public void setLicenseModel(LicenseModel licenseModel) {
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractJavaFXComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public void addMouseListener(CPCanvas.MouseListener l) {
        this.nativeComponent.addMouseListener(l);
    }

    public void addMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.nativeComponent.addMouseMotionListener(l);
    }

    public void removeMouseListener(CPCanvas.MouseListener l) {
        this.nativeComponent.removeMouseListener(l);
    }

    public void removeMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.nativeComponent.removeMouseMotionListener(l);
    }

    public Node getNativeComponent() {
        return this.nativeComponent.getNativeComponent();
    }

    private void runLayout() {
        if (this.getModel() != null) {
            double headerMaximumHeight = 0.0;
            MutableVisibleOrder axisOrder = this.getModel().getAxisGroupModel().getAxisOrder();
            for (AxisModel axisModel : axisOrder.iterableAll()) {
                assert (axisModel != null);
                Button header = this.getHeader(axisModel);
                if (axisOrder.isVisible((Object)axisModel)) {
                    int i = axisOrder.indexOf((Object)axisModel);
                    Double x1Location = this.getModel().getLocation(axisModel);
                    Double x2Location = i + 1 < axisOrder.size() ? this.getModel().getLocation((AxisModel)axisOrder.get(i + 1)) : Double.valueOf(1.0);
                    if (x1Location != null && x2Location != null) {
                        double x = x1Location * (double)this.getWidth();
                        double y = 0.0;
                        double width = x2Location * (double)this.getWidth() - x;
                        double height = header.prefHeight(width);
                        headerMaximumHeight = Math.max(height, headerMaximumHeight);
                        header.resizeRelocate(x, y, width, height);
                    }
                    header.setVisible(true);
                    continue;
                }
                header.setVisible(false);
            }
            ((Node)this.distributionsComponent.getNativeComponent()).resizeRelocate(0.0, headerMaximumHeight, (double)this.getWidth(), (double)this.getHeight() - headerMaximumHeight);
            this.distributionsComponent.scheduleUpdate();
        }
    }

    public Button getHeader(AxisModel axisModel) {
        if (!this.axisLabels.containsKey(axisModel)) {
            Button label = this.createAxisHeaderView(axisModel);
            this.nativeComponent.addComponent(JavaFXFactory.getInstance().createComponent((Node)label));
            this.axisLabels.put(axisModel, label);
        }
        return this.axisLabels.get(axisModel);
    }

    protected Button createAxisHeaderView(AxisModel axisModel) {
        Button button = new Button(axisModel.getName());
        return button;
    }

    public int getWidth() {
        return (int)this.nativeComponent.getWidth();
    }

    public int getHeight() {
        return (int)this.nativeComponent.getHeight();
    }
}

