/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates.javafx;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.crossplatform.AbsoluteCPContainer;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPRectangle;
import com.macrofocus.crossplatform.Layout;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.crossplatform.javafx.JavaFXAbsoluteContainer;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.hierarchy.Hierarchy;
import com.macrofocus.hierarchy.HierarchyEvent;
import com.macrofocus.hierarchy.HierarchyListener;
import com.macrofocus.high_d.axis.AxisListener;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.AxisView;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.group.AxisGroupView;
import com.macrofocus.high_d.axis.javafx.JavaFXAxisView;
import com.macrofocus.high_d.parallelcoordinates.AbstractParallelCoordinatesView;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesComponent;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesListener;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesView;
import com.macrofocus.high_d.parallelcoordinates.geometry.Geometry;
import com.macrofocus.high_d.parallelcoordinates.javafx.JavaFXAxisComponents;
import com.macrofocus.high_d.parallelcoordinates.javafx.JavaFXParallelCoordinatesComponent;
import com.macrofocus.high_d.parallelcoordinates.layout.DefaultParallelCoordinatesLayoutEngine;
import com.macrofocus.high_d.parallelcoordinates.layout.ParallelCoordinatesLayout;
import com.macrofocus.high_d.parallelcoordinates.layout.ParallelCoordinatesLayoutEngine;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.order.OrderEvent;
import com.macrofocus.order.OrderListener;
import com.macrofocus.order.VisibleOrder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.paint.Color;

public class JavaFXParallelCoordinatesView<Row, C>
extends AbstractParallelCoordinatesView<Node, Color, Row, C> {
    private final JavaFXAbsoluteContainer nativeComponent;
    private ParallelCoordinatesModel<Color, Row, C> model;
    private final Map<AxisModel, JavaFXAxisComponents> axisComponents = new HashMap<AxisModel, JavaFXAxisComponents>();
    private final Map<AxisGroupModel, AxisGroupView> axisGroupViews = new HashMap<AxisGroupModel, AxisGroupView>();
    private final Map<Integer, ParallelCoordinatesComponent<Node, Color, Row, C>> parallelCoordinatesComponents = new HashMap<Integer, ParallelCoordinatesComponent<Node, Color, Row, C>>();
    private AxisView draggedAxisView;
    private int draggedLocation;
    private boolean isSelectionMode = true;
    private int headerMaximumHeight = 24;
    private final ParallelCoordinatesLayoutEngine layoutEngine = new DefaultParallelCoordinatesLayoutEngine((ParallelCoordinatesView)this);
    private ParallelCoordinatesLayout layout;
    private final PropertiesListener<ParallelCoordinatesView.PropertyType> propertiesListener = new PropertiesListener<ParallelCoordinatesView.PropertyType>(){

        public void propertyChanged(ParallelCoordinatesView.PropertyType name, PropertyEvent event) {
            if (name == ParallelCoordinatesView.PropertyType.Geometry) {
                JavaFXParallelCoordinatesView.this.refresh();
            }
            JavaFXParallelCoordinatesView.this.createOverPlots();
        }
    };
    private final ParallelCoordinatesListener listener = new ParallelCoordinatesListener(){

        public void pararallelCoordinatesChanged() {
            JavaFXParallelCoordinatesView.this.reset();
        }
    };
    private final AxisListener axisListener = new AxisListener(){

        public void axisChanged() {
            JavaFXParallelCoordinatesView.this.refresh();
        }
    };
    private final HierarchyListener axisGroupHierarchyListener = new HierarchyListener(){

        public void hierarchyNodeInserted(HierarchyEvent event) {
            this.update(event);
        }

        public void hierarchyNodeChanged(HierarchyEvent event) {
            this.update(event);
        }

        public void hierarchyNodeRemoved(HierarchyEvent event) {
            this.update(event);
        }

        public void hierarchyStructureChanged(HierarchyEvent event) {
            this.update(event);
        }

        private void update(HierarchyEvent e) {
            JavaFXParallelCoordinatesView.this.refresh();
        }
    };
    private final OrderListener orderListener = new OrderListener<AxisModel<Row, C>>(){

        public void orderChanged(OrderEvent<AxisModel<Row, C>> event) {
            JavaFXParallelCoordinatesView.this.refresh();
        }

        public void orderVisibility(OrderEvent<AxisModel<Row, C>> event) {
            if (!((VisibleOrder)event.getModel()).isVisible(event)) {
                for (AxisModel axisModel : event.getAffected()) {
                }
            }
            JavaFXParallelCoordinatesView.this.refresh();
        }

        public void orderAdded(OrderEvent<AxisModel<Row, C>> event) {
            JavaFXParallelCoordinatesView.this.refresh();
        }

        public void orderRemoved(OrderEvent<AxisModel<Row, C>> event) {
            for (AxisModel axisModel : event.getAffected()) {
            }
            JavaFXParallelCoordinatesView.this.refresh();
        }
    };
    private final PropertyListener<CPCanvas.Rendering> renderingListener = new PropertyListener<CPCanvas.Rendering>(){

        public void propertyChanged(PropertyEvent<CPCanvas.Rendering> event) {
            JavaFXParallelCoordinatesView.this.createOverPlots();
        }
    };
    private final PropertyListener<Geometry> geometryListener = new PropertyListener<Geometry>(){

        public void propertyChanged(PropertyEvent<Geometry> event) {
            JavaFXParallelCoordinatesView.this.refresh();
        }
    };

    public JavaFXParallelCoordinatesView() {
        super((CPColorFactory)JavaFXFactory.getInstance());
        this.nativeComponent = new JavaFXAbsoluteContainer(new Layout(){

            public void layout(AbsoluteCPContainer container, int width, int height) {
                JavaFXParallelCoordinatesView.this.runLayout();
            }
        });
        this.properties.addPropertiesListener(this.propertiesListener);
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractJavaFXComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public void addMouseListener(CPCanvas.MouseListener l) {
        this.nativeComponent.addMouseListener(l);
    }

    public void addMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.nativeComponent.addMouseMotionListener(l);
    }

    public void removeMouseListener(CPCanvas.MouseListener l) {
        this.nativeComponent.removeMouseListener(l);
    }

    public void removeMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.nativeComponent.removeMouseMotionListener(l);
    }

    private void repaint() {
    }

    private void refresh() {
        this.runLayout();
        for (ParallelCoordinatesComponent<Node, Color, Row, C> parallelCoordinatesComponent : this.parallelCoordinatesComponents.values()) {
            parallelCoordinatesComponent.clearCache();
            parallelCoordinatesComponent.scheduleUpdate();
        }
        this.repaint();
    }

    private void reset() {
        if (this.model != null) {
            this.runLayout();
            for (ParallelCoordinatesComponent<Node, Color, Row, C> parallelCoordinatesComponent : this.parallelCoordinatesComponents.values()) {
                parallelCoordinatesComponent.reset();
                parallelCoordinatesComponent.scheduleUpdate();
            }
            this.repaint();
        }
    }

    public JavaFXParallelCoordinatesView(ParallelCoordinatesModel model) {
        this();
        this.setModel(model);
    }

    public Node getNativeComponent() {
        return this.nativeComponent.getNativeComponent();
    }

    public int getWidth() {
        return (int)this.nativeComponent.getWidth();
    }

    public int getHeight() {
        return (int)this.nativeComponent.getHeight();
    }

    public boolean isShowTiming() {
        return (Boolean)this.properties.getProperty((Object)ParallelCoordinatesView.PropertyType.ShowTiming).getValue();
    }

    public void setShowTiming(boolean showTiming) {
        this.properties.getProperty((Object)ParallelCoordinatesView.PropertyType.ShowTiming).setValue((Object)showTiming);
        this.repaint();
    }

    public void setLicenseModel(LicenseModel licenseModel) {
    }

    public ParallelCoordinatesLayout getParallelCoordinatesLayout() {
        return this.layout;
    }

    public ParallelCoordinatesModel getModel() {
        return this.model;
    }

    public void setModel(ParallelCoordinatesModel model) {
        Object groupHierarchy;
        if (this.model != null) {
            this.model.removeParallelCoordinateListener(this.listener);
            groupHierarchy = this.model.getAxisHierarchy().getAxisGroupHierarchy();
            groupHierarchy.removeHierarchyListener(this.axisGroupHierarchyListener);
            ((AxisGroupModel)groupHierarchy.getRoot()).getAxisOrder().removeOrderListener(this.orderListener);
        }
        this.model = model;
        this.axisComponents.clear();
        for (ParallelCoordinatesComponent parallelCoordinatesComponent : this.parallelCoordinatesComponents.values()) {
            parallelCoordinatesComponent.setModel(null);
        }
        this.parallelCoordinatesComponents.clear();
        if (this.model != null) {
            model.addParallelCoordinatesListener(this.listener);
            groupHierarchy = this.model.getAxisHierarchy().getAxisGroupHierarchy();
            groupHierarchy.addHierarchyListener(this.axisGroupHierarchyListener);
            ((AxisGroupModel)groupHierarchy.getRoot()).getAxisOrder().addOrderListener(this.orderListener);
            for (AxisGroupModel groupModel : groupHierarchy.breadthFirstIterator()) {
                for (AxisModel axisModel : groupModel.getAxisOrder()) {
                    this.getAxisComponents(axisModel);
                }
            }
        }
        this.refresh();
    }

    public void runLayout() {
        if (this.getWidth() > 0 && this.getHeight() > 0) {
            AxisView axisView = this.createDummyAxisView();
            this.layout = this.layoutEngine.doLayout(axisView.getPreferredWidth(), axisView.getBeforeTrackGap(), axisView.getAfterTrackGap());
            if (this.nativeComponent.getHeight() <= 0.0 || this.nativeComponent.getWidth() <= 0.0) {
                return;
            }
            for (int l = 0; l < this.layout.getLevelCount(); ++l) {
                Rectangle2D bounds = this.layout.getLevelBounds(l);
                if (bounds == null) continue;
                ParallelCoordinatesComponent<Node, Color, Row, C> component = this.getParallelCoordinatesComponent(l);
                component.clearCache();
                this.nativeComponent.setBounds(component, JavaFXFactory.getInstance().createRectangle((int)bounds.getX(), (int)bounds.getY(), (int)bounds.getWidth(), (int)bounds.getHeight()));
                component.scheduleUpdate();
            }
            for (AxisGroupModel axisGroup : this.model.getAxisHierarchy().getAxisGroupHierarchy().breadthFirstIterator()) {
                this.doLayout(this.model.getAxisHierarchy().getAxisGroupHierarchy(), axisGroup);
            }
        }
    }

    protected AxisView createDummyAxisView() {
        return new JavaFXAxisView();
    }

    private void doLayout(Hierarchy<AxisGroupModel<Row, C>> hierarchy, AxisGroupModel<Row, C> axisGroup) {
        AxisGroupView axisGroupView = this.getAxisGroupView(axisGroup);
        if (axisGroupView != null) {
            Iterator iterator = this.layout.getHeaderBounds(axisGroup);
        }
        for (AxisModel axisModel : axisGroup.getAxisOrder()) {
            AxisView axisView = this.getAndInstallAxisView(axisModel);
            CPComponent<Button> label = this.getLabel(axisModel);
            Rectangle2D headerBounds = this.layout.getHeaderBounds(axisGroup, axisModel);
            this.nativeComponent.setBounds(label, JavaFXFactory.getInstance().createRectangle((int)headerBounds.getX(), (int)headerBounds.getY(), (int)headerBounds.getWidth(), (int)headerBounds.getHeight()));
            Rectangle2D aBounds = this.layout.getSliderBounds(axisGroup, axisView.getModel());
            this.nativeComponent.setBounds((CPComponent)axisView, JavaFXFactory.getInstance().createRectangle((int)aBounds.getX(), (int)aBounds.getY(), (int)aBounds.getWidth(), (int)aBounds.getHeight()));
        }
        for (AxisGroupModel child : hierarchy.getChildren(axisGroup)) {
            this.doLayout(hierarchy, child);
        }
    }

    public int getAxisX(AxisGroupModel axisGroup, AxisModel axisModel) {
        return (int)this.layout.getTrackBounds(axisGroup, axisModel).getX();
    }

    public int getHeaderAxisGroupMaximumHeight() {
        return this.headerMaximumHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParallelCoordinatesComponent<Node, Color, Row, C> getParallelCoordinatesComponent(int level) {
        if (!this.parallelCoordinatesComponents.containsKey(level)) {
            Map<Integer, ParallelCoordinatesComponent<Node, Color, Row, C>> map = this.parallelCoordinatesComponents;
            synchronized (map) {
                JavaFXParallelCoordinatesComponent parallelCoordinatesComponent = new JavaFXParallelCoordinatesComponent((ParallelCoordinatesView)this, level);
                parallelCoordinatesComponent.setModel(this.model);
                this.parallelCoordinatesComponents.put(level, (ParallelCoordinatesComponent<Node, Color, Row, C>)parallelCoordinatesComponent);
                this.nativeComponent.addComponent(parallelCoordinatesComponent, DEFAULT_LAYER.intValue());
            }
        }
        return this.parallelCoordinatesComponents.get(level);
    }

    public int getHeaderAxisMaximumHeight() {
        return this.headerMaximumHeight;
    }

    public void startDragging(AxisView axisView) {
    }

    public void dragAxisTo(AxisView axisView, int location) {
        this.draggedAxisView = axisView;
    }

    public void stopDragging(AxisView axisView) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JavaFXAxisComponents getAxisComponents(final AxisModel axisModel) {
        Map<AxisModel, JavaFXAxisComponents> map = this.axisComponents;
        synchronized (map) {
            if (!this.axisComponents.containsKey(axisModel)) {
                Runnable doRun = new Runnable(){

                    @Override
                    public void run() {
                        axisModel.addAxisListener(JavaFXParallelCoordinatesView.this.axisListener);
                        Button label = JavaFXParallelCoordinatesView.this.createAxisHeaderView(axisModel);
                        JavaFXAxisComponents axisComponents = new JavaFXAxisComponents(label);
                        AxisView axisView = JavaFXParallelCoordinatesView.this.createAxisView(axisModel);
                        axisComponents.setAxisView(axisView);
                        JavaFXParallelCoordinatesView.this.axisComponents.put(axisModel, axisComponents);
                    }
                };
                doRun.run();
            }
            return this.axisComponents.get(axisModel);
        }
    }

    protected void createAxisMouseListener(Button label) {
    }

    protected Button createAxisHeaderView(AxisModel axisModel) {
        return new Button(axisModel.getName());
    }

    protected AxisView createAxisView(AxisModel axisModel) {
        JavaFXAxisView axisView = new JavaFXAxisView(axisModel);
        return axisView;
    }

    public CPComponent<Button> getLabel(AxisModel axisModel) {
        CPComponent<Button> label = this.getAxisComponents(axisModel).getLabel();
        if (((Button)label.getNativeComponent()).getParent() == null) {
            this.nativeComponent.addComponent(label, PALETTE_LAYER.intValue());
        }
        return label;
    }

    public AxisView getAndInstallAxisView(AxisModel axisModel) {
        AxisView axisView = this.getAxisComponents(axisModel).getAxisView();
        if (((Node)axisView.getNativeComponent()).getParent() == null) {
            this.nativeComponent.addComponent((CPComponent)axisView, PALETTE_LAYER.intValue());
        }
        return axisView;
    }

    public AxisView getAxisView(AxisModel axisModel) {
        AxisView axisView = this.getAxisComponents(axisModel).getAxisView();
        return axisView;
    }

    public AxisGroupView getAxisGroupView(AxisGroupModel axisGroup) {
        return this.axisGroupViews.get(axisGroup);
    }

    public void waitUntilReady() {
        for (ParallelCoordinatesComponent<Node, Color, Row, C> parallelCoordinatesComponent : this.parallelCoordinatesComponents.values()) {
            parallelCoordinatesComponent.waitUntilReady();
        }
    }

    public Row getClosestRow(int x, int y) {
        if (this.layout != null) {
            for (int l = 0; l < this.layout.getLevelCount(); ++l) {
                ParallelCoordinatesComponent<Node, Color, Row, C> component = this.getParallelCoordinatesComponent(l);
                CPRectangle b = this.nativeComponent.getBounds(component);
                if (!b.contains((double)x, (double)y)) continue;
                return (Row)component.getClosestRow(x - (int)b.getX(), y - (int)b.getY());
            }
        }
        return null;
    }

    public Collection<Row> getRows(Rectangle2D rect) {
        if (this.layout != null) {
            HashSet list = new HashSet();
            for (int l = 0; l < this.layout.getLevelCount(); ++l) {
                Rectangle2D.Double r;
                List rows;
                ParallelCoordinatesComponent<Node, Color, Row, C> component = this.getParallelCoordinatesComponent(l);
                Node c = (Node)component.getNativeComponent();
                Bounds b = c.getLayoutBounds();
                Rectangle2D.Double cb = new Rectangle2D.Double(b.getMinX(), b.getMinY(), b.getWidth(), b.getHeight());
                if (!cb.intersects(rect) || (rows = component.getRows((Rectangle2D)(r = new Rectangle2D.Double(rect.getX() - b.getMinX(), rect.getY() - b.getMinY(), rect.getWidth(), rect.getHeight())))) == null) continue;
                list.addAll(rows);
            }
            return list;
        }
        return null;
    }

    public boolean isSelectionMode() {
        return this.isSelectionMode;
    }

    public void setSelectionMode(boolean value) {
        this.isSelectionMode = value;
    }

    public void setShowFiltered(MutableProperty<Boolean> showFiltered) {
        this.properties.replaceProperty((Object)ParallelCoordinatesView.PropertyType.ShowFiltered, showFiltered);
        this.createOverPlots();
    }

    public void setRendering(MutableProperty<CPCanvas.Rendering> rendering) {
        if (this.getRendering() != rendering) {
            if (this.getRendering() != null) {
                this.getRendering().removePropertyListener(this.renderingListener);
            }
            this.properties.replaceProperty((Object)ParallelCoordinatesView.PropertyType.Rendering, rendering);
            if (this.getRendering() != null) {
                this.getRendering().addPropertyListener(this.renderingListener);
            }
        }
        this.createOverPlots();
    }

    public void setAntialiasing(MutableProperty<Boolean> antialiasing) {
        this.properties.replaceProperty((Object)ParallelCoordinatesView.PropertyType.Antialiasing, antialiasing);
        this.createOverPlots();
    }

    public void setGeometry(MutableProperty<Geometry> geometry) {
        if (this.getGeometry() != geometry) {
            if (this.getGeometry() != null) {
                this.getGeometry().removePropertyListener(this.geometryListener);
            }
            this.properties.replaceProperty((Object)ParallelCoordinatesView.PropertyType.Geometry, geometry);
            if (this.getGeometry() != null) {
                this.getGeometry().addPropertyListener(this.geometryListener);
            }
        }
        this.refresh();
    }

    private void createOverPlots() {
        for (ParallelCoordinatesComponent<Node, Color, Row, C> parallelCoordinatesComponent : this.parallelCoordinatesComponents.values()) {
            parallelCoordinatesComponent.createOverplots();
            parallelCoordinatesComponent.scheduleUpdate();
        }
    }
}

