/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplotmatrix.javafx;

import com.macrofocus.crossplatform.AbsoluteCPContainer;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.Layout;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.crossplatform.javafx.JavaFXAbsoluteContainer;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.parallelcoordinatesmatrix.ScatterPlotMatrixComponent;
import com.macrofocus.high_d.scatterplotmatrix.AbstractScatterPlotMatrixView;
import com.macrofocus.high_d.scatterplotmatrix.javafx.JavaFXScatterPlotMatrixComponent;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.order.MutableVisibleOrder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.paint.Color;

public class JavaFXScatterPlotMatrixView<Row, Column>
extends AbstractScatterPlotMatrixView<Node, Color, Row, Column> {
    private final JavaFXAbsoluteContainer nativeComponent;
    private final ScatterPlotMatrixComponent<Node, Color, Row, Column> scatterPlotMatrixComponent;
    private final Map<AxisModel, CPComponent<? extends Node>> axisLabels = new HashMap<AxisModel, CPComponent<? extends Node>>();

    public JavaFXScatterPlotMatrixView() {
        super((CPColorFactory)JavaFXFactory.getInstance());
        this.nativeComponent = new JavaFXAbsoluteContainer(new Layout(){

            public void layout(AbsoluteCPContainer container, int width, int height) {
                JavaFXScatterPlotMatrixView.this.runLayout();
            }
        });
        this.scatterPlotMatrixComponent = new JavaFXScatterPlotMatrixComponent(this);
        this.nativeComponent.addComponent(this.scatterPlotMatrixComponent);
    }

    private void runLayout() {
        ((Node)this.scatterPlotMatrixComponent.getNativeComponent()).resizeRelocate(0.0, 0.0, (double)this.getWidth(), (double)this.getHeight());
        MutableVisibleOrder axisOrder = this.getModel().getAxisGroupModel().getAxisOrder();
        int index = 0;
        for (AxisModel axisModel : axisOrder.iterableAll()) {
            CPComponent<Node> header;
            if (axisOrder.isVisible((Object)axisModel) && index < this.getModel().getAxisCount()) {
                header = this.getHeader(axisModel);
                int i = axisOrder.indexOf((Object)axisModel);
                Double x1Location = this.getModel().getLocation(axisModel);
                Double x2Location = i + 1 < axisOrder.size() ? this.getModel().getLocation((AxisModel)axisOrder.get(i + 1)) : Double.valueOf(1.0);
                if (x1Location != null && x2Location != null) {
                    int x = (int)(x1Location * (double)this.getWidth());
                    int y = (int)(x1Location * (double)this.getHeight());
                    int width = (int)(x2Location * (double)this.getWidth()) - x;
                    int height = (int)(x2Location * (double)this.getHeight()) - y;
                    ((Node)header.getNativeComponent()).resizeRelocate((double)x, (double)y, (double)width, (double)height);
                }
                ((Node)header.getNativeComponent()).setVisible(true);
                ++index;
                continue;
            }
            header = this.getHeader(axisModel);
            if (header == null) continue;
            ((Node)header.getNativeComponent()).setVisible(false);
        }
        this.scatterPlotMatrixComponent.scheduleUpdate();
    }

    public CPComponent<? extends Node> getHeader(AxisModel axisModel) {
        if (!this.axisLabels.containsKey(axisModel)) {
            CPComponent<Node> label = this.createAxisHeaderView(axisModel);
            this.nativeComponent.addComponent(label);
            this.axisLabels.put(axisModel, label);
        }
        return this.axisLabels.get(axisModel);
    }

    protected CPComponent<? extends Node> createAxisHeaderView(AxisModel axisModel) {
        Label label = new Label(axisModel.getName());
        label.setAlignment(Pos.CENTER);
        return JavaFXFactory.getInstance().createComponent((Node)label);
    }

    protected void refresh() {
        this.runLayout();
    }

    protected ScatterPlotMatrixComponent getScatterPlotMatrixComponent() {
        return this.scatterPlotMatrixComponent;
    }

    public Object getClosestRow(int x, int y) {
        Bounds b = ((Node)this.scatterPlotMatrixComponent.getNativeComponent()).getBoundsInParent();
        if (b.contains((double)x, (double)y)) {
            return this.scatterPlotMatrixComponent.getClosestRow((int)((double)x - b.getMinX()), (int)((double)y - b.getMinY()));
        }
        return null;
    }

    public List<Row> getRows(Rectangle2D rect) {
        Bounds b = ((Node)this.scatterPlotMatrixComponent.getNativeComponent()).getBoundsInParent();
        if (b.contains(rect.getX(), rect.getY())) {
            return this.scatterPlotMatrixComponent.getRows((Rectangle2D)new Rectangle2D.Double(rect.getX() - b.getMinX(), rect.getY() - b.getMinY(), rect.getWidth(), rect.getHeight()));
        }
        return null;
    }

    public void setLicenseModel(LicenseModel licenseModel) {
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractJavaFXComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public void addMouseListener(CPCanvas.MouseListener l) {
        this.nativeComponent.addMouseListener(l);
    }

    public void addMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.nativeComponent.addMouseMotionListener(l);
    }

    public void removeMouseListener(CPCanvas.MouseListener l) {
        this.nativeComponent.removeMouseListener(l);
    }

    public void removeMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.nativeComponent.removeMouseMotionListener(l);
    }

    public Node getNativeComponent() {
        return this.nativeComponent.getNativeComponent();
    }

    public int getWidth() {
        return (int)this.nativeComponent.getWidth();
    }

    public int getHeight() {
        return (int)this.nativeComponent.getHeight();
    }
}

