/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.table;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.format.CPFormat;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.table.AbstractTable;
import com.macrofocus.high_d.table.ShowFilteredDataFrame;
import com.macrofocus.high_d.table.Table;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.dataframe.DataFrameListener;
import com.macrofocus.molap.dataframe.SortOrder;
import com.macrofocus.visual.Visual;
import java.text.Format;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ModifiableObservableListBase;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.paint.Color;
import javafx.util.Callback;

public class JavaFXTable<Row, Column, Value>
extends AbstractTable<Node, Color, Format, Row, Column, Value> {
    private TableView<Row> tableView = new TableView();
    private ShowFilteredDataFrame<Row, Column, Value> dataFrame;
    private Visual<Color, Row, Column> visual;

    public JavaFXTable() {
        super((CPColorFactory)JavaFXFactory.getInstance());
        this.tableView.setStyle("-fx-padding: 0 0 0 0;");
        this.properties.addPropertiesListener(new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                if (name == Table.PropertyType.ColorTheme) {
                    JavaFXTable.this.tableView.refresh();
                }
            }
        });
    }

    public JavaFXTable(DataFrame<Row, Column, Value> dataFrame, Visual<Color, Row, Column> visual) {
        this(dataFrame, dataFrame, visual, null);
    }

    public JavaFXTable(DataFrame<Row, Column, Value> filteredDataFrame, DataFrame<Row, Column, Value> completeDataFrame, Visual<Color, Row, Column> visual, AxisGroupModel<Row, Column> axisGroupModel) {
        this();
        this.setModel(new ShowFilteredDataFrame(filteredDataFrame, completeDataFrame, this.getShowFiltered()), visual, null);
    }

    public DataFrame<Row, Column, Value> getSortedDataFrame() {
        System.err.println("getSortedDataFrame() not fully implemented");
        return this.dataFrame;
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractJavaFXComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public void setModel(final ShowFilteredDataFrame<Row, Column, Value> dataFrame, Visual<Color, Row, Column> visual, AxisGroupModel<Row, Column> axisGroupModel) {
        this.dataFrame = dataFrame;
        this.visual = visual;
        ModifiableObservableListBase items = new ModifiableObservableListBase<Row>(){

            public Row get(int index) {
                return dataFrame.getRowKey(index);
            }

            public int size() {
                return dataFrame.getRowCount();
            }

            protected void doAdd(int index, Row element) {
            }

            protected Row doSet(int index, Row element) {
                return null;
            }

            protected Row doRemove(int index) {
                return null;
            }
        };
        dataFrame.addDataFrameListener(new DataFrameListener<Row, Column>(){

            public void dataFrameChanged(DataFrameEvent<Row, Column> event) {
                JavaFXTable.this.tableView.refresh();
            }
        });
        this.tableView.setItems((ObservableList)items);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                for (final Object column : dataFrame.columns()) {
                    TableColumn tableColumn = new TableColumn(dataFrame.getColumnName(column));
                    JavaFXTable.this.tableView.getColumns().add((Object)tableColumn);
                    tableColumn.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<Row, Object>, ObservableValue<Object>>(){

                        public ObservableValue<Object> call(TableColumn.CellDataFeatures<Row, Object> param) {
                            return new ReadOnlyObjectWrapper(dataFrame.getValueAt(param.getValue(), column));
                        }
                    });
                }
            }
        });
    }

    public void adjustColumns(boolean columnHeaderIncluded, boolean dynamicAdjustment) {
        throw new UnsupportedOperationException();
    }

    public void setColumnVisible(Column column, boolean visible) {
        throw new UnsupportedOperationException();
    }

    public void setHidable(Column column, boolean hidable) {
        throw new UnsupportedOperationException();
    }

    public void setSortKey(Column column, SortOrder order) {
        throw new UnsupportedOperationException();
    }

    public void setFormat(Column column, CPFormat format) {
        System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ".setFormat(C column, CPFormat<Format> format) not yet implemented");
    }

    public void setLabel(Column column, String label) {
        System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ".setLabel(C column, String label) not yet implemented");
    }

    public void setFrozenColumnCount(int columnCount) {
        System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ".setFrozenColumnCount() not yet implemented");
    }

    public void reset() {
        System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ".reset() not yet implemented");
    }

    public void setShowFiltered(MutableProperty<Boolean> showFiltered) {
        this.properties.replaceProperty((Object)Table.PropertyType.ShowFiltered, showFiltered);
    }

    public void setColumnResizePolicy(Table.ColumnResizePolicy policy) {
        switch (policy) {
            case Constrained: {
                this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
                break;
            }
            case Unconstrained: {
                this.tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
            }
        }
    }

    public void setCellRenderer(Column column, Table.CellRenderer<Node, Row, Column, Value> renderer) {
        System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ".setCellRenderer() not yet implemented");
    }

    public void setDetailsFactory(boolean alwaysVisible, Table.DetailsFactory<Node, Row> factory) {
        System.err.println(((Object)((Object)this)).getClass().getSimpleName() + ".setDetailsFactory() not yet implemented");
    }

    public Node getNativeComponent() {
        return this.tableView;
    }
}

