/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.tablelens.javafx;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.crossplatform.AbsoluteCPContainer;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.Layout;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.crossplatform.javafx.JavaFXAbsoluteContainer;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.tablelens.AbstractTableLensView;
import com.macrofocus.high_d.tablelens.TableLensComponent;
import com.macrofocus.high_d.tablelens.TableLensModel;
import com.macrofocus.high_d.tablelens.TableLensView;
import com.macrofocus.high_d.tablelens.javafx.JavaFXTableLensComponent;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.order.MutableVisibleOrder;
import java.awt.event.ComponentAdapter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javax.swing.JPanel;

public class JavaFXTableLensView<Row, C>
extends AbstractTableLensView<Node, Color, Row, C> {
    private final JavaFXAbsoluteContainer nativeComponent;
    private final Map<AxisModel, Button> axisLabels = new HashMap<AxisModel, Button>();
    private TableLensModel<Color, Row, C> model;
    private final TableLensComponent<Node, Row, C> tableLensComponent;
    private MutableProperty<CPCanvas.Rendering> rendering;
    private boolean isSelectionMode = true;
    private int draggedLocation;
    private LicenseModel licenseModel;
    private JPanel unregisteredPanel;
    private ComponentAdapter unregisteredPanelListener;
    private final PropertyListener<CPCanvas.Rendering> renderingListener = new PropertyListener<CPCanvas.Rendering>(){

        public void propertyChanged(PropertyEvent<CPCanvas.Rendering> event) {
            JavaFXTableLensView.this.createOverplots();
        }
    };

    public JavaFXTableLensView() {
        super((CPColorFactory)JavaFXFactory.getInstance());
        this.nativeComponent = new JavaFXAbsoluteContainer(new Layout(){

            public void layout(AbsoluteCPContainer container, int width, int height) {
                JavaFXTableLensView.this.runLayout();
            }
        });
        this.tableLensComponent = new JavaFXTableLensComponent((TableLensView)this);
        this.nativeComponent.addComponent(this.tableLensComponent);
        this.setLicenseModel(this.licenseModel);
    }

    public void addMouseListener(CPCanvas.MouseListener l) {
        this.tableLensComponent.addMouseListener(l);
    }

    public void addMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.tableLensComponent.addMouseMotionListener(l);
    }

    public void removeMouseListener(CPCanvas.MouseListener l) {
        this.tableLensComponent.removeMouseListener(l);
    }

    public void removeMouseMotionListener(CPCanvas.MouseMotionListener l) {
        this.tableLensComponent.removeMouseMotionListener(l);
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractJavaFXComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public Node getNativeComponent() {
        return this.nativeComponent.getNativeComponent();
    }

    public int getWidth() {
        return (int)this.nativeComponent.getWidth();
    }

    public int getHeight() {
        return (int)this.nativeComponent.getHeight();
    }

    protected void refresh() {
        this.runLayout();
    }

    private void runLayout() {
        double headerMaximumHeight = 0.0;
        MutableVisibleOrder axisOrder = this.model.getAxisGroupModel().getAxisOrder();
        for (AxisModel axisModel : axisOrder.iterableAll()) {
            assert (axisModel != null);
            Button header = this.getHeader(axisModel);
            if (axisOrder.isVisible((Object)axisModel)) {
                int i = axisOrder.indexOf((Object)axisModel);
                Double x1Location = this.model.getLocation(axisModel);
                Double x2Location = i + 1 < axisOrder.size() ? this.model.getLocation((AxisModel)axisOrder.get(i + 1)) : Double.valueOf(1.0);
                if (x1Location != null && x2Location != null) {
                    double x = x1Location * (double)this.getWidth();
                    double y = 0.0;
                    double width = x2Location * (double)this.getWidth() - x;
                    double height = header.prefHeight(width);
                    headerMaximumHeight = Math.max(height, headerMaximumHeight);
                    header.resizeRelocate(x, y, width, height);
                }
                header.setVisible(true);
                continue;
            }
            header.setVisible(false);
        }
        ((Node)this.tableLensComponent.getNativeComponent()).resizeRelocate(0.0, headerMaximumHeight, (double)this.getWidth(), (double)this.getHeight() - headerMaximumHeight);
    }

    public Button getHeader(AxisModel axisModel) {
        if (!this.axisLabels.containsKey(axisModel)) {
            CPComponent<Button> label = this.createAxisHeaderView(axisModel);
            this.nativeComponent.addComponent(label);
            this.axisLabels.put(axisModel, (Button)label.getNativeComponent());
        }
        return this.axisLabels.get(axisModel);
    }

    protected CPComponent<Button> createAxisHeaderView(final AxisModel axisModel) {
        Button button = new Button(axisModel.getName());
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                JavaFXTableLensView.this.model.setOrder(axisModel);
            }
        });
        return JavaFXFactory.getInstance().createComponent((Node)button);
    }

    public Row getClosestRow(int x, int y) {
        return (Row)this.tableLensComponent.getClosestRow(x, y);
    }

    public List<Row> getRows(Rectangle2D rect) {
        return this.tableLensComponent.getRows(rect);
    }

    public boolean isSelectionMode() {
        return this.isSelectionMode;
    }

    public void setModel(TableLensModel model) {
        if (this.model != null) {
            this.model.getAxisGroupModel().getAxisOrder().removeOrderListener(this.orderListener);
        }
        this.model = model;
        this.tableLensComponent.setModel(model);
        if (this.model != null) {
            this.model.getAxisGroupModel().getAxisOrder().addOrderListener(this.orderListener);
        }
    }

    public void setSelectionMode(boolean value) {
        this.isSelectionMode = value;
    }

    public TableLensModel getModel() {
        return this.model;
    }

    public void setLicenseModel(LicenseModel licenseModel) {
    }

    protected void createOverplots() {
        if (this.tableLensComponent != null) {
            this.tableLensComponent.createOverplots();
            this.tableLensComponent.scheduleUpdate();
        }
    }

    private class TableLensLayeredPane
    extends Pane {
        private TableLensLayeredPane() {
        }

        protected void layoutChildren() {
            JavaFXTableLensView.this.runLayout();
        }
    }
}

