/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.treemap;

import com.macrofocus.coloring.MutableColoring;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.colormapping.ColorMappingListener;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.high_d.treemap.HighDTreeMapField;
import com.macrofocus.igraphics.CPImageFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import com.macrofocus.visual.Visual;
import com.macrofocus.visual.VisualObjects;
import com.treemap.AbstractTreeMapNode;
import com.treemap.DefaultTreeMapModel;
import com.treemap.LabelingFactory;
import com.treemap.NestingFactory;
import com.treemap.TreeMapField;
import com.treemap.TreeMapFilterCoordinator;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapProbingCoordinator;
import com.treemap.TreeMapSelectionCoordinator;

public class HighDTreeMapModel<Color, Font, N extends AbstractTreeMapNode<N, Row, Column, Color, Font>, Row, Column>
extends DefaultTreeMapModel<N, Row, Column, Color, Font> {
    private final MutableColorMapping<Color, Row, Column> colorMapping;
    private final MutableColoring<Color, Row> coloring;
    private boolean updatingProbing = false;

    public HighDTreeMapModel(DataFrame<Row, Column, ?> dataFrame, CPFactory<?, Font, ?, Color> cpFactory, ColorMapFactory<Color> colorMapFactory, CPImageFactory imageFactory) {
        this(dataFrame, (Visual<Color, Row, Column>)new SimpleVisual((VisualObjects)new SimpleVisualObjects(dataFrame), (MutableColorMapping)new SimpleColorMapping(colorMapFactory, dataFrame)), cpFactory, colorMapFactory, imageFactory);
    }

    public HighDTreeMapModel(DataFrame<Row, Column, ?> dataFrame, Visual<Color, Row, Column> visual, CPFactory<?, Font, ?, Color> cpFactory, ColorMapFactory<Color> colorMapFactory, CPImageFactory imageFactory) {
        this(dataFrame, (MutableSingleSelection<Row>)visual.getProbing(), (MutableSelection<Row>)visual.getSelection(), (MutableFilter<Row>)visual.getFilter(), (MutableColorMapping<Color, Row, Column>)visual.getColorMapping(), (MutableColoring<Color, Row>)visual.getColoring(), cpFactory, colorMapFactory, imageFactory);
    }

    public HighDTreeMapModel(DataFrame<Row, Column, ?> dataFrame, MutableSingleSelection<Row> probing, MutableSelection<Row> selection, MutableFilter<Row> filter, CPFactory<?, Font, ?, Color> cpFactory, ColorMapFactory<Color> colorMapFactory, CPImageFactory imageFactory) {
        this(dataFrame, probing, selection, filter, (MutableColorMapping<Color, Row, Column>)new SimpleColorMapping(colorMapFactory, dataFrame), null, cpFactory, colorMapFactory, imageFactory);
    }

    public HighDTreeMapModel(final DataFrame<Row, Column, ?> dataFrame, MutableSingleSelection<Row> probing, MutableSelection<Row> selection, MutableFilter<Row> filter, final MutableColorMapping<Color, Row, Column> colorMapping, MutableColoring<Color, Row> coloring, CPFactory<?, Font, ?, Color> cpFactory, ColorMapFactory<Color> colorMapFactory, CPImageFactory imageFactory) {
        super(dataFrame, cpFactory, colorMapFactory, imageFactory);
        this.colorMapping = colorMapping;
        this.coloring = coloring;
        colorMapping.addColormappingListener(new ColorMappingListener<Row, Column>(){

            public void colorMappingChanged() {
                Object selected = colorMapping.getColorSelection().getSelected();
                HighDTreeMapModel.this.getSettings().setColor(-1);
                if (selected != null) {
                    HighDTreeMapModel.this.getSettings().setColor(dataFrame.getColumnAddress(selected));
                } else {
                    HighDTreeMapModel.this.getSettings().setColor(-1);
                }
            }
        });
        if (colorMapping.getColorSelection().isActive()) {
            int columnAddress = dataFrame.getColumnAddress(colorMapping.getColorSelection().getSelected());
            this.getSettings().setColor(columnAddress);
        }
        this.getSettings().setLabels(new int[0]);
        this.getSettings().setToolTip(new int[0]);
        this.getSettings().setProbingColor(this.colorFactory.getOrange());
        this.getSettings().setSelectionColor(this.colorFactory.getRed());
        this.getSettings().getDefaultFieldSettings().setBorderColor(this.colorFactory.getWhite());
        this.getSettings().getDefaultFieldSettings().setLabeling(LabelingFactory.EXPAND);
        this.getSettings().getDefaultFieldSettings().setNesting(NestingFactory.PROPORTIONAL);
        new TreeMapProbingCoordinator(probing, (TreeMapModel)this);
        new TreeMapSelectionCoordinator(selection, (TreeMapModel)this);
        new TreeMapFilterCoordinator(filter, (TreeMapModel)this);
    }

    protected TreeMapField createTreeMapField(Column columnIndex) {
        return new HighDTreeMapField(this.dataFrame.getColumn(columnIndex));
    }

    protected MutableColorMap getColorMap() {
        return this.colorMapping.getCurrentColorMap(this.colorMapping.getColorSelection().getSelected());
    }

    public MutableColorMap createDefaultColorMap(TreeMapField<N, Column> field) {
        return this.colorMapping.getCurrentColorMap(field.getIndex());
    }

    protected MutableColorMap<Color> createCategoricalColorMap(TreeMapField<N, Column> field) {
        return this.colorMapping.getCategoricalColorMap(field.getIndex());
    }
}

