/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx;

import com.macrofocus.crossplatform.AbstractCanvas;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.crossplatform.javafx.layer.AveragingJavaFXLayer;
import com.macrofocus.crossplatform.javafx.layer.BufferedJavaFXLayer;
import com.macrofocus.crossplatform.javafx.layer.DensityJavaFXLayer;
import com.macrofocus.crossplatform.javafx.layer.DirectJavaFXLayer;
import com.macrofocus.crossplatform.javafx.layer.GraphicsContextJavaFXLayer;
import com.macrofocus.crossplatform.javafx.layer.JavaFXLayer;
import com.macrofocus.helper.OSHelper;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.GraphicsContextDrawing;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.IDrawingListener;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.javafx.JavaFXIGraphics;
import com.macrofocus.igraphics.javafx.JavaFXTiming;
import com.macrofocus.igraphics.javafx.ResizableCanvas;
import com.macrofocus.igraphics.pressure.Pressure;
import com.macrofocus.timer.CPTimer;
import com.macrofocus.timer.CPTimerListener;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;

public class JavaFXCanvas
extends AbstractCanvas<Node> {
    private final List<JavaFXLayer> layers = new CopyOnWriteArrayList<JavaFXLayer>();
    private final Map<IDrawing, IDrawingListener> drawings = new ConcurrentHashMap<IDrawing, IDrawingListener>();
    private final StackPane nativeComponent = new StackPane();
    private final CanvasComponent canvas = new CanvasComponent();
    private JavaFXTiming prepareTiming = new JavaFXTiming("Prepare");
    private JavaFXTiming renderTiming = new JavaFXTiming("Render");
    final InvalidationListener listener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            JavaFXCanvas.this.notifySizeChanged((int)JavaFXCanvas.this.getWidth(), (int)JavaFXCanvas.this.getHeight());
            JavaFXCanvas.this.canvas.schedulePrepare();
        }
    };

    public JavaFXCanvas() {
        this.canvas.widthProperty().addListener(this.listener);
        this.canvas.heightProperty().addListener(this.listener);
        this.nativeComponent.getChildren().add((Object)this.canvas);
        this.canvas.widthProperty().bind((ObservableValue)this.nativeComponent.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.nativeComponent.heightProperty());
        this.canvas.schedulePrepare();
    }

    public IGraphics getIGraphics() {
        return new JavaFXIGraphics(this.canvas.getGraphicsContext2D());
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractJavaFXComponent.setStyleClass(this, styleClasses);
    }

    public void addLayer(GraphicsContextDrawing drawing) {
        GraphicsContextJavaFXLayer layer = new GraphicsContextJavaFXLayer(drawing);
        this.layers.add(layer);
        IDrawingListener listener = new IDrawingListener(){

            public void iDrawingChanged() {
                JavaFXCanvas.this.canvas.scheduleRender();
            }
        };
        drawing.addIDrawingListener(listener);
        this.canvas.schedulePrepare();
    }

    public void addDensityLayer(CPCanvas.Rendering rendering, IDrawing iDrawing, Pressure pressure, CPCanvas.PaletteProvider paletteProvider) {
        JavaFXLayer layer;
        switch (rendering) {
            case Density: {
                layer = new DensityJavaFXLayer(iDrawing, 0, 0, true, pressure, paletteProvider);
                this.layers.add(layer);
                break;
            }
            case AlphaBlended: {
                Double alpha = 0.5;
                layer = new BufferedJavaFXLayer(iDrawing, true, (CPColor<Color>)paletteProvider.getPalette().getColor(1.0), alpha);
                this.layers.add(layer);
                break;
            }
            case Opaque: {
                layer = new BufferedJavaFXLayer(iDrawing, true, (CPColor<Color>)paletteProvider.getPalette().getColor(1.0), null);
                this.layers.add(layer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.registerDrawing(iDrawing, new IDrawingListener(){

            public void iDrawingChanged() {
                JavaFXCanvas.this.canvas.schedulePrepare(layer);
            }
        });
        this.canvas.schedulePrepare(layer);
    }

    public void addAveragingLayer(CPCanvas.Rendering rendering, IDrawing iDrawing) {
        JavaFXLayer layer;
        switch (rendering) {
            case Density: {
                layer = new AveragingJavaFXLayer(iDrawing, true);
                this.layers.add(layer);
                break;
            }
            case AlphaBlended: {
                layer = new BufferedJavaFXLayer(iDrawing, true);
                this.layers.add(layer);
                break;
            }
            case Opaque: {
                layer = new BufferedJavaFXLayer(iDrawing, true);
                this.layers.add(layer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.registerDrawing(iDrawing, new IDrawingListener(){

            public void iDrawingChanged() {
                JavaFXCanvas.this.canvas.schedulePrepare(layer);
            }
        });
        this.canvas.schedulePrepare(layer);
    }

    public void addLayer(IDrawing iDrawing) {
        DirectJavaFXLayer layer = new DirectJavaFXLayer(iDrawing);
        this.layers.add(layer);
        this.registerDrawing(iDrawing, new IDrawingListener(){

            public void iDrawingChanged() {
                JavaFXCanvas.this.canvas.scheduleRender();
            }
        });
        this.canvas.schedulePrepare();
    }

    public void addBufferedLayer(IDrawing iDrawing) {
        final BufferedJavaFXLayer layer = new BufferedJavaFXLayer(iDrawing, true);
        this.layers.add(layer);
        this.registerDrawing(iDrawing, new IDrawingListener(){

            public void iDrawingChanged() {
                JavaFXCanvas.this.canvas.schedulePrepare(layer);
            }
        });
        this.canvas.schedulePrepare(layer);
    }

    private void registerDrawing(IDrawing drawing, IDrawingListener listener) {
        this.drawings.put(drawing, listener);
        drawing.addIDrawingListener(listener);
    }

    public void removeAllLayers() {
        this.layers.clear();
        for (Map.Entry<IDrawing, IDrawingListener> entry : this.drawings.entrySet()) {
            entry.getKey().removeIDrawingListener(entry.getValue());
        }
        this.drawings.clear();
    }

    public void refresh() {
        this.canvas.schedulePrepare();
    }

    public void repaint() {
        this.canvas.scheduleRender();
    }

    public double getWidth() {
        return this.canvas.getWidth();
    }

    public double getHeight() {
        return this.canvas.getHeight();
    }

    public Node getNativeComponent() {
        return this.nativeComponent;
    }

    public void addMouseListener(final CPCanvas.MouseListener l) {
        this.canvas.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseClicked((CPCanvas.MouseEvent)new JavaFXMouseEvent(event));
            }
        });
        this.canvas.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mousePressed((CPCanvas.MouseEvent)new JavaFXMouseEvent(event));
            }
        });
        this.canvas.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseReleased((CPCanvas.MouseEvent)new JavaFXMouseEvent(event));
            }
        });
        this.canvas.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseEntered((CPCanvas.MouseEvent)new JavaFXMouseEvent(event));
            }
        });
        this.canvas.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseExited((CPCanvas.MouseEvent)new JavaFXMouseEvent(event));
            }
        });
    }

    public void addMouseMotionListener(final CPCanvas.MouseMotionListener l) {
        this.canvas.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseDragged((CPCanvas.MouseEvent)new JavaFXMouseEvent(event));
            }
        });
        this.canvas.setOnMouseMoved((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                l.mouseMoved((CPCanvas.MouseEvent)new JavaFXMouseEvent(event));
            }
        });
    }

    public void addMouseWheelListener(final CPCanvas.MouseWheelListener l) {
        this.canvas.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(final ScrollEvent event) {
                l.mouseWheelMoved(new CPCanvas.MouseWheelEvent(){

                    public int getX() {
                        return (int)event.getX();
                    }

                    public int getY() {
                        return (int)event.getY();
                    }

                    public int getWheelRotation() {
                        return -((int)event.getDeltaY());
                    }
                });
            }
        });
    }

    public void addKeyListener(CPCanvas.KeyListener l) {
    }

    public void addContextMenuListener(CPCanvas.ContextMenuListener l) {
    }

    private class CanvasComponent
    extends ResizableCanvas {
        private final Set<JavaFXLayer> dirtyLayers = new HashSet<JavaFXLayer>();
        protected final CPTimer prepareTimer = JavaFXFactory.getInstance().createTimer("CanvasPrepareTimer", 50, true, new CPTimerListener(){

            public void timerTriggered() {
                CanvasComponent.this.prepare();
            }
        });
        protected final CPTimer renderTimer = JavaFXFactory.getInstance().createTimer("CanvasRenderTimer", 17, false, new CPTimerListener(){

            public void timerTriggered() {
                if (Platform.isFxApplicationThread()) {
                    if (JavaFXCanvas.this.canvas.isVisible()) {
                        CanvasComponent.this.render();
                    }
                } else {
                    Platform.runLater(() -> {
                        if (JavaFXCanvas.this.canvas.isVisible()) {
                            CanvasComponent.this.render();
                        }
                    });
                }
            }
        });

        private CanvasComponent() {
        }

        private void schedulePrepare(JavaFXLayer layer) {
            this.dirtyLayers.add(layer);
            this.prepareTimer.restart();
        }

        private void schedulePrepare() {
            for (JavaFXLayer layer : JavaFXCanvas.this.layers) {
                this.dirtyLayers.add(layer);
            }
            this.prepareTimer.restart();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prepare() {
            ArrayList<JavaFXLayer> dirtyLayers;
            JavaFXCanvas.this.prepareTiming.start();
            double width = this.getWidth();
            double height = this.getHeight();
            Set<JavaFXLayer> set = this.dirtyLayers;
            synchronized (set) {
                dirtyLayers = new ArrayList<JavaFXLayer>(this.dirtyLayers);
                this.dirtyLayers.clear();
            }
            for (JavaFXLayer layer : dirtyLayers) {
                layer.prepare((int)width, (int)height);
            }
            JavaFXCanvas.this.prepareTiming.end();
            this.scheduleRender();
        }

        private void render() {
            JavaFXCanvas.this.renderTiming.start();
            GraphicsContext graphicsContext2D = this.getGraphicsContext2D();
            graphicsContext2D.clearRect(0.0, 0.0, JavaFXCanvas.this.canvas.getWidth(), JavaFXCanvas.this.canvas.getHeight());
            for (JavaFXLayer layer : JavaFXCanvas.this.layers) {
                graphicsContext2D.save();
                layer.render(graphicsContext2D);
                graphicsContext2D.restore();
            }
            double width = this.getWidth();
            double height = this.getHeight();
            JavaFXCanvas.this.renderTiming.end();
            if (JavaFXCanvas.this.isShowTiming()) {
                JavaFXCanvas.this.prepareTiming.draw(graphicsContext2D, new Dimension((int)width, (int)height), 32);
                JavaFXCanvas.this.renderTiming.draw(graphicsContext2D, new Dimension((int)width, (int)height), 16);
            }
        }

        public void scheduleRender() {
            this.renderTimer.restart();
        }
    }

    public static class JavaFXMouseEvent
    implements CPCanvas.MouseEvent {
        private final MouseEvent event;

        public JavaFXMouseEvent(MouseEvent event) {
            this.event = event;
        }

        public int getX() {
            return (int)this.event.getX();
        }

        public int getY() {
            return (int)this.event.getY();
        }

        public boolean isMenuShortcutKeyDown() {
            return this.event.isControlDown() || this.event.isMetaDown();
        }

        public boolean isAltKeyDown() {
            return this.event.isAltDown();
        }

        public boolean isShiftKeyDown() {
            return this.event.isShiftDown();
        }

        public boolean isMultipleSelectionKey() {
            if (OSHelper.isMacOSX()) {
                return this.event.isMetaDown();
            }
            return this.event.isControlDown();
        }

        public boolean isPopupTrigger() {
            return this.event.isPopupTrigger();
        }

        public boolean isLeftMouseButton() {
            return this.event.getButton().equals((Object)MouseButton.PRIMARY);
        }

        public boolean isMiddleMouseButton() {
            return this.event.getButton().equals((Object)MouseButton.MIDDLE);
        }

        public void stopPropagation() {
            this.event.consume();
        }

        public int getClickCount() {
            return this.event.getClickCount();
        }

        public String toString() {
            return "JavaFXMouseEvent{event=" + String.valueOf(this.event) + "}";
        }
    }
}

