/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx;

import com.macrofocus.crossplatform.AbstractFormPanel;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class JavaFXFormPanel
extends AbstractFormPanel<Node> {
    private final GridPane gridPane = new GridPane();
    private final ScrollPane nativeComponent = new ScrollPane((Node)this.gridPane);

    public JavaFXFormPanel() {
        this.nativeComponent.setFitToWidth(true);
        ColumnConstraints labelConstraint = new ColumnConstraints();
        labelConstraint.setHgrow(Priority.NEVER);
        labelConstraint.setFillWidth(false);
        labelConstraint.setHalignment(HPos.LEFT);
        ColumnConstraints componentConstraint = new ColumnConstraints();
        componentConstraint.setHgrow(Priority.ALWAYS);
        componentConstraint.setFillWidth(true);
        this.gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{labelConstraint, componentConstraint});
    }

    public int add(CPComponent<Node> label, CPComponent<Node> component) {
        return this.add(this.rows.size(), label, component);
    }

    public int[] add(CPComponent<Node> label, CPComponent<Node> component, CPComponent<Node> content) {
        return this.add(this.rows.size(), label, component, content);
    }

    public int add(int index, CPComponent<Node> label, CPComponent<Node> component) {
        for (int i = index; i < this.rows.size(); ++i) {
            AbstractFormPanel.Row r = (AbstractFormPanel.Row)this.rows.get(i);
            if (r.getLeft() != null) {
                GridPane.setRowIndex((Node)((Node)r.getLeft().getNativeComponent()), (Integer)(i + 1));
            }
            if (r.getRight() == null) continue;
            GridPane.setRowIndex((Node)((Node)r.getRight().getNativeComponent()), (Integer)(i + 1));
        }
        this.rows.add(index, new AbstractFormPanel.Row(label, component));
        if (label != null) {
            Node l = (Node)label.getNativeComponent();
            if (l instanceof Control) {
                ((Control)l).setMinWidth(Double.NEGATIVE_INFINITY);
            }
            this.gridPane.add(l, 0, index);
        }
        if (component != null) {
            if (component.getNativeComponent() instanceof Control) {
                ((Control)component.getNativeComponent()).setMaxWidth(Double.POSITIVE_INFINITY);
            }
            this.gridPane.add((Node)component.getNativeComponent(), 1, index);
        }
        return index;
    }

    public int[] add(int index, CPComponent<Node> label, CPComponent<Node> component, final CPComponent<Node> content) {
        final ToggleButton button = new ToggleButton("\u21f2");
        button.setStyle("-fx-font-size: 20px;");
        button.setPadding(Insets.EMPTY);
        button.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                ((Node)content.getNativeComponent()).setVisible(button.isSelected());
                ((Node)content.getNativeComponent()).setManaged(button.isSelected());
                button.setText(button.isSelected() ? "\u21f1" : "\u21f2");
            }
        });
        HBox first = new HBox(new Node[]{button, (Node)component.getNativeComponent()});
        HBox.setHgrow((Node)((Node)component.getNativeComponent()), (Priority)Priority.ALWAYS);
        int r1 = this.add(index, label, JavaFXFactory.getInstance().createComponent(first));
        if (content != null) {
            ((Node)content.getNativeComponent()).setVisible(button.isSelected());
            ((Node)content.getNativeComponent()).setManaged(button.isSelected());
            button.setText(button.isSelected() ? "\u21f1" : "\u21f2");
            int r2 = this.add(index + 1, null, content);
            return new int[]{r1, r2};
        }
        button.setVisible(false);
        return new int[]{r1};
    }

    public void addSeparator() {
        Separator separator = new Separator();
        HBox box = new HBox(new Node[]{separator});
        HBox.setHgrow((Node)separator, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)separator, (Insets)new Insets(4.0, 0.0, 4.0, 8.0));
        CPComponent<HBox> component = JavaFXFactory.getInstance().createComponent(box);
        this.add(component, null);
        GridPane.setFillWidth((Node)box, (Boolean)Boolean.TRUE);
        GridPane.setColumnSpan((Node)box, (Integer)2);
    }

    public void remove(List<Integer> indices) {
        Collections.sort(indices, Collections.reverseOrder());
        for (Integer index : indices) {
            AbstractFormPanel.Row r = (AbstractFormPanel.Row)this.rows.get(index);
            if (r.getLeft() != null) {
                this.gridPane.getChildren().remove(r.getLeft().getNativeComponent());
            }
            if (r.getRight() != null) {
                this.gridPane.getChildren().remove(r.getRight().getNativeComponent());
            }
            this.rows.remove(index);
            for (int i = index.intValue(); i < this.rows.size(); ++i) {
                AbstractFormPanel.Row r2 = (AbstractFormPanel.Row)this.rows.get(i);
                if (r2.getLeft() != null) {
                    GridPane.setRowIndex((Node)((Node)r2.getLeft().getNativeComponent()), (Integer)i);
                }
                if (r2.getRight() == null) continue;
                GridPane.setRowIndex((Node)((Node)r2.getRight().getNativeComponent()), (Integer)i);
            }
        }
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractJavaFXComponent.setStyleClass(this, styleClasses);
    }

    public Node getNativeComponent() {
        return this.nativeComponent;
    }
}

