/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx;

import com.macrofocus.crossplatform.AbsoluteCPContainer;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPHorizontalPanel;
import com.macrofocus.crossplatform.CPRectangle;
import com.macrofocus.crossplatform.Layout;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.crossplatform.javafx.JavaFXAbsoluteContainer;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.shape.Rectangle;

public class JavaFXHorizontalPanel
extends AbstractJavaFXComponent<Node>
implements CPHorizontalPanel<Node> {
    private final JavaFXAbsoluteContainer nativeComponent;
    protected List<CPComponent<? extends Node>> components = new ArrayList<CPComponent<? extends Node>>();

    public JavaFXHorizontalPanel() {
        this.nativeComponent = new JavaFXAbsoluteContainer(new Layout(){

            public void layout(AbsoluteCPContainer container, int width, int height) {
                if (JavaFXHorizontalPanel.this.nativeComponent.getHeight() <= 0.0 || JavaFXHorizontalPanel.this.nativeComponent.getWidth() <= 0.0) {
                    return;
                }
                for (int i = 0; i < JavaFXHorizontalPanel.this.components.size(); ++i) {
                    CPComponent<? extends Node> component = JavaFXHorizontalPanel.this.components.get(i);
                    int x1 = width * i / JavaFXHorizontalPanel.this.components.size();
                    int x2 = width * (i + 1) / JavaFXHorizontalPanel.this.components.size();
                    JavaFXHorizontalPanel.this.nativeComponent.setBounds(component, (CPRectangle<Rectangle>)JavaFXFactory.getInstance().createRectangle(x1, 0, x2 - x1, height));
                }
            }
        });
    }

    public void add(CPComponent<Node> component) {
        this.components.add(component);
        this.nativeComponent.addComponent(component);
    }

    public void add(CPComponent<Node> component, double weight) {
        System.err.println(this.getClass().getSimpleName() + ".add(CPComponent<Node> component, double weight) not yet implemented");
        this.add(component);
    }

    public Node getNativeComponent() {
        return this.nativeComponent.getNativeComponent();
    }
}

