/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.crossplatform.CPSpinner;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.format.CPFormat;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;

public class JavaFXIntegerSpinner
extends AbstractJavaFXComponent<Node>
implements CPSpinner<Node, Integer> {
    private final Spinner<Integer> nativeComponent = new Spinner();

    public JavaFXIntegerSpinner() {
    }

    public JavaFXIntegerSpinner(MutableProperty<Integer> value) {
        this();
        this.setProperty(value);
    }

    public void setProperty(final MutableProperty<Integer> property) {
        if (property != null) {
            this.nativeComponent.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(-2147483647, Integer.MAX_VALUE, ((Integer)property.getValue()).intValue()));
            this.nativeComponent.getValueFactory().valueProperty().addListener((ChangeListener)new ChangeListener<Integer>(){

                public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
                    property.setValue((Object)newValue);
                }
            });
        }
        this.nativeComponent.setEditable(property != null);
    }

    public void setValue(Integer value) {
        this.nativeComponent.getValueFactory().setValue((Object)value);
    }

    public void setFormat(final CPFormat format) {
        this.nativeComponent.getValueFactory().setConverter((StringConverter)new IntegerStringConverter(){

            public Integer fromString(String value) {
                if (format != null) {
                    try {
                        return (Integer)format.parse(value);
                    }
                    catch (CPFormat.ParsingException e) {
                        return super.fromString(value);
                    }
                }
                return super.fromString(value);
            }

            public String toString(Integer value) {
                if (format != null) {
                    return format.formatHtml((Object)value, false);
                }
                return super.toString(value);
            }
        });
    }

    public void setEnabled(boolean enabled) {
    }

    public void setMinimum(Comparable minimum) {
    }

    public void setMaximum(Comparable minimum) {
    }

    public Node getNativeComponent() {
        return this.nativeComponent;
    }
}

