/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx;

import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPRadioButtons;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class JavaFXRadioButtons<E>
extends AbstractJavaFXComponent<Node>
implements CPRadioButtons<Node, E> {
    private final HBox nativeComponent = new HBox();
    private ToggleGroup group;
    private Map<E, RadioButton> map;

    public JavaFXRadioButtons(Iterable<E> values) {
        this.nativeComponent.setMaxWidth(Double.POSITIVE_INFINITY);
        this.map = new HashMap<E, RadioButton>();
        this.group = new ToggleGroup();
        for (E value : values) {
            RadioButton radioButton = new RadioButton(value.toString());
            radioButton.setMaxWidth(Double.POSITIVE_INFINITY);
            radioButton.setUserData(value);
            radioButton.setToggleGroup(this.group);
            this.map.put(value, radioButton);
            this.nativeComponent.getChildren().add((Object)radioButton);
            HBox.setHgrow((Node)radioButton, (Priority)Priority.ALWAYS);
        }
    }

    public JavaFXRadioButtons(MutableSingleSelection<E> selection, Iterable<E> values) {
        this(values);
        this.setSelection(selection);
    }

    public void setSelection(final MutableSingleSelection<E> selection) {
        this.group.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                selection.setSelected(newValue.getUserData());
            }
        });
        if (selection.isActive()) {
            this.map.get(selection.getSelected()).setSelected(true);
        }
        selection.addSingleSelectionListener(new SingleSelectionListener<E>(){

            public void selectionChanged(SingleSelectionEvent<E> event) {
                JavaFXRadioButtons.this.map.get(event.getCurrentSelection()).setSelected(true);
            }
        });
    }

    public void setEnabled(E element, boolean enabled) {
        this.map.get(element).setDisable(!enabled);
    }

    public HBox getNativeComponent() {
        return this.nativeComponent;
    }
}

