/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx;

import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.crossplatform.CPSlider;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.crossplatform.javafx.property.JavaFXPropertyHelper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Slider;

public class JavaFXSlider
extends AbstractJavaFXComponent<Node>
implements CPSlider<Node> {
    private final Slider nativeComponent = new Slider();

    public JavaFXSlider() {
    }

    public JavaFXSlider(MutableBoundedInterval interval) {
        this();
        this.setInterval(interval);
    }

    public void setMinimum(double minimum) {
        this.nativeComponent.setMin(minimum);
    }

    public void setMaximum(double maximum) {
        this.nativeComponent.setMax(maximum);
    }

    public void setProperty(MutableProperty<Number> property) {
        JavaFXPropertyHelper.bindBidirectional(property, this.nativeComponent.valueProperty());
    }

    public void setInterval(final MutableBoundedInterval interval) {
        if (interval != null) {
            this.nativeComponent.setMin(interval.getMinimum());
            this.nativeComponent.setMax(interval.getMaximum());
            this.nativeComponent.setValue(interval.getStart());
        }
        this.nativeComponent.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                interval.setStart(newValue.doubleValue());
            }
        });
    }

    public Node getNativeComponent() {
        return this.nativeComponent;
    }
}

