/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx;

import com.macrofocus.coloring.MutableColoring;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.crossplatform.CPTree;
import com.macrofocus.crossplatform.CPTreeModel;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.paint.Color;

public class JavaFXTree<N>
implements CPTree<Node, Color, N> {
    private final TreeView<N> treeView;
    private final CPTreeModel<N> model;
    private final Map<N, TreeItem<N>> map = new HashMap<N, TreeItem<N>>();

    public JavaFXTree(CPTreeModel<N> model) {
        this.model = model;
        this.treeView = new TreeView();
        this.treeView.showRootProperty().setValue(Boolean.FALSE);
        this.treeView.setRoot(this.createTreeItem(model.getRoot()));
    }

    public void setSelection(MutableSingleSelection<N> selection) {
        selection.addSelectionListener(new SelectionListener<N>(){

            public void selectionChanged(SelectionEvent<N> event) {
                for (final Object n : event.getUnselected()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TreeItem<Object> treeItem = JavaFXTree.this.createTreeItem(n);
                            int row = JavaFXTree.this.treeView.getRow(treeItem);
                            JavaFXTree.this.treeView.getSelectionModel().clearSelection(row);
                            System.err.println("Unselecting " + String.valueOf(treeItem) + ", " + row);
                        }
                    });
                }
                for (final Object n : event.getSelected()) {
                    TreeItem treeItem = JavaFXTree.this.createTreeItem(n);
                    JavaFXTree.this.expandParent(treeItem);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TreeItem<Object> treeItem = JavaFXTree.this.createTreeItem(n);
                            int row = JavaFXTree.this.treeView.getRow(treeItem);
                            JavaFXTree.this.treeView.scrollTo(row);
                            JavaFXTree.this.treeView.getSelectionModel().select(row);
                            System.err.println("Selecting " + String.valueOf(treeItem) + ", " + row);
                        }
                    });
                }
            }
        });
    }

    private void expandParent(TreeItem<N> item) {
        Object parentNode;
        TreeItem p = item.getParent();
        if (p != null && (parentNode = p.getValue()) != null) {
            final TreeItem<Object> parent = this.createTreeItem(parentNode);
            this.expandParent(parent);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    parent.setExpanded(true);
                    System.err.println("Expanding " + String.valueOf(parent));
                }
            });
        }
    }

    public void setColoring(MutableColoring<Color, N> coloring) {
    }

    public void setStyleClass(String ... styleClasses) {
    }

    public Node getNativeComponent() {
        return this.treeView;
    }

    private TreeItem<N> createTreeItem(N node) {
        if (this.map.containsKey(node)) {
            return this.map.get(node);
        }
        NTreeItem treeItem = new NTreeItem(node);
        this.map.put(node, treeItem);
        return treeItem;
    }

    private class NTreeItem
    extends TreeItem<N> {
        private boolean isLeaf;
        private boolean isFirstTimeChildren;
        private boolean isFirstTimeLeaf;

        public NTreeItem(N f) {
            super(f);
            this.isFirstTimeChildren = true;
            this.isFirstTimeLeaf = true;
        }

        public ObservableList<TreeItem<N>> getChildren() {
            if (this.isFirstTimeChildren) {
                this.isFirstTimeChildren = false;
                super.getChildren().setAll(this.buildChildren(this));
            }
            return super.getChildren();
        }

        public boolean isLeaf() {
            if (this.isFirstTimeLeaf) {
                this.isFirstTimeLeaf = false;
                Object f = this.getValue();
                this.isLeaf = JavaFXTree.this.model.isLeaf(f);
            }
            return this.isLeaf;
        }

        private ObservableList<TreeItem<N>> buildChildren(TreeItem<N> treeItem) {
            Object f = treeItem.getValue();
            if (f != null && !JavaFXTree.this.model.isLeaf(f)) {
                ObservableList children = FXCollections.observableArrayList();
                for (int i = 0; i < JavaFXTree.this.model.getChildCount(f); ++i) {
                    Object childFile = JavaFXTree.this.model.getChild(f, i);
                    children.add(JavaFXTree.this.createTreeItem(childFile));
                }
                return children;
            }
            return FXCollections.emptyObservableList();
        }

        public int hashCode() {
            return this.getValue().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj != null) {
                return this.getValue().equals(((TreeItem)obj).getValue());
            }
            return false;
        }
    }
}

