/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx.layer;

import com.macrofocus.crossplatform.AbstractDensityLayer;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.javafx.layer.JavaFXLayer;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.pressure.Pressure;
import com.macrofocus.timer.VisualizationExecutorService;
import java.util.Arrays;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;

public class DensityJavaFXLayer
extends AbstractDensityLayer
implements JavaFXLayer {
    private static final boolean MULTITHREADED = false;
    private static final VisualizationExecutorService executor = null;
    private final IDrawing iDrawing;
    private final boolean antialiasing;
    private WritableImage image;
    private final Pressure pressure;
    private final CPCanvas.PaletteProvider palette;

    public DensityJavaFXLayer(IDrawing iDrawing, int width, int height, boolean antialiasing, Pressure pressure, CPCanvas.PaletteProvider palette) {
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
        this.resize(width, height);
        this.pressure = pressure;
        this.palette = palette;
    }

    @Override
    public void prepare(int width, int height) {
        if (this.iDrawing.isActive() && width > 0 && height > 0) {
            this.resize(width, height);
            this.iDrawing.draw(this.g, null, (double)this.width, (double)this.height, new Rectangle(0, 0, this.width, this.height));
            int m = this.computeMax();
            double min = this.pressure.transform(1.0);
            double max = this.pressure.transform((double)m);
            PixelWriter pixelWriter = this.image.getPixelWriter();
            double range = max - min;
            for (int i = 0; i < this.overlay.length; ++i) {
                int v = this.overlay[i];
                if (v > 0) {
                    double value = this.pressure.transform((double)v);
                    int color = (int)(value * (double)(this.palette.getPalette().getColorCount() - 1) / range);
                    pixelWriter.setArgb(i % width, i / width, this.palette.getPalette().getColorAt(color).getRGB());
                    continue;
                }
                pixelWriter.setArgb(i % width, i / width, 0xFFFFFF);
            }
            if (this.antialiasing) {
                this.image = this.createAntiAliasedImage(this.image);
            }
        }
    }

    void resize(int width, int height) {
        if (this.width != width || this.height != height) {
            WritableImage bufferedImage = new WritableImage(width, height);
            int[] o = new int[width * height];
            this.width = width;
            this.height = height;
            this.image = bufferedImage;
            this.overlay = o;
            this.cx1 = 0;
            this.cy1 = 0;
            this.cx2 = width - 1;
            this.cy2 = height - 1;
        } else {
            this.clear();
        }
    }

    @Override
    public void render(GraphicsContext g) {
        if (this.iDrawing.isActive() && this.image != null) {
            g.drawImage((Image)this.image, 0.0, 0.0);
        }
    }

    private WritableImage createAntiAliasedImage(WritableImage img) {
        return img;
    }

    void clear() {
        if (this.image != null) {
            Arrays.fill(this.overlay, 0);
        }
    }

    int computeMax() {
        int max = 0;
        for (int v : this.overlay) {
            if (v <= max) continue;
            max = v;
        }
        return max;
    }
}

