/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx.property;

import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class JavaFXProperty<T>
implements ObservableValue<T> {
    private Property<T> property;
    private Map<ChangeListener<? super T>, PropertyListener<T>> listeners;

    public JavaFXProperty(Property<T> property) {
        this.property = property;
        this.listeners = new HashMap<ChangeListener<? super T>, PropertyListener<T>>();
    }

    public void addListener(final ChangeListener<? super T> changeListener) {
        PropertyListener propertyListener = new PropertyListener<T>(){

            public void propertyChanged(PropertyEvent<T> event) {
                changeListener.changed((ObservableValue)JavaFXProperty.this, event.getOldValue(), event.getNewValue());
            }
        };
        this.listeners.put(changeListener, propertyListener);
        this.property.addPropertyListener(propertyListener);
    }

    public void removeListener(ChangeListener<? super T> changeListener) {
        this.property.removePropertyListener(this.listeners.get(changeListener));
    }

    public T getValue() {
        return (T)this.property.getValue();
    }

    public void addListener(InvalidationListener listener) {
    }

    public void removeListener(InvalidationListener listener) {
    }
}

