/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.crossplatform.javafx.property;

import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.crossplatform.javafx.property.JavaFXProperty;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.javafx.JavaFXColor;
import com.macrofocus.igraphics.javafx.JavaFXFont;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class JavaFXPropertyHelper {
    public static <T> void bind(MutableProperty<T> source, Property<T> destination) {
        destination.bind(new JavaFXProperty<T>(source));
    }

    public static <T, R> void bind(Property<T> source, final MutableProperty<R> destination, final Function<? super T, ? extends R> mapper) {
        source.addListener(new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                destination.setValue(mapper.apply(newValue));
            }
        });
        destination.setValue(mapper.apply(source.getValue()));
    }

    public static <T, R> void bind(MutableProperty<T> source, final Property<R> destination, final Function<? super T, ? extends R> mapper) {
        source.addPropertyListener(new PropertyListener<T>(){

            public void propertyChanged(PropertyEvent<T> event) {
                destination.setValue(mapper.apply(event.getNewValue()));
            }
        });
        destination.setValue(mapper.apply(source.getValue()));
    }

    public static <T> BindRegistration bindBidirectional(final MutableProperty<T> source, final Property<T> destination) {
        final ChangeListener listener = new ChangeListener<T>(){

            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                source.setValue(newValue);
            }
        };
        destination.addListener(listener);
        final PropertyListener propertyListener = new PropertyListener<T>(){

            public void propertyChanged(PropertyEvent<T> event) {
                destination.setValue(event.getNewValue());
            }
        };
        source.addPropertyListener(propertyListener);
        destination.setValue(source.getValue());
        return new BindRegistration(){

            @Override
            public void removeHandler() {
                destination.removeListener(listener);
                source.removePropertyListener(propertyListener);
            }
        };
    }

    public static BindRegistration bindBidirectionalColor(final MutableProperty<CPColor<Color>> source, final Property<Color> destination) {
        CPColor color = (CPColor)source.getValue();
        destination.setValue(color != null ? (Color)color.getNativeColor() : null);
        final boolean[] updating = new boolean[]{false};
        ChangeListener<Color> listener = new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                if (!updating[0]) {
                    updating[0] = true;
                    source.setValue((Object)(newValue != null ? new JavaFXColor(newValue) : null));
                    updating[0] = false;
                }
            }
        };
        destination.addListener((ChangeListener)listener);
        PropertyListener<CPColor<Color>> propertyListener = new PropertyListener<CPColor<Color>>(){

            public void propertyChanged(PropertyEvent<CPColor<Color>> event) {
                if (!updating[0]) {
                    updating[0] = true;
                    CPColor color = (CPColor)event.getNewValue();
                    destination.setValue(color != null ? (Color)color.getNativeColor() : null);
                    updating[0] = false;
                }
            }
        };
        source.addPropertyListener((PropertyListener)propertyListener);
        return new BindRegistration(){
            final /* synthetic */ ChangeListener val$listener;
            final /* synthetic */ MutableProperty val$source;
            final /* synthetic */ PropertyListener val$propertyListener;
            {
                this.val$listener = changeListener;
                this.val$source = mutableProperty;
                this.val$propertyListener = propertyListener;
            }

            @Override
            public void removeHandler() {
                destination.removeListener(this.val$listener);
                this.val$source.removePropertyListener(this.val$propertyListener);
            }
        };
    }

    public static BindRegistration bindBidirectionalFont(final MutableProperty<CPFont<Font>> source, final Property<Font> destination) {
        CPFont color = (CPFont)source.getValue();
        destination.setValue(color != null ? (Font)color.getNativeFont() : null);
        final boolean[] updating = new boolean[]{false};
        ChangeListener<Font> listener = new ChangeListener<Font>(){

            public void changed(ObservableValue<? extends Font> observable, Font oldValue, Font newValue) {
                if (!updating[0]) {
                    updating[0] = true;
                    source.setValue((Object)(newValue != null ? new JavaFXFont(newValue) : null));
                    updating[0] = false;
                }
            }
        };
        destination.addListener((ChangeListener)listener);
        PropertyListener<CPFont<Font>> propertyListener = new PropertyListener<CPFont<Font>>(){

            public void propertyChanged(PropertyEvent<CPFont<Font>> event) {
                if (!updating[0]) {
                    updating[0] = true;
                    CPFont color = (CPFont)event.getNewValue();
                    destination.setValue(color != null ? (Font)color.getNativeFont() : null);
                    updating[0] = false;
                }
            }
        };
        source.addPropertyListener((PropertyListener)propertyListener);
        return new BindRegistration(){
            final /* synthetic */ ChangeListener val$listener;
            final /* synthetic */ MutableProperty val$source;
            final /* synthetic */ PropertyListener val$propertyListener;
            {
                this.val$listener = changeListener;
                this.val$source = mutableProperty;
                this.val$propertyListener = propertyListener;
            }

            @Override
            public void removeHandler() {
                destination.removeListener(this.val$listener);
                this.val$source.removePropertyListener(this.val$propertyListener);
            }
        };
    }

    public static interface BindRegistration {
        public void removeHandler();
    }
}

