/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.igraphics.javafx;

import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import com.macrofocus.igraphics.AbstractIGraphics;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFont;
import com.macrofocus.igraphics.CPFontMetrics;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.javafx.JavaFXColor;
import com.macrofocus.igraphics.javafx.JavaFXFontMetrics;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public class JavaFXIGraphics
extends AbstractIGraphics<Color, Font> {
    private GraphicsContext context;

    public JavaFXIGraphics(GraphicsContext context) {
        this.context = context;
    }

    public double getLineWidth() {
        return this.context.getLineWidth();
    }

    public void setLineWidth(double lineWidth) {
        this.context.setLineWidth(lineWidth);
    }

    public void setLineDash(float[] dashPattern) {
        this.context.setLineDashes(JavaFXIGraphics.convertFloatsToDoubles(dashPattern));
    }

    private static double[] convertFloatsToDoubles(float[] input) {
        if (input == null) {
            return null;
        }
        double[] output = new double[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[i];
        }
        return output;
    }

    public CPColor<Color> getColor() {
        return new JavaFXColor((Color)this.context.getFill());
    }

    public void setGlobalAlpha(double alpha) {
        this.context.setGlobalAlpha(alpha);
    }

    public void setColor(CPColor<Color> color) {
        this.context.setFill((Paint)color.getNativeColor());
        this.context.setStroke((Paint)color.getNativeColor());
    }

    public void draw(Shape geometry) {
        if (this.context != null) {
            GraphicsContext context = this.getContext();
            this.drawPath(geometry);
            context.stroke();
        }
    }

    public GraphicsContext getContext() {
        return this.context;
    }

    public void fill(Shape geometry) {
        if (this.context != null) {
            GraphicsContext context = this.getContext();
            this.drawPath(geometry);
            context.fill();
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.context.strokeLine((double)x1, (double)y1, (double)x2, (double)y2);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        this.context.strokeLine(x1, y1, x2, y2);
    }

    public void drawRectangle(Rectangle2D rectangle) {
        GraphicsContext context = this.getContext();
        context.rect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public void fillRectangle2D(Rectangle2D rectangle) {
        this.context.fillRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public void fillCircle(Rectangle2D rectangle) {
        this.context.fillOval(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
    }

    public void drawPath(Shape path) {
        GraphicsContext context = this.getContext();
        PathIterator iterator = path.getPathIterator();
        double[] coords = new double[6];
        context.beginPath();
        while (!iterator.isDone()) {
            int segment = iterator.currentSegment(coords);
            if (segment == 0) {
                context.moveTo(coords[0], coords[1]);
            } else if (segment == 1) {
                context.lineTo(coords[0], coords[1]);
            } else if (segment == 2) {
                context.quadraticCurveTo(coords[0], coords[1], coords[2], coords[3]);
            } else if (segment == 3) {
                context.bezierCurveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
            } else if (segment == 4) {
                context.closePath();
            } else {
                throw new RuntimeException("Unknown Segment " + segment);
            }
            iterator.next();
        }
    }

    public void setTextBaseline(IGraphics.TextBaseline baseline) {
        switch (baseline) {
            case Top: {
                this.context.setTextBaseline(VPos.TOP);
                break;
            }
            case Bottom: {
                this.context.setTextBaseline(VPos.BOTTOM);
                break;
            }
            case Middle: {
                this.context.setTextBaseline(VPos.CENTER);
                break;
            }
            case Alphabetic: {
                this.context.setTextBaseline(VPos.BASELINE);
                break;
            }
            case Hanging: {
                throw new UnsupportedOperationException();
            }
            case Ideographic: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setFont(CPFont<Font> font) {
        this.context.setFont((Font)font.getNativeFont());
    }

    public Rectangle2D getStringBounds(String text) {
        Text t = new Text(text);
        t.setFont(this.context.getFont());
        Bounds stringBounds = t.getLayoutBounds();
        return new Rectangle2D.Double(stringBounds.getMinX(), stringBounds.getMinY(), stringBounds.getWidth(), stringBounds.getHeight());
    }

    public CPFontMetrics getFontMetrics() {
        return new JavaFXFontMetrics(this.context);
    }

    public void drawString(String text, float x, float y) {
        this.context.fillText(text, (double)x, (double)y);
    }

    public float getStringWidth(String text) {
        return (float)this.getStringBounds(text).getWidth();
    }

    public float getStringHeight(String text) {
        return (float)this.getStringBounds(text).getHeight();
    }

    public double getAscent() {
        return this.context.getFont().getSize();
    }

    public double getDescent() {
        return 0.0;
    }

    public void translate(int x, int y) {
        this.context.translate((double)x, (double)y);
    }

    public void rotate(double theta) {
        this.context.rotate(Math.toDegrees(theta));
    }

    public void beginPath() {
        this.context.beginPath();
    }

    public void moveTo(double x, double y) {
        this.context.moveTo(x, y);
    }

    public void lineTo(double x, double y) {
        this.context.lineTo(x, y);
    }

    public void closePath() {
        this.context.closePath();
    }

    public void stroke() {
        this.context.stroke();
    }

    public void fill() {
        this.context.fill();
    }
}

