/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.table.javafx;

import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.format.CPFormat;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.dataframe.DataFrameListener;
import com.macrofocus.molap.dataframe.MutableDataFrame;
import com.macrofocus.table.AbstractTable;
import com.macrofocus.table.Table;
import com.macrofocus.table.javafx.ReadOnlyObservableValue;
import com.macrofocus.table.javafx.ReadWriteObservableValue;
import com.macrofocus.visual.Visual;
import java.text.Format;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ModifiableObservableListBase;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class JavaFXTable<Row, Column, Value>
extends AbstractTable<Node, Color, Format, Row, Column, Value> {
    private TableView<Row> tableView;
    private DataFrame<Row, Column, Value> dataFrame;
    private Visual<Color, Row, Column> visual;
    private final Map<Column, TableColumn<Row, Object>> columnTableColumnMap = new HashMap<Column, TableColumn<Row, Object>>();
    private final Map<Column, Table.CellEditor<Node, Row, Column, Value>> columnEditorMap = new HashMap<Column, Table.CellEditor<Node, Row, Column, Value>>();
    final DataFrameListener<Row, Column> dataFrameListener = new DataFrameListener<Row, Column>(){

        public void dataFrameChanged(DataFrameEvent<Row, Column> event) {
            JavaFXTable.this.tableView.refresh();
        }
    };

    public JavaFXTable() {
        super((CPColorFactory)JavaFXFactory.getInstance());
        this.tableView = new TableView();
        this.tableView.setStyle("-fx-padding: 0 0 0 0;");
        this.properties.addPropertiesListener(new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                if (name == Table.PropertyType.ColorTheme) {
                    JavaFXTable.this.tableView.refresh();
                }
            }
        });
    }

    public JavaFXTable(DataFrame<Row, Column, Value> dataFrame, Visual<Color, Row, Column> visual) {
        this();
        this.setModel(dataFrame, visual);
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractJavaFXComponent.setStyleClass(this, styleClasses);
    }

    public void setModel(final DataFrame<Row, Column, Value> dataFrame, final Visual<Color, Row, Column> visual) {
        if (this.dataFrame != null) {
            this.dataFrame.removeDataFrameListener(this.dataFrameListener);
        }
        this.dataFrame = dataFrame;
        this.visual = visual;
        ModifiableObservableListBase items = new ModifiableObservableListBase<Row>(){

            public Row get(int index) {
                return dataFrame.getRowKey(index);
            }

            public int size() {
                return dataFrame.getRowCount();
            }

            protected void doAdd(int index, Row element) {
            }

            protected Row doSet(int index, Row element) {
                return null;
            }

            protected Row doRemove(int index) {
                return null;
            }
        };
        if (this.dataFrame != null) {
            dataFrame.addDataFrameListener(this.dataFrameListener);
        }
        this.tableView.setItems((ObservableList)items);
        this.columnTableColumnMap.clear();
        for (Object column : dataFrame.columns()) {
            TableColumn tableColumn = new TableColumn(dataFrame.getColumnName(column));
            this.columnTableColumnMap.put(column, tableColumn);
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                JavaFXTable.this.tableView.getColumns().clear();
                for (final Object column : dataFrame.columns()) {
                    TableColumn tableColumn = JavaFXTable.this.columnTableColumnMap.get(column);
                    JavaFXTable.this.tableView.getColumns().add(tableColumn);
                    tableColumn.setCellValueFactory(new Callback<TableColumn.CellDataFeatures<Row, Object>, ObservableValue<Object>>(){

                        public ObservableValue<Object> call(TableColumn.CellDataFeatures<Row, Object> param) {
                            final Object row = param.getValue();
                            if (JavaFXTable.this.columnEditorMap.containsKey(column) && JavaFXTable.this.columnEditorMap.get(column).isEditable(row, column, null)) {
                                return new ReadWriteObservableValue<Object>(new Supplier<Object>(){

                                    @Override
                                    public Object get() {
                                        return dataFrame.getValueAt(row, column);
                                    }
                                }, new Consumer<Object>(){

                                    @Override
                                    public void accept(Object o) {
                                        if (dataFrame instanceof MutableDataFrame) {
                                            ((MutableDataFrame)dataFrame).setValueAt(row, column, o);
                                        }
                                    }
                                });
                            }
                            return new ReadOnlyObservableValue<Object>(new Supplier<Object>(){

                                @Override
                                public Object get() {
                                    return dataFrame.getValueAt(row, column);
                                }
                            });
                        }
                    });
                }
            }
        });
        this.tableView.getSelectionModel().getSelectedItems().addListener(new ListChangeListener<Row>(){

            public void onChanged(ListChangeListener.Change<? extends Row> c) {
                visual.getSelection().setSelectedIterable((Iterable)JavaFXTable.this.tableView.getSelectionModel().getSelectedItems());
            }
        });
    }

    public void setSortKey(Column column) {
    }

    public void setFormat(Column column, CPFormat format) {
    }

    public void setLabel(Column column, String label) {
    }

    public void setFrozenColumnCount(int columnCount) {
    }

    public void setCellRenderer(final Column column, final Table.CellRenderer<Node, Row, Column, Value> renderer) {
        TableColumn<Row, Object> tableColumn = this.columnTableColumnMap.get(column);
        tableColumn.setCellFactory(new Callback<TableColumn<Row, Object>, TableCell<Row, Object>>(){

            public TableCell<Row, Object> call(TableColumn<Row, Object> param) {
                return new TableCell<Row, Object>(){

                    protected void updateItem(Object item, boolean empty) {
                        super.updateItem(item, empty);
                        Object row = this.getTableView().getItems().get(this.getIndex());
                        this.setGraphic((Node)renderer.render(null, row, column, item).getNativeComponent());
                    }
                };
            }
        });
    }

    public void setCellEditor(Column column, final Table.CellEditor<Node, Row, Column, Value> editor) {
        this.columnEditorMap.put(column, editor);
        TableColumn<Row, Object> tableColumn = this.columnTableColumnMap.get(column);
        tableColumn.setEditable(true);
        tableColumn.setCellFactory(TextFieldTableCell.forTableColumn((StringConverter)new StringConverter<Object>(){

            public String toString(Object value) {
                return editor.getFormat().formatHtml(value, false);
            }

            public Object fromString(String value) {
                try {
                    return editor.getFormat().parse(value);
                }
                catch (CPFormat.ParsingException e) {
                    return null;
                }
            }
        }));
    }

    public void setEditable(boolean editable) {
        this.tableView.setEditable(editable);
    }

    public void setColumnVisible(Column column, boolean visible) {
        this.columnTableColumnMap.get(column).setVisible(visible);
    }

    public void setColumnResizePolicy(Table.ColumnResizePolicy policy) {
        switch (policy) {
            case Constrained: {
                this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
                break;
            }
            case Unconstrained: {
                this.tableView.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
            }
        }
    }

    public void setPrefHeight(double height) {
        this.tableView.setPrefHeight(height);
    }

    public Node getNativeComponent() {
        return this.tableView;
    }
}

