/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot;

import com.macrofocus.crossplatform.AbsoluteCPContainer;
import com.macrofocus.crossplatform.CPOverlayPanel;
import com.macrofocus.crossplatform.CPRectangle;
import com.macrofocus.crossplatform.Layout;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.crossplatform.javafx.JavaFXRectangle;
import com.macrofocus.plot.AbstractAxisPlotPanel;
import com.macrofocus.plot.guide.Guide;
import java.awt.Dimension;
import java.awt.Rectangle;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public class JavaFXAxisPlotPanel
extends AbstractAxisPlotPanel<Node, Color, Font> {
    private AbsoluteCPContainer<Node, javafx.scene.shape.Rectangle> panel = JavaFXFactory.getInstance().createAbsoluteContainer(new Layout(){

        public void layout(AbsoluteCPContainer container, int width, int height) {
            int x1 = JavaFXAxisPlotPanel.this.getLeftAxisPreferredSize().width;
            int x2 = width - JavaFXAxisPlotPanel.this.getRightAxisPreferredSize().width;
            int y1 = JavaFXAxisPlotPanel.this.getTopAxisPreferredSize().height;
            int y2 = height - JavaFXAxisPlotPanel.this.getBottomAxisPreferredSize().height;
            container.setBounds(JavaFXAxisPlotPanel.this.snapshotPanel, (CPRectangle)new JavaFXRectangle(0, y1, x2, height - y1));
            container.setBounds(JavaFXAxisPlotPanel.this.topTimeAxisContainer, (CPRectangle)new JavaFXRectangle(x1, 0, x2 - x1, y1));
            container.setBounds(JavaFXAxisPlotPanel.this.rightYAxisContainer, (CPRectangle)new JavaFXRectangle(x2, y1, width - x2, y2 - y1));
        }
    });
    private AbsoluteCPContainer<Node, javafx.scene.shape.Rectangle> snapshotPanel = JavaFXFactory.getInstance().createAbsoluteContainer(new Layout(){

        public void layout(AbsoluteCPContainer container, int width, int height) {
            int x1 = JavaFXAxisPlotPanel.this.getLeftAxisPreferredSize().width;
            int x2 = width - JavaFXAxisPlotPanel.this.getRightAxisPreferredSize().width;
            int y1 = JavaFXAxisPlotPanel.this.getTopAxisPreferredSize().height;
            int y2 = height - JavaFXAxisPlotPanel.this.getBottomAxisPreferredSize().height;
            container.setBounds(JavaFXAxisPlotPanel.this.leftYAxisContainer, (CPRectangle)new JavaFXRectangle(0, 0, x1, y2 - y1));
            container.setBounds(JavaFXAxisPlotPanel.this.bottomTimeAxisContainer, (CPRectangle)new JavaFXRectangle(x1, height - y1 - (height - y2), x2 - x1, height - y2));
            container.setBounds(JavaFXAxisPlotPanel.this.mainContainer, (CPRectangle)new JavaFXRectangle(x1, 0, x2 - x1, y2 - y1));
        }
    });
    private CPOverlayPanel<Node, Node> mainContainer;
    private CPOverlayPanel<Node, Node> rightYAxisContainer;
    private CPOverlayPanel<Node, Node> bottomTimeAxisContainer;
    private CPOverlayPanel<Node, Node> leftYAxisContainer;
    private CPOverlayPanel<Node, Node> topTimeAxisContainer;

    public JavaFXAxisPlotPanel(Guide<Node, Color, Font> xGuide, Guide<Node, Color, Font> yGuide) {
        this();
        this.xGuide = xGuide;
        this.yGuide = yGuide;
        this.addBottomTimeAxisComponent((Node)xGuide.getNativeComponent());
        this.addLeftYAxisComponent((Node)yGuide.getNativeComponent());
    }

    public JavaFXAxisPlotPanel() {
        this.panel.addComponent(this.snapshotPanel);
        this.mainContainer = JavaFXFactory.getInstance().createOverlayPanel();
        this.snapshotPanel.addComponent(this.mainContainer);
        this.topTimeAxisContainer = JavaFXFactory.getInstance().createOverlayPanel();
        this.panel.addComponent(this.topTimeAxisContainer);
        this.leftYAxisContainer = JavaFXFactory.getInstance().createOverlayPanel();
        this.snapshotPanel.addComponent(this.leftYAxisContainer);
        this.bottomTimeAxisContainer = JavaFXFactory.getInstance().createOverlayPanel();
        this.snapshotPanel.addComponent(this.bottomTimeAxisContainer);
        this.rightYAxisContainer = JavaFXFactory.getInstance().createOverlayPanel();
        this.panel.addComponent(this.rightYAxisContainer);
    }

    public Dimension getTopAxisPreferredSize() {
        return new Dimension(0, 0);
    }

    public Dimension getBottomAxisPreferredSize() {
        System.err.println(this.showBottomTimeAxis + " " + String.valueOf(this.xGuide));
        if (this.showBottomTimeAxis && this.xGuide != null) {
            Bounds dataArea = this.getNativeComponent().getBoundsInParent();
            double space = this.xGuide.computeSpace(null, new Rectangle(0, 0, (int)dataArea.getWidth(), (int)dataArea.getHeight()));
            System.err.println(space + ", " + ((Node)this.xGuide.getNativeComponent()).prefHeight(1000.0) + ", " + String.valueOf(this.xGuide.getPreferredSize()));
            return new Dimension((int)((Node)this.xGuide.getNativeComponent()).prefWidth(1000.0), (int)((Node)this.xGuide.getNativeComponent()).prefHeight(1000.0));
        }
        return new Dimension(0, 0);
    }

    public Dimension getLeftAxisPreferredSize() {
        if (this.showLeftYAxis && this.yGuide != null) {
            Bounds dataArea = this.getNativeComponent().getBoundsInParent();
            double space = this.yGuide.computeSpace(null, new Rectangle(0, 0, (int)dataArea.getWidth(), (int)dataArea.getHeight()));
            System.err.println(space + ", " + ((Node)this.yGuide.getNativeComponent()).prefWidth(1000.0) + ", " + String.valueOf(this.yGuide.getPreferredSize()));
            return new Dimension((int)((Node)this.yGuide.getNativeComponent()).prefWidth(1000.0), (int)((Node)this.yGuide.getNativeComponent()).prefHeight(1000.0));
        }
        return new Dimension(0, 0);
    }

    public Dimension getRightAxisPreferredSize() {
        return new Dimension(0, 0);
    }

    public Node getNativeComponent() {
        return (Node)this.panel.getNativeComponent();
    }

    public Node getMainContainer() {
        return (Node)this.mainContainer.getNativeComponent();
    }

    public Node getRightYAxisContainer() {
        return (Node)this.rightYAxisContainer.getNativeComponent();
    }

    public Node getBottomTimeAxisContainer() {
        return (Node)this.bottomTimeAxisContainer.getNativeComponent();
    }

    public Node getLeftYAxisContainer() {
        return (Node)this.leftYAxisContainer.getNativeComponent();
    }

    public Node getTopTimeAxisContainer() {
        return (Node)this.topTimeAxisContainer.getNativeComponent();
    }

    public Node getPanel() {
        return (Node)this.panel.getNativeComponent();
    }

    public Node getSnapshotPanel() {
        return (Node)this.snapshotPanel.getNativeComponent();
    }

    public void valideAxis() {
        boolean topAxisVisible = this.showTopTimeAxis;
        boolean bottomAxisVisible = this.showBottomTimeAxis && this.xGuide != null;
        boolean leftAxisVisible = this.showLeftYAxis && this.yGuide != null;
        this.setTopAxisVisible(topAxisVisible);
        this.setBottomAxisVisible(bottomAxisVisible);
        this.setLeftAxisVisible(leftAxisVisible);
        if (topAxisVisible) {
            Dimension topAxisPreferredSize = this.getTopAxisPreferredSize();
        } else {
            Dimension topAxisPreferredSize = new Dimension(0, 0);
        }
        Dimension bottomAxisPreferredSize = bottomAxisVisible ? this.getBottomAxisPreferredSize() : new Dimension(0, 0);
        Dimension leftAxisPreferredSize = leftAxisVisible ? this.getLeftAxisPreferredSize() : new Dimension(0, 0);
        this.setBottomAxisSize(bottomAxisPreferredSize);
        this.setLeftAxisSize(leftAxisPreferredSize);
    }

    public void addComponent(Node component) {
        if (this.mainContainer != null) {
            this.mainContainer.set(JavaFXFactory.getInstance().createComponent(component));
        }
    }

    public void addBottomTimeAxisComponent(Node component) {
        if (this.getBottomTimeAxisContainer() != null) {
            this.bottomTimeAxisContainer.set(JavaFXFactory.getInstance().createComponent(component));
            this.valideAxis();
        }
    }

    public void addTopTimeAxisComponent(Node component) {
        if (this.getTopTimeAxisContainer() != null) {
            this.topTimeAxisContainer.set(JavaFXFactory.getInstance().createComponent(component));
            this.valideAxis();
        }
    }

    public void addLeftYAxisComponent(Node component) {
        if (this.getLeftYAxisContainer() != null) {
            this.leftYAxisContainer.set(JavaFXFactory.getInstance().createComponent(component));
            this.valideAxis();
        }
    }

    public void addRightYAxisComponent(Node component) {
        if (this.getRightYAxisContainer() != null) {
            this.rightYAxisContainer.set(JavaFXFactory.getInstance().createComponent(component));
            this.valideAxis();
        }
    }

    public void setLeftAxisSize(Dimension d) {
    }

    public void setTopAxisSize(Dimension d) {
    }

    public void setBottomAxisSize(Dimension d) {
    }

    public void setLeftAxisVisible(boolean visible) {
        if (this.getLeftYAxisContainer().isVisible() != visible) {
            this.getLeftYAxisContainer().setVisible(visible);
        }
    }

    public void setRightAxisVisible(boolean visible) {
        if (this.getRightYAxisContainer().isVisible() != visible) {
            this.getRightYAxisContainer().setVisible(visible);
        }
    }

    public void setTopAxisVisible(boolean visible) {
        if (this.getTopTimeAxisContainer().isVisible() != visible) {
            this.getTopTimeAxisContainer().setVisible(visible);
        }
    }

    public void setBottomAxisVisible(boolean visible) {
        if (this.getBottomTimeAxisContainer().isVisible() != visible) {
            this.getBottomTimeAxisContainer().setVisible(visible);
        }
    }

    public void setStyleClass(String ... styleClasses) {
    }
}

