/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import com.macrofocus.common.interval.IntervalEvent;
import com.macrofocus.common.interval.IntervalListener;
import com.macrofocus.plot.guide.AbstractJavaFXGuide;
import com.macrofocus.plot.guide.AxisGuide;
import com.macrofocus.plot.guide.Guide;
import com.macrofocus.plot.guide.MyNumberAxis;
import com.macrofocus.transform.OneDScreenTransform;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;

public abstract class AbstractJavaFXAxisGuide
extends AbstractJavaFXGuide
implements AxisGuide<Node, Color, Font> {
    private final Guide.Type type;
    protected final MyNumberAxis axis;

    public AbstractJavaFXAxisGuide(Guide.Type type) {
        this.type = type;
        this.axis = new MyNumberAxis(0.0, 100.0, 1.0);
        switch (type) {
            case Bottom: {
                this.axis.setSide(Side.BOTTOM);
                break;
            }
            case Top: {
                this.axis.setSide(Side.TOP);
                break;
            }
            case Left: {
                this.axis.setSide(Side.LEFT);
                break;
            }
            case Right: {
                this.axis.setSide(Side.RIGHT);
            }
        }
    }

    public void setCoordinateAxis(final OneDScreenTransform coordinateAxis) {
        this.axis.setLowerBound(coordinateAxis.getWorldMin());
        this.axis.setUpperBound(coordinateAxis.getWorldMax());
        double length = this.axis.getSide().isVertical() ? this.axis.getHeight() : this.axis.getWidth();
        double labelSize = this.axis.getTickLabelFont().getSize() * 2.0;
        Object range = this.axis.autoRange(coordinateAxis.getWorldMin(), coordinateAxis.getWorldMax(), length, labelSize);
        this.axis.setRange(range, false);
        coordinateAxis.getWorldInterval().addIntervalListener(new IntervalListener(){

            public void intervalChanged(IntervalEvent event) {
                double length = AbstractJavaFXAxisGuide.this.axis.getSide().isVertical() ? AbstractJavaFXAxisGuide.this.axis.getHeight() : AbstractJavaFXAxisGuide.this.axis.getWidth();
                double labelSize = AbstractJavaFXAxisGuide.this.axis.getTickLabelFont().getSize() * 2.0;
                Object range = AbstractJavaFXAxisGuide.this.axis.autoRange(coordinateAxis.getWorldMin(), coordinateAxis.getWorldMax(), length, labelSize);
                AbstractJavaFXAxisGuide.this.axis.setRange(range, false);
            }
        });
    }

    public Node getNativeComponent() {
        return this.axis;
    }
}

