/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.filters.javafx;

import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.crossplatform.javafx.JavaFXCanvas;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.crossplatform.javafx.property.JavaFXPropertyHelper;
import com.macrofocus.high_d.filters.AbstractCategoricalFilterComponent;
import com.macrofocus.high_d.filters.CategoricalFilterComponent;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.molap.subset.BinningDimension;
import com.macrofocus.molap.subset.DimensionEvent;
import com.macrofocus.molap.subset.DimensionListener;
import com.macrofocus.molap.subset.Reducer;
import com.macrofocus.rubberband.RubberbandDrawing;
import com.macrofocus.visual.Visual;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;

public class DefaultJavaFXCategoricalFilterComponent<Row, C, Value, Bin>
extends AbstractCategoricalFilterComponent<Node, Color, Row, C, Value, Bin> {
    private final ScrollPane scrollPane;
    private final JavaFXCanvas canvas;
    private BorderPane mainPanel;
    private MutableBoundedInterval interval;
    private Label label;
    private String headerLabel;
    private final CheckMenuItem hideFilteredButton;
    private final CheckMenuItem sortButton;
    private final CheckMenuItem proportionalButton;
    private final CheckMenuItem overviewButton;
    private final CheckMenuItem showAxis;
    private final CheckMenuItem showCumulative;
    private final SingleSelectionListener<Value> probingListener = new SingleSelectionListener<Value>(){

        public void selectionChanged(SingleSelectionEvent<Value> event) {
            DefaultJavaFXCategoricalFilterComponent.this.canvas.repaint();
        }
    };
    private final SelectionListener selectionListener = new SelectionListener(){

        public void selectionChanged(SelectionEvent event) {
            DefaultJavaFXCategoricalFilterComponent.this.canvas.repaint();
            DefaultJavaFXCategoricalFilterComponent.this.updateLabel();
        }
    };
    private final DimensionListener dimensionListener = new DimensionListener(){

        public void dimensionChanged(DimensionEvent event) {
            DefaultJavaFXCategoricalFilterComponent.this.activeBins = null;
            DefaultJavaFXCategoricalFilterComponent.this.activeBinsIndex = null;
            double max = DefaultJavaFXCategoricalFilterComponent.this.getMax();
            DefaultJavaFXCategoricalFilterComponent.this.interval.setMaximumExtent(max);
            DefaultJavaFXCategoricalFilterComponent.this.interval.setExtent(max);
            DefaultJavaFXCategoricalFilterComponent.this.canvas.repaint();
        }

        public void selectedCountChanged() {
            DefaultJavaFXCategoricalFilterComponent.this.canvas.repaint();
        }
    };
    private final PropertiesListener propertiesListener = new PropertiesListener(){

        public void propertyChanged(Object name, PropertyEvent event) {
            DefaultJavaFXCategoricalFilterComponent.this.activeBins = null;
            DefaultJavaFXCategoricalFilterComponent.this.activeBinsIndex = null;
            DefaultJavaFXCategoricalFilterComponent.this.updateOrientation();
            DefaultJavaFXCategoricalFilterComponent.this.updateAxis();
            DefaultJavaFXCategoricalFilterComponent.this.resize();
            DefaultJavaFXCategoricalFilterComponent.this.canvas.repaint();
        }
    };

    public DefaultJavaFXCategoricalFilterComponent(BinningDimension<Row, Bin> dimension, Visual<Color, Row, C> visual, Reducer<Row, Bin> reducer) {
        super((CPColorFactory)JavaFXFactory.getInstance(), dimension, reducer);
        this.canvas = new JavaFXCanvas();
        this.scrollPane = new ScrollPane();
        this.scrollPane.setContent(this.canvas.getNativeComponent());
        this.scrollPane.setFitToWidth(true);
        this.scrollPane.setFitToHeight(true);
        this.scrollPane.widthProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                DefaultJavaFXCategoricalFilterComponent.this.resize();
            }
        });
        this.scrollPane.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                System.err.println("ChangeListener");
                DefaultJavaFXCategoricalFilterComponent.this.resize();
            }
        });
        this.scrollPane.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                System.err.println("ChangeListener");
                DefaultJavaFXCategoricalFilterComponent.this.resize();
            }
        });
        String style = "bars";
        this.hideFilteredButton = new CheckMenuItem("Show filtered " + style);
        JavaFXPropertyHelper.bindBidirectional((MutableProperty)this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.ShowFiltered), (javafx.beans.property.Property)this.hideFilteredButton.selectedProperty());
        this.sortButton = new CheckMenuItem();
        JavaFXPropertyHelper.bindBidirectional((MutableProperty)this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.Sort), (javafx.beans.property.Property)this.sortButton.selectedProperty());
        this.proportionalButton = new CheckMenuItem();
        JavaFXPropertyHelper.bindBidirectional((MutableProperty)this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.Proportional), (javafx.beans.property.Property)this.proportionalButton.selectedProperty());
        this.overviewButton = new CheckMenuItem();
        MutableProperty overviewProperty = this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.MinItemSize);
        this.overviewButton.setSelected((Integer)overviewProperty.getValue() <= 0);
        JavaFXPropertyHelper.bind((javafx.beans.property.Property)this.overviewButton.selectedProperty(), (MutableProperty)overviewProperty, v -> v != false ? 0 : 16);
        this.showAxis = new CheckMenuItem();
        JavaFXPropertyHelper.bindBidirectional((MutableProperty)this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.ShowAxis), (javafx.beans.property.Property)this.showAxis.selectedProperty());
        this.showCumulative = new CheckMenuItem();
        JavaFXPropertyHelper.bindBidirectional((MutableProperty)this.properties.getProperty((Object)CategoricalFilterComponent.PropertyType.ShowCumulative), (javafx.beans.property.Property)this.showCumulative.selectedProperty());
        MenuButton dropDownMenu = new MenuButton();
        dropDownMenu.getItems().setAll((Object[])new MenuItem[]{this.hideFilteredButton, this.sortButton, this.proportionalButton, this.overviewButton, this.showAxis, this.showCumulative});
        HBox buttonPanel = new HBox(new Node[]{dropDownMenu});
        this.label = new Label();
        BorderPane.setAlignment((Node)this.label, (Pos)Pos.CENTER);
        this.setLabel(dimension.getName());
        this.updateLabel();
        this.interval = new SimpleBoundedInterval(0.0, this.getMax());
        this.updateOrientation();
        this.updateAxis();
        AbstractCategoricalFilterComponent.FilterIDrawing iDrawing = new AbstractCategoricalFilterComponent.FilterIDrawing((AbstractCategoricalFilterComponent)this);
        this.canvas.addLayer((IDrawing)iDrawing);
        this.canvas.addLayer((IDrawing)new RubberbandDrawing(this.factory, this.getRubberBand()){

            protected Property<ColorTheme<Color>> getColorTheme() {
                return DefaultJavaFXCategoricalFilterComponent.this.getColorTheme();
            }
        });
        this.canvas.addKeyListener((CPCanvas.KeyListener)new AbstractCategoricalFilterComponent.DefaultKeyListener((AbstractCategoricalFilterComponent)this, dimension));
        this.canvas.addMouseListener((CPCanvas.MouseListener)new AbstractCategoricalFilterComponent.DefaultMouseListener((AbstractCategoricalFilterComponent)this));
        this.canvas.addMouseMotionListener((CPCanvas.MouseMotionListener)new AbstractCategoricalFilterComponent.DefaultMouseMotionListener((AbstractCategoricalFilterComponent)this));
        dimension.getFilterExact().addWeakSelectionListener(this.selectionListener);
        dimension.addWeakDimensionListener(this.dimensionListener);
        this.properties.addPropertiesListener(this.propertiesListener);
        if (visual != null) {
            visual.getProbing().addSingleSelectionListener(new SingleSelectionListener<Row>(){

                public void selectionChanged(SingleSelectionEvent<Row> event) {
                }
            });
        }
        this.getMinItemSize().addPropertyListener((PropertyListener)new PropertyListener<Integer>(){

            public void propertyChanged(PropertyEvent<Integer> event) {
                DefaultJavaFXCategoricalFilterComponent.this.updateMinItemSize();
            }
        });
        this.updateMinItemSize();
        this.mainPanel = new BorderPane((Node)this.scrollPane);
        BorderPane headerPanel = new BorderPane((Node)this.label);
        headerPanel.setRight((Node)buttonPanel);
        this.mainPanel.setTop((Node)headerPanel);
        this.resize();
    }

    protected void populate() {
        this.canvas.repaint();
    }

    private void updateMinItemSize() {
        this.scrollPane.setFitToHeight(this.getOrientation().getValue() != CategoricalFilterComponent.Orientation.Horizontal || (Integer)this.getMinItemSize().getValue() <= 0);
    }

    private void resize() {
        int width = this.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Horizontal ? (int)this.scrollPane.getWidth() : 130;
        int viewportHeight = (int)this.scrollPane.getViewportBounds().getHeight();
        int viewportWidth = (int)this.scrollPane.getViewportBounds().getWidth();
        long height = this.computeIdealHeight(this.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Horizontal ? viewportHeight : viewportWidth);
        if (this.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Horizontal) {
            System.err.println(String.valueOf(this.getOrientation().getValue()) + ": " + viewportWidth + " x " + height);
            this.canvas.getNativeComponent().resize((double)Math.min(16384, viewportWidth), (double)Math.min(16384L, height));
        } else {
            System.err.println(String.valueOf(this.getOrientation().getValue()) + ": " + height + " x " + viewportHeight);
            this.canvas.getNativeComponent().resize((double)Math.min(16384L, height), (double)Math.min(16384, viewportHeight));
        }
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractJavaFXComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public void setLabel(String label) {
        this.headerLabel = label;
        this.updateLabel();
    }

    public void updateLabel() {
        this.label.setText(this.headerLabel + (this.dimension.getFilterExact().isActive() ? " *" : ""));
    }

    private void updateOrientation() {
        String style = "bars";
        String barDirection = this.getOrientation().getValue() == CategoricalFilterComponent.Orientation.Horizontal ? "width" : "height";
        this.hideFilteredButton.setText("Show filtered " + style);
        this.sortButton.setText("Sort " + style + " by " + barDirection);
        this.proportionalButton.setText("Use relative scale for " + style + " " + barDirection);
        this.overviewButton.setText("Overview");
        this.showAxis.setText("Show axis");
        this.showCumulative.setText("Show cumulative graph");
    }

    private void updateAxis() {
    }

    public Node getNativeComponent() {
        return this.mainPanel;
    }

    public int getWidth() {
        return (int)this.canvas.getWidth();
    }

    public int getHeight() {
        return (int)this.canvas.getHeight();
    }
}

