/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.filters.javafx;

import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPWeightedPanel;
import com.macrofocus.crossplatform.javafx.AbstractJavaFXComponent;
import com.macrofocus.crossplatform.javafx.JavaFXFactory;
import com.macrofocus.crossplatform.javafx.JavaFXHorizontalPanel;
import com.macrofocus.crossplatform.javafx.JavaFXVerticalPanel;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.filters.AbstractFilters;
import com.macrofocus.high_d.filters.CategoricalFilterComponent;
import com.macrofocus.high_d.filters.Filters;
import com.macrofocus.high_d.filters.javafx.DefaultJavaFXCategoricalFilterComponent;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.molap.subset.CategoricalDimension;
import com.macrofocus.molap.subset.Reducer;
import com.macrofocus.molap.subset.SubsetDataFrame;
import com.macrofocus.visual.Visual;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.paint.Color;

public class JavaFXFilters<R, C, V>
extends AbstractFilters<Node, Color, R, C, V> {
    private final CPWeightedPanel<Node> panel;
    private Map<C, CategoricalFilterComponent<Node, Color>> components = new HashMap<C, CategoricalFilterComponent<Node, Color>>();

    public JavaFXFilters() {
        this(Filters.Orientation.Horizontal);
    }

    public JavaFXFilters(Filters.Orientation orientation) {
        super((CPColorFactory)JavaFXFactory.getInstance(), orientation);
        this.panel = orientation == Filters.Orientation.Horizontal ? new JavaFXHorizontalPanel() : new JavaFXVerticalPanel();
        this.properties.addPropertiesListener(new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                JavaFXFilters.this.updateOrientation();
            }
        });
        this.updateOrientation();
    }

    private void updateOrientation() {
        for (CategoricalFilterComponent<Node, Color> component : this.components.values()) {
            component.getOrientation().setValue((Object)(this.getOrientation().getValue() == Filters.Orientation.Horizontal ? CategoricalFilterComponent.Orientation.Horizontal : CategoricalFilterComponent.Orientation.Vertical));
        }
    }

    public JavaFXFilters(SubsetDataFrame<R, C, V> subsetDataFrame, Visual<Color, R, C> visual, AxisGroupModel<R, C> axisGroupModel, Reducer<R, V> reducer) {
        this();
        this.setModel(subsetDataFrame, visual, axisGroupModel, reducer, null);
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractJavaFXComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public void reset() {
        for (CategoricalFilterComponent<Node, Color> component : this.components.values()) {
            component.getDimension().filterAll();
        }
    }

    protected void updateAxis() {
        this.removeAllColumns();
        for (AxisModel axisModel : this.root.getAxisOrder()) {
            this.addColumn(axisModel.getColumn());
        }
    }

    public void addColumn(C column) {
        CategoricalDimension dimension = this.subsetDataFrame.getCategoricalDimension(column);
        DefaultJavaFXCategoricalFilterComponent component = new DefaultJavaFXCategoricalFilterComponent(dimension, this.visual, this.reducer);
        component.setColorTheme(this.getColorTheme());
        component.getOrientation().setValue((Object)(this.getOrientation().getValue() == Filters.Orientation.Horizontal ? CategoricalFilterComponent.Orientation.Horizontal : CategoricalFilterComponent.Orientation.Vertical));
        component.getGapSize().setValue((Object)1);
        component.setShowFiltered(this.getShowFiltered());
        component.setInteractionMode(this.getInteractionMode());
        this.components.put(column, (CategoricalFilterComponent<Node, Color>)component);
        this.panel.add(component);
    }

    public void removeAllColumns() {
        this.components.clear();
        this.updateOrientation();
    }

    public Iterable<CategoricalFilterComponent<Node, Color>> getFilterComponents() {
        return this.components.values();
    }

    public CategoricalFilterComponent<Node, Color> getFilterComponent(C column) {
        return this.components.get(column);
    }

    public Node getNativeComponent() {
        return (Node)this.panel.getNativeComponent();
    }
}

