/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter.java;

import com.macrofocus.data.dataframe.DataFrameTableModel;
import com.macrofocus.data.table.TableHelper;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.exporter.DataFrameExporter;
import com.macrofocus.molap.exporter.DataFrameWriter;
import com.macrofocus.molap.exporter.java.AbstractDataFrameWriter;
import com.macrofocus.molap.exporter.java.DelimitedStreamDataFrameWriter;
import com.macrofocus.molap.exporter.java.ExcelDataFrameWriter;
import com.macrofocus.molap.exporter.java.ExcelXDataFrameWriter;
import com.macrofocus.molap.exporter.java.GeoJSONDataFrameWriter;
import com.macrofocus.molap.exporter.java.JSONDataFrameWriter;
import com.macrofocus.molap.exporter.java.SQLDialect;
import com.macrofocus.molap.exporter.java.SQLDialectEnum;
import com.macrofocus.util.file.FileHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.TimeZone;
import javax.swing.table.TableModel;
import org.locationtech.jts.geom.Geometry;

public class SwingDataFrameExporter
extends DataFrameExporter {
    private static TimeZone timeZone = TimeZone.getTimeZone("UTC");
    private static SwingDataFrameExporter ourInstance = new SwingDataFrameExporter();

    private SwingDataFrameExporter() {
    }

    public static SwingDataFrameExporter getInstance() {
        return ourInstance;
    }

    public static void setTimeZone(TimeZone tmz) {
        timeZone = tmz;
    }

    public static void exportSerialize(DataFrame dataFrame, File file) throws IOException {
        TableHelper.write((TableModel)new DataFrameTableModel(dataFrame), (File)file);
    }

    public static void exportCSV(DataFrame dataFrame, File file) throws IOException {
        SwingDataFrameExporter.exportDelimited(dataFrame, file, ",");
    }

    public static void exportTSV(DataFrame dataFrame, File file) throws IOException {
        SwingDataFrameExporter.exportDelimited(dataFrame, file, "\t");
    }

    protected static void exportDelimited(DataFrame dataFrame, File file, String delimiter) throws IOException {
        String newLine = "\n";
        DelimitedStreamDataFrameWriter writer = new DelimitedStreamDataFrameWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), dataFrame.getColumnCount(), delimiter, "\n");
        SwingDataFrameExporter.export(dataFrame, writer);
    }

    public static String exportJSON(DataFrame dataFrame) throws IOException {
        String newLine = "\n";
        StringWriter stringWriter = new StringWriter();
        JSONDataFrameWriter writer = new JSONDataFrameWriter(stringWriter, "\n");
        SwingDataFrameExporter.export(dataFrame, writer);
        return stringWriter.getBuffer().toString();
    }

    public static void exportJSON(DataFrame dataFrame, File file) throws IOException {
        String newLine = "\n";
        JSONDataFrameWriter writer = new JSONDataFrameWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), "\n");
        SwingDataFrameExporter.export(dataFrame, writer);
    }

    public static void exportGeoJSON(DataFrame dataFrame, File file) throws IOException {
        String newLine = "\n";
        GeoJSONDataFrameWriter writer = new GeoJSONDataFrameWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8), dataFrame.getColumnCount(), "\n");
        SwingDataFrameExporter.export(dataFrame, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void export(DataFrame dataFrame, DataFrameWriter writer) throws IOException {
        Object value;
        int column;
        writer.setTimeZone(timeZone);
        writer.start();
        for (column = 0; column < dataFrame.getColumnCount(); ++column) {
            value = dataFrame.getColumnName(dataFrame.getColumnKey(column));
            writer.writeColumnName((String)value, column < dataFrame.getColumnCount() - 1);
        }
        writer.nextRow();
        if (writer.includeType()) {
            for (column = 0; column < dataFrame.getColumnCount(); ++column) {
                value = dataFrame.getColumnClass(dataFrame.getColumnKey(column));
                writer.writeType((Class)value, column < dataFrame.getColumnCount() - 1);
            }
            writer.nextRow();
        }
        for (int row = 0; row < dataFrame.getRowCount(); ++row) {
            for (int column2 = 0; column2 < dataFrame.getColumnCount(); ++column2) {
                try {
                    Object rowKey = dataFrame.getRowKey(row);
                    Object columnKey = dataFrame.getColumnKey(column2);
                    Object value2 = dataFrame.getValueAt(rowKey, columnKey);
                    if (value2 instanceof Geometry) {
                        value2 = TableHelper.convertGeometryToWKT((Geometry)((Geometry)value2));
                    }
                    writer.writeCell(value2, dataFrame, rowKey, columnKey);
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        writer.nextColumn(column2 < dataFrame.getColumnCount() - 1);
                        throw throwable;
                    }
                    writer.nextColumn(column2 < dataFrame.getColumnCount() - 1);
                    continue;
                }
                writer.nextColumn(column2 < dataFrame.getColumnCount() - 1);
                continue;
            }
            writer.nextRow();
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportExcel(DataFrame dataFrame, File file) throws IOException {
        ExcelDataFrameWriter writer = new ExcelDataFrameWriter(new FileOutputStream(file));
        writer.start();
        for (int column = 0; column < dataFrame.getColumnCount(); ++column) {
            String value = dataFrame.getColumnName(dataFrame.getColumnKey(column));
            writer.writeColumnName(value, column < dataFrame.getColumnCount() - 1);
        }
        writer.nextRow();
        for (int row = 0; row < dataFrame.getRowCount(); ++row) {
            for (int column = 0; column < dataFrame.getColumnCount(); ++column) {
                try {
                    Object rowKey = dataFrame.getRowKey(row);
                    Object columnKey = dataFrame.getColumnKey(column);
                    Object value = dataFrame.getValueAt(rowKey, columnKey);
                    if (value instanceof Geometry) {
                        value = TableHelper.convertGeometryToWKT((Geometry)((Geometry)value));
                    }
                    writer.writeCell(value, dataFrame, rowKey, columnKey);
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        writer.nextColumn(column < dataFrame.getColumnCount() - 1);
                        throw throwable;
                    }
                    writer.nextColumn(column < dataFrame.getColumnCount() - 1);
                    continue;
                }
                writer.nextColumn(column < dataFrame.getColumnCount() - 1);
                continue;
            }
            writer.nextRow();
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportExcelX(DataFrame dataFrame, OutputStream outputStream) throws IOException {
        ExcelXDataFrameWriter writer = new ExcelXDataFrameWriter(outputStream);
        writer.start();
        for (int column = 0; column < dataFrame.getColumnCount(); ++column) {
            String value = dataFrame.getColumnName(dataFrame.getColumnKey(column));
            writer.writeColumnName(value, column < dataFrame.getColumnCount() - 1);
        }
        writer.nextRow();
        for (int row = 0; row < dataFrame.getRowCount(); ++row) {
            for (int column = 0; column < dataFrame.getColumnCount(); ++column) {
                try {
                    Object rowKey = dataFrame.getRowKey(row);
                    Object columnKey = dataFrame.getColumnKey(column);
                    Object value = dataFrame.getValueAt(rowKey, columnKey);
                    if (value instanceof Geometry) {
                        value = TableHelper.convertGeometryToWKT((Geometry)((Geometry)value));
                    }
                    writer.writeCell(value, dataFrame, rowKey, columnKey);
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        writer.nextColumn(column < dataFrame.getColumnCount() - 1);
                        throw throwable;
                    }
                    writer.nextColumn(column < dataFrame.getColumnCount() - 1);
                    continue;
                }
                writer.nextColumn(column < dataFrame.getColumnCount() - 1);
                continue;
            }
            writer.nextRow();
        }
        writer.close();
    }

    public static void exportExcelX(DataFrame dataFrame, File file) throws IOException {
        SwingDataFrameExporter.exportExcelX(dataFrame, new FileOutputStream(file));
    }

    protected static Class getCommonType(DataFrame dataFrame, Object column) {
        Class<Object> common = null;
        for (Object o : dataFrame.rows()) {
            Object value = dataFrame.getValueAt(o, column);
            if (value == null) continue;
            Class<?> cl = value.getClass();
            if (common == null) {
                common = cl;
                continue;
            }
            if (common == cl) continue;
            common = Geometry.class;
            break;
        }
        return common;
    }

    public void exportSQL(DataFrame dataFrame, File file) throws IOException {
        String tableName = "\"" + FileHelper.removeSuffix((String)file.getName()) + "\"";
        this.exportSQL(dataFrame, tableName, SQLDialectEnum.STANDARD, false, new FileOutputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportSQL(DataFrame dataFrame, String tableName, SQLDialect dialect, boolean drop, OutputStream outputStream) throws IOException {
        String columnName;
        String newLine = "\n";
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        if (drop) {
            writer.write("DROP TABLE IF EXISTS " + tableName + ";\n");
        }
        writer.write("CREATE TABLE " + tableName + " (\n");
        for (int column = 0; column < dataFrame.getColumnCount(); ++column) {
            Object columnKey = dataFrame.getColumnKey(column);
            String type = dialect.getColumnType(dataFrame.getColumnClass(columnKey), 256);
            columnName = "\"" + dataFrame.getColumnName(columnKey) + "\"";
            writer.write("\t" + columnName + " " + type);
            if (column < dataFrame.getColumnCount() - 1) {
                writer.write(",");
            }
            writer.write("\n");
        }
        writer.write(");\n");
        for (int row = 0; row < dataFrame.getRowCount(); ++row) {
            int column;
            writer.write("INSERT INTO " + tableName + " (");
            for (column = 0; column < dataFrame.getColumnCount(); ++column) {
                Object columnKey = dataFrame.getColumnKey(column);
                columnName = "\"" + dataFrame.getColumnName(columnKey) + "\"";
                writer.write(columnName);
                if (column >= dataFrame.getColumnCount() - 1) continue;
                writer.write(", ");
            }
            writer.write(") VALUES (");
            for (column = 0; column < dataFrame.getColumnCount(); ++column) {
                try {
                    String string;
                    Object value = dataFrame.getValueAt(dataFrame.getRowKey(row), dataFrame.getColumnKey(column));
                    if (value instanceof Geometry) {
                        writer.write("'" + TableHelper.convertGeometryToWKT((Geometry)((Geometry)value)) + "'");
                        continue;
                    }
                    if (value instanceof Number) {
                        writer.write(AbstractDataFrameWriter.numberToString((Number)value));
                        continue;
                    }
                    if (value instanceof String) {
                        string = (String)value;
                        string = string.replaceAll("\\?", "");
                        string = string.replaceAll("\u0000", "");
                        string = string.replace("'", "''");
                        string = string.replace("\\", "\\\\");
                        writer.write("'" + string + "'");
                        continue;
                    }
                    if (value instanceof URL) {
                        string = value.toString();
                        string = string.replaceAll("\\?", "");
                        string = string.replaceAll("\u0000", "");
                        string = string.replace("'", "''");
                        string = string.replace("\\", "\\\\");
                        writer.write("'" + string + "'");
                        continue;
                    }
                    if (value != null) {
                        writer.write("'" + value.toString() + "'");
                        continue;
                    }
                    writer.write("NULL");
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    if (column < dataFrame.getColumnCount() - 1) {
                        writer.write(", ");
                    }
                }
            }
            writer.write(");");
            writer.write("\n");
        }
        writer.close();
    }
}

