/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter.parquet;

import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.exporter.parquet.DataFrameSchemaConverter;
import com.macrofocus.molap.exporter.parquet.DataFrameWriteSupport;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.OutputFile;

public class DataFrameParquetWriter<T>
extends ParquetWriter<T> {
    public static <T> Builder<T> builder(Path file) {
        return new Builder(file);
    }

    public static <T> Builder<T> builder(OutputFile file) {
        return new Builder(file);
    }

    @Deprecated
    public DataFrameParquetWriter(Path file, DataFrame dataFrame, CompressionCodecName compressionCodecName, int blockSize, int pageSize) throws IOException {
        super(file, DataFrameParquetWriter.writeSupport(dataFrame), compressionCodecName, blockSize, pageSize);
    }

    @Deprecated
    public DataFrameParquetWriter(Path file, DataFrame dataFrame, CompressionCodecName compressionCodecName, int blockSize, int pageSize, boolean enableDictionary) throws IOException {
        super(file, DataFrameParquetWriter.writeSupport(dataFrame), compressionCodecName, blockSize, pageSize, enableDictionary, false);
    }

    @Deprecated
    public DataFrameParquetWriter(Path file, DataFrame dataFrame) throws IOException {
        this(file, dataFrame, CompressionCodecName.UNCOMPRESSED, 0x8000000, 0x100000);
    }

    private static <T> WriteSupport<T> writeSupport(DataFrame dataFrame) {
        return new DataFrameWriteSupport(new DataFrameSchemaConverter().convert(dataFrame), dataFrame);
    }

    private static <T> WriteSupport<T> writeSupport(Configuration conf, DataFrame dataFrame) {
        return new DataFrameWriteSupport(new DataFrameSchemaConverter(conf).convert(dataFrame), dataFrame);
    }

    public static class Builder<T>
    extends ParquetWriter.Builder<T, Builder<T>> {
        private DataFrame schema = null;

        private Builder(Path file) {
            super(file);
        }

        private Builder(OutputFile file) {
            super(file);
        }

        public Builder<T> withSchema(DataFrame schema) {
            this.schema = schema;
            return this;
        }

        protected Builder<T> self() {
            return this;
        }

        protected WriteSupport<T> getWriteSupport(Configuration conf) {
            return DataFrameParquetWriter.writeSupport(conf, this.schema);
        }
    }
}

