/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.helper;

import java.awt.Color;

public class ColorHelper {
    /*
     * WARNING - void declaration
     */
    public static int intMult(int a2, int b2) {
        void var1_1;
        return a2 * var1_1 / 255;
    }

    /*
     * WARNING - void declaration
     */
    public static int Inva(int a2, int c2) {
        void var1_1;
        int n;
        return (0xFF & ~n) * var1_1 / 255;
    }

    /*
     * WARNING - void declaration
     */
    public static int intPrelerp(int dest, int src, int alpha) {
        int n;
        void var2_2;
        void var1_1;
        return dest + var1_1 - ColorHelper.intMult((int)var2_2, n);
    }

    /*
     * WARNING - void declaration
     */
    public static int intLerp(int dest, int src, int alpha) {
        void var1_1;
        int n;
        void var2_2;
        return dest + ColorHelper.intMult((int)var2_2, n - var1_1);
    }

    public static Color desaturateColor(Color color) {
        return ColorHelper.desaturateColor(color, 0.3f, 0.5f);
    }

    /*
     * WARNING - void declaration
     */
    public static Color desaturateColor(Color color, float saturationMutliplier, float brightnessMultiplier) {
        Object object;
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), ((Color)object).getBlue(), null);
        object = fArray;
        if (fArray[1] <= 0.0f) {
            void var2_2;
            object[2] = object[2] + var2_2 * (1.0f - object[2]);
        } else {
            void var1_1;
            Object object2 = object;
            object2[1] = object2[1] * var1_1;
        }
        return new Color(Color.HSBtoRGB((float)object[0], (float)object[1], (float)object[2]));
    }

    /*
     * WARNING - void declaration
     */
    public static Color darker(Color color, double factor) {
        Color color2;
        void var1_1;
        return new Color(Math.max((int)((double)color.getRed() * factor), 0), Math.max((int)((double)color.getGreen() * factor), 0), Math.max((int)((double)color.getBlue() * var1_1), 0), color2.getAlpha());
    }

    public static Color brighter(Color color) {
        Color color2;
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color2.getBlue();
        return new Color(Math.min(n + 100, 255), Math.min(n2 + 100, 255), Math.min(n3 + 100, 255));
    }

    /*
     * WARNING - void declaration
     */
    public static Color brighter(Color color, double factor) {
        void var1_2;
        Color color2;
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color2.getBlue();
        int n4 = (int)(1.0 / (1.0 - factor));
        if (n == 0 && n2 == 0 && n3 == 0) {
            int n5 = n4;
            return new Color(n5, n5, n4);
        }
        if (n > 0 && n < n4) {
            n = n4;
        }
        if (n2 > 0 && n2 < n4) {
            n2 = n4;
        }
        if (n3 > 0 && n3 < n4) {
            n3 = n4;
        }
        return new Color(Math.min((int)((double)n / factor), 255), Math.min((int)((double)n2 / factor), 255), Math.min((int)((double)n3 / var1_2), 255));
    }

    public static String getHTMLColor(Color c2) {
        if (c2 != null) {
            Color color;
            String string = Integer.toHexString(c2.getAlpha());
            Object object = Integer.toHexString(c2.getRed());
            Object object2 = Integer.toHexString(c2.getBlue());
            Object object3 = Integer.toHexString(c2.getGreen());
            string = color.getAlpha() == 255 ? "" : (string.length() == 1 ? "0" + string : string);
            object = ((String)object).length() == 1 ? "0" + (String)object : object;
            object2 = ((String)object2).length() == 1 ? "0" + (String)object2 : object2;
            object3 = ((String)object3).length() == 1 ? "0" + (String)object3 : object3;
            return "#" + string + (String)object + (String)object3 + (String)object2;
        }
        return "";
    }

    public static Color parseHTMLColor(String c2) {
        if (c2 != null) {
            if (!c2.trim().equals("")) {
                Color color;
                if (c2.startsWith("#")) {
                    c2 = c2.substring(1);
                }
                boolean bl = c2.length() > 6;
                color = new Color((int)Long.parseLong((String)((Object)color), 16), bl);
                return color;
            }
            return null;
        }
        return null;
    }

    public static double lum(Color color) {
        Color color2;
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color2.getBlue();
        return 0.299 * (double)n + 0.587 * (double)n2 + 0.114 * (double)n3;
    }

    public static Color toGray(Color color) {
        int n;
        int n2 = n = (int)Math.round(ColorHelper.lum(color));
        Color color2 = new Color(n2, n2, n);
        return color2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean compatible(Color a2, Color b2) {
        void var1_1;
        return Math.abs(ColorHelper.lum(a2) - ColorHelper.lum((Color)var1_1)) >= 128.0;
    }

    /*
     * WARNING - void declaration
     */
    public static float diff(Color c1, Color c2) {
        void var1_2;
        Color color;
        int n = Math.abs(c1.getRed() - c2.getRed());
        int n2 = Math.abs(c1.getGreen() - c2.getGreen());
        int n3 = Math.abs(color.getBlue() - var1_2.getBlue());
        return (float)Math.max(n, Math.max(n2, n3)) / 255.0f;
    }

    public static float luminance(Color color) {
        Color color2;
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color2.getBlue();
        return (0.299f * (float)n + 0.587f * (float)n2 + 0.114f * (float)n3) / 255.0f;
    }

    public static float brightness(Color color) {
        Object object;
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), ((Color)object).getBlue(), null);
        object = fArray;
        return fArray[2];
    }

    /*
     * WARNING - void declaration
     */
    public static Color replaceBrightness(Color color, double brightness) {
        void var1_1;
        Object object;
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), ((Color)object).getBlue(), null);
        object = fArray;
        object = Color.getHSBColor(fArray[0], (float)object[1], (float)var1_1);
        return object;
    }
}

