/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.dataframe.rowmajor;

import com.macrofocus.common.collection.Iterables;
import com.macrofocus.molap.dataframe.AbstractMutableDataFrame;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.dataframe.rowmajor.RowMajorDataFrame;
import com.macrofocus.molap.index.DefaultUniqueIndex;
import com.macrofocus.molap.index.UniqueIndex;
import com.macrofocus.molap.series.Series;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public abstract class AbstractRowMajorDataFrame<R, C, V>
extends AbstractMutableDataFrame<R, C, V>
implements RowMajorDataFrame<R, C, V> {
    protected UniqueIndex<C> columnIndex;
    private UniqueIndex<R> a;
    private List<R> b = new ArrayList<R>();
    private RowMajorDataFrame.QueryBuilder<R, C, V> c = new DefaultQueryBuilder(this);

    /*
     * WARNING - void declaration
     */
    public AbstractRowMajorDataFrame(C ... columns) {
        void var1_1;
        this.columnIndex = new DefaultUniqueIndex<C>(var1_1);
    }

    @Override
    public Class getRowClass(R r2) {
        return Object.class;
    }

    @Override
    public UniqueIndex<R> getRowIndex() {
        if (this.a == null) {
            this.a = new DefaultUniqueIndex<R>(this.b, true);
        }
        return this.a;
    }

    @Override
    public UniqueIndex<C> getColumnIndex() {
        return this.columnIndex;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addRow(R row) {
        void var1_1;
        assert (!this.b.contains(row));
        this.b.add(row);
        this.a = null;
        this.notifyDataFrameChanged(new DataFrameEvent(Collections.singletonList(var1_1), null, false));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void replaceRow(R oldRow, R newRow) {
        void var2_2;
        void var1_1;
        this.b.set(this.getRowIndex().getAddress(oldRow), newRow);
        this.a = null;
        this.notifyDataFrameChanged(new DataFrameEvent(Iterables.forArray((Object[])new Object[]{var1_1, var2_2}), null, false));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addRow(int i2, R row) {
        void var2_2;
        void var1_1;
        this.b.add((int)var1_1, row);
        this.a = null;
        this.notifyDataFrameChanged(new DataFrameEvent(Collections.singletonList(var2_2), null, false));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addBeforeRow(R insertionPoint, R row) {
        void var2_2;
        void var1_1;
        this.b.add(this.getRowAddress(var1_1), row);
        this.a = null;
        this.notifyDataFrameChanged(new DataFrameEvent(Collections.singletonList(var2_2), null, false));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addAfterRow(R insertionPoint, R row) {
        void var2_2;
        void var1_1;
        this.b.add(this.getRowAddress(var1_1) + 1, row);
        this.a = null;
        this.notifyDataFrameChanged(new DataFrameEvent(Collections.singletonList(var2_2), null, false));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remove(R row) {
        void var1_1;
        this.b.remove(this.getRowAddress(row));
        this.a = null;
        this.notifyDataFrameChanged(new DataFrameEvent(Collections.singletonList(var1_1), null, false));
    }

    @Override
    public List<R> retrieve(RowMajorDataFrame.Query<R, C, V> query) {
        ArrayList arrayList = new ArrayList();
        for (Object Row2 : this.rows()) {
            if (!query.matches(Row2)) continue;
            arrayList.add(Row2);
        }
        return arrayList;
    }

    @Override
    public RowMajorDataFrame.QueryBuilder<R, C, V> getQueryBuilder() {
        return this.c;
    }

    @Override
    public DataFrame join(Series series, C[] cs) {
        return null;
    }

    @Override
    public Series<C, ?> getRow(R r2) {
        return null;
    }

    public class DefaultQueryBuilder
    implements RowMajorDataFrame.QueryBuilder<R, C, V> {
        private /* synthetic */ AbstractRowMajorDataFrame a;

        /*
         * WARNING - void declaration
         */
        private DefaultQueryBuilder(AbstractRowMajorDataFrame this$0) {
            void var1_1;
            this.a = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RowMajorDataFrame.Query<R, C, V> equal(C column, V value) {
            void var2_2;
            void var1_1;
            return new Equal(this.a, var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RowMajorDataFrame.Query<R, C, V> smallerThan(C column, V value) {
            void var2_2;
            void var1_1;
            return new SmallerThan(this.a, var1_1, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RowMajorDataFrame.Query<R, C, V> smallerThanOrEqualTo(C column, V value) {
            void var2_2;
            void var1_1;
            return new SmallerThan(this.a, var1_1, var2_2, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RowMajorDataFrame.Query<R, C, V> greaterThan(C column, V value) {
            void var2_2;
            void var1_1;
            return new GreaterThan(this.a, var1_1, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RowMajorDataFrame.Query<R, C, V> greaterThanOrEqualTo(C column, V value) {
            void var2_2;
            void var1_1;
            return new GreaterThan(this.a, var1_1, var2_2, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RowMajorDataFrame.Query<R, C, V> overlap(C start1, C end1, V start2, V end2) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new Overlap(this.a, var1_1, var2_2, var3_3, end2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RowMajorDataFrame.Query<R, C, V> and(RowMajorDataFrame.Query<R, C, V> q1, RowMajorDataFrame.Query<R, C, V> q2) {
            void var2_2;
            return q1.and((RowMajorDataFrame.Query)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RowMajorDataFrame.Query<R, C, V> or(RowMajorDataFrame.Query<R, C, V> q1, RowMajorDataFrame.Query<R, C, V> q2) {
            void var2_2;
            return q1.or((RowMajorDataFrame.Query)var2_2);
        }
    }

    public class Overlap
    extends AbstractQuery {
        private final C a;
        private final C b;
        private final V c;
        private final V d;
        private /* synthetic */ AbstractRowMajorDataFrame e;

        /*
         * WARNING - void declaration
         */
        public Overlap(AbstractRowMajorDataFrame this$0, C start1, C end1, V start2, V end2) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.e = this$0;
            super((AbstractRowMajorDataFrame)var1_1);
            this.a = var2_2;
            this.b = var3_3;
            this.c = start2;
            this.d = end2;
        }

        @Override
        public boolean matches(R row) {
            Comparable comparable;
            if (this.c == null || !(this.c instanceof Comparable) || this.d == null || !(this.d instanceof Comparable)) {
                return false;
            }
            if (this.c instanceof Date && this.d instanceof Date) {
                Date date = (Date)this.e.getValueAt(row, this.a);
                comparable = (Date)this.e.getValueAt(row, this.b);
                Date date2 = (Date)this.c;
                Date date3 = (Date)this.d;
                return date.before(date3) && date2.before((Date)comparable);
            }
            Comparable comparable2 = (Comparable)this.e.getValueAt(comparable, this.a);
            comparable = (Comparable)this.e.getValueAt(comparable, this.b);
            Comparable comparable3 = (Comparable)this.c;
            Comparable comparable4 = (Comparable)this.d;
            return comparable2.compareTo(comparable4) < 0 && comparable3.compareTo(comparable) < 0;
        }
    }

    public class GreaterThan
    extends AbstractQuery {
        private final C a;
        private final V b;
        private final boolean c;
        private /* synthetic */ AbstractRowMajorDataFrame d;

        /*
         * WARNING - void declaration
         */
        public GreaterThan(AbstractRowMajorDataFrame this$0, C column, V value, boolean valueInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.d = this$0;
            super((AbstractRowMajorDataFrame)var1_1);
            this.a = var2_2;
            this.b = var3_3;
            this.c = valueInclusive;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(R row) {
            void var1_1;
            if (this.b == null || !(this.b instanceof Comparable)) {
                return false;
            }
            int n2 = ((Comparable)this.b).compareTo(this.d.getValueAt(var1_1, this.a));
            if (this.c) {
                return n2 >= 0;
            }
            return n2 > 0;
        }
    }

    public class SmallerThan
    extends AbstractQuery {
        private final C a;
        private final V b;
        private final boolean c;
        private /* synthetic */ AbstractRowMajorDataFrame d;

        /*
         * WARNING - void declaration
         */
        public SmallerThan(AbstractRowMajorDataFrame this$0, C column, V value, boolean valueInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.d = this$0;
            super((AbstractRowMajorDataFrame)var1_1);
            this.a = var2_2;
            this.b = var3_3;
            this.c = valueInclusive;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(R row) {
            void var1_1;
            if (this.b == null || !(this.b instanceof Comparable)) {
                return false;
            }
            int n2 = ((Comparable)this.b).compareTo(this.d.getValueAt(var1_1, this.a));
            if (this.c) {
                return n2 <= 0;
            }
            return n2 < 0;
        }
    }

    public class Equal
    extends AbstractQuery {
        private final C a;
        private final V b;
        private /* synthetic */ AbstractRowMajorDataFrame c;

        /*
         * WARNING - void declaration
         */
        public Equal(AbstractRowMajorDataFrame this$0, C column, V value) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.c = this$0;
            super((AbstractRowMajorDataFrame)var1_1);
            this.a = var2_2;
            this.b = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean matches(R row) {
            void var1_1;
            if (this.b == null) {
                return this.c.getValueAt(row, this.a) == null;
            }
            return this.b.equals(this.c.getValueAt(var1_1, this.a));
        }
    }

    public class Or
    extends AbstractQuery {
        private final RowMajorDataFrame.Query<R, C, V>[] a;
        private /* synthetic */ AbstractRowMajorDataFrame b;

        /*
         * WARNING - void declaration
         */
        public Or(AbstractRowMajorDataFrame this$0, RowMajorDataFrame.Query<R, C, V> ... queries) {
            void var2_2;
            void var1_1;
            this.b = this$0;
            super((AbstractRowMajorDataFrame)var1_1);
            this.a = var2_2;
        }

        @Override
        public boolean matches(R row) {
            RowMajorDataFrame.Query<R, C, V>[] queryArray = this.a;
            int n2 = this.a.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                RowMajorDataFrame.Query query = queryArray[i2];
                if (!query.matches(row)) continue;
                return true;
            }
            return false;
        }
    }

    public class And
    extends AbstractQuery {
        private final RowMajorDataFrame.Query<R, C, V>[] a;
        private /* synthetic */ AbstractRowMajorDataFrame b;

        /*
         * WARNING - void declaration
         */
        public And(AbstractRowMajorDataFrame this$0, RowMajorDataFrame.Query<R, C, V> ... queries) {
            void var2_2;
            void var1_1;
            this.b = this$0;
            super((AbstractRowMajorDataFrame)var1_1);
            this.a = var2_2;
        }

        @Override
        public boolean matches(R row) {
            RowMajorDataFrame.Query<R, C, V>[] queryArray = this.a;
            int n2 = this.a.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                RowMajorDataFrame.Query query = queryArray[i2];
                if (query.matches(row)) continue;
                return false;
            }
            return true;
        }
    }

    public abstract class AbstractQuery
    implements RowMajorDataFrame.Query<R, C, V> {
        private /* synthetic */ AbstractRowMajorDataFrame a;

        /*
         * WARNING - void declaration
         */
        public AbstractQuery(AbstractRowMajorDataFrame this$0) {
            void var1_1;
            this.a = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RowMajorDataFrame.Query<R, C, V> equal(C column, V value) {
            void var2_2;
            void var1_1;
            return new Equal(this.a, var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RowMajorDataFrame.Query<R, C, V> smallerThan(C column, V value) {
            void var2_2;
            void var1_1;
            return new SmallerThan(this.a, var1_1, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RowMajorDataFrame.Query<R, C, V> smallerThanOrEqualTo(C column, V value) {
            void var2_2;
            void var1_1;
            return new SmallerThan(this.a, var1_1, var2_2, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RowMajorDataFrame.Query<R, C, V> greaterThan(C column, V value) {
            void var2_2;
            void var1_1;
            return new GreaterThan(this.a, var1_1, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RowMajorDataFrame.Query<R, C, V> greaterThanOrEqualTo(C column, V value) {
            void var2_2;
            void var1_1;
            return new GreaterThan(this.a, var1_1, var2_2, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RowMajorDataFrame.Query<R, C, V> and(RowMajorDataFrame.Query<R, C, V> query) {
            void var1_1;
            return new And(this.a, new RowMajorDataFrame.Query[]{this, var1_1});
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public RowMajorDataFrame.Query<R, C, V> or(RowMajorDataFrame.Query<R, C, V> query) {
            void var1_1;
            return new Or(this.a, new RowMajorDataFrame.Query[]{this, var1_1});
        }
    }
}

