/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.PrimeFinder;

public abstract class THash {
    protected static final float DEFAULT_LOAD_FACTOR = 0.5f;
    protected static final int DEFAULT_CAPACITY = 10;
    protected transient int _size;
    protected transient int _free;
    protected float _loadFactor;
    protected int _maxSize;
    protected int _autoCompactRemovesRemaining;
    protected float _autoCompactionFactor;
    protected transient boolean _autoCompactTemporaryDisable = false;

    public THash() {
        this(10, 0.5f);
    }

    /*
     * WARNING - void declaration
     */
    public THash(int initialCapacity) {
        this((int)var1_1, 0.5f);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public THash(int initialCapacity, float loadFactor) {
        void var2_2;
        void var1_1;
        this._loadFactor = loadFactor;
        this._autoCompactionFactor = loadFactor;
        this.setUp(HashFunctions.fastCeil((float)var1_1 / var2_2));
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public int size() {
        return this._size;
    }

    public abstract int capacity();

    /*
     * WARNING - void declaration
     */
    public void ensureCapacity(int desiredCapacity) {
        if (desiredCapacity > this._maxSize - this.size()) {
            void var1_1;
            THash tHash = this;
            tHash.rehash(PrimeFinder.nextPrime(Math.max(tHash.size() + 1, HashFunctions.fastCeil((float)(var1_1 + this.size()) / this._loadFactor) + 1)));
            THash tHash2 = this;
            tHash2.computeMaxSize(tHash2.capacity());
        }
    }

    public void compact() {
        THash tHash = this;
        tHash.rehash(PrimeFinder.nextPrime(Math.max(tHash._size + 1, HashFunctions.fastCeil((float)this.size() / this._loadFactor) + 1)));
        THash tHash2 = this;
        tHash2.computeMaxSize(tHash2.capacity());
        if (this._autoCompactionFactor != 0.0f) {
            THash tHash3 = this;
            tHash3.computeNextAutoCompactionAmount(tHash3.size());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAutoCompactionFactor(float factor) {
        void var1_1;
        if (factor < 0.0f) {
            throw new IllegalArgumentException("Factor must be >= 0: " + factor);
        }
        this._autoCompactionFactor = var1_1;
    }

    public float getAutoCompactionFactor() {
        return this._autoCompactionFactor;
    }

    public final void trimToSize() {
        this.compact();
    }

    protected void removeAt(int index) {
        --this._size;
        if (this._autoCompactionFactor != 0.0f) {
            --this._autoCompactRemovesRemaining;
            if (!this._autoCompactTemporaryDisable && this._autoCompactRemovesRemaining <= 0) {
                this.compact();
            }
        }
    }

    public void clear() {
        this._size = 0;
        this._free = this.capacity();
    }

    /*
     * WARNING - void declaration
     */
    protected int setUp(int initialCapacity) {
        void var1_1;
        int n2 = PrimeFinder.nextPrime(initialCapacity);
        this.computeMaxSize(n2);
        this.computeNextAutoCompactionAmount((int)var1_1);
        return n2;
    }

    protected abstract void rehash(int var1);

    public void tempDisableAutoCompaction() {
        this._autoCompactTemporaryDisable = true;
    }

    /*
     * WARNING - void declaration
     */
    public void reenableAutoCompaction(boolean check_for_compaction) {
        void var1_1;
        this._autoCompactTemporaryDisable = false;
        if (var1_1 != false && this._autoCompactRemovesRemaining <= 0 && this._autoCompactionFactor != 0.0f) {
            this.compact();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void computeMaxSize(int capacity) {
        void var1_1;
        this._maxSize = Math.min(capacity - 1, (int)((float)capacity * this._loadFactor));
        this._free = var1_1 - this._size;
    }

    /*
     * WARNING - void declaration
     */
    protected void computeNextAutoCompactionAmount(int size) {
        if (this._autoCompactionFactor != 0.0f) {
            void var1_1;
            this._autoCompactRemovesRemaining = (int)((float)var1_1 * this._autoCompactionFactor + 0.5f);
        }
    }

    protected final void postInsertHook(boolean usedFreeSlot) {
        if (usedFreeSlot) {
            --this._free;
        }
        if (++this._size > this._maxSize || this._free == 0) {
            int n2 = this._size > this._maxSize ? PrimeFinder.nextPrime(this.capacity() << 1) : this.capacity();
            this.rehash(n2);
            THash tHash = this;
            tHash.computeMaxSize(tHash.capacity());
        }
    }

    protected int calculateGrownCapacity() {
        return this.capacity() << 1;
    }
}

