/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.axis;

import com.macrofocus.common.interval.BoundedInterval;
import com.macrofocus.common.interval.MutableBoundedInterval;
import com.macrofocus.common.interval.SimpleBoundedInterval;
import com.macrofocus.common.interval.TransformBoundedInterval;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.common.scale.NumericTransform;
import com.macrofocus.common.scale.Transform;
import com.macrofocus.common.selection.Selection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.filter.MutableFilter;
import com.macrofocus.high_d.axis.AbstractAxisModel;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.DataFrameEvent;
import com.macrofocus.molap.dataframe.DataFrameHelper;
import com.macrofocus.molap.dataframe.DataFrameListener;
import com.macrofocus.molap.series.Series;
import com.macrofocus.molap.subset.OrdinalDimension;
import com.macrofocus.molap.subset.SubsetDataFrame;
import java.util.Iterator;

public class DefaultAxisModel<Row, C>
extends AbstractAxisModel<Row, C> {
    protected final DataFrame<Row, C, ?> dataFrame;
    protected final C column;
    protected final Series[] series;
    protected final OrdinalDimension dimension;
    private final SingleSelection<Row> probing;
    private final Selection<Row> selection;
    private final MutableFilter<Row> filter;
    private MutableBoundedInterval interval = null;
    private MutableBoundedInterval scaledInterval = null;
    private final MutableProperty<Boolean> buttonModel = new SimpleProperty((Object)Boolean.FALSE);
    protected double min = Double.MAX_VALUE;
    protected double max = -1.7976931348623157E308;
    private double mean;
    private double stdDev;
    private MutableProperty<Integer> binCount = new SimpleProperty((Object)0);
    private MutableProperty<AxisModel.BinType> binType = new SimpleProperty((Object)AxisModel.BinType.Fixed);
    private MutableProperty<Transform> scale = new SimpleProperty((Object)NumericTransform.IDENTITY);
    private DataFrameListener<Row, C> dataFrameListener$44db662f = new DataFrameListener<Row, C>(this){
        private /* synthetic */ DefaultAxisModel this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        public final void dataFrameChanged(DataFrameEvent<Row, C> event) {
            this.this$0.fireAxisChanged();
        }
    };

    /*
     * WARNING - void declaration
     */
    public DefaultAxisModel(DataFrame<Row, C, ?> dataFrame, DataFrame<?, C, ?> annotationDataFrame, SubsetDataFrame<Row, C, ?> subsetDataFrame, C column, SingleSelection<Row> probing, Selection<Row> selection, MutableFilter<Row> filter) {
        void var2_3;
        Iterator iterator;
        this.dataFrame = dataFrame;
        this.column = column;
        this.dimension = subsetDataFrame != null ? subsetDataFrame.getOrdinalDimension(column) : null;
        this.series = new Series[2];
        this.series[0] = dataFrame.getColumn(column);
        this.series[1] = annotationDataFrame != null ? annotationDataFrame.getColumn(column) : null;
        dataFrame.addWeakDataFrameListener(this.dataFrameListener$44db662f);
        assert (this.series[0] != null) : "Column " + String.valueOf(column) + " could not be found";
        assert (annotationDataFrame == null || this.series[1] != null) : "Annotated column " + String.valueOf(column) + " could not be found";
        this.probing = probing;
        this.selection = selection;
        this.filter = filter;
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        double sum = 0.0;
        int count = 0;
        double uncorrectedSumOfSquares = 0.0;
        for (Object r : iterator.rows()) {
            double d;
            void var3_4;
            Number value = this.getValue(r);
            if (value == null) continue;
            double v = var3_4.doubleValue();
            if (d < min) {
                min = v;
            }
            if (v > max) {
                max = v;
            }
            sum += v;
            double d2 = v;
            uncorrectedSumOfSquares += d2 * d2;
            ++count;
        }
        this.min = min;
        this.max = max;
        this.mean = sum / (double)count;
        this.stdDev = Math.sqrt(uncorrectedSumOfSquares / (double)var2_3 - this.mean * this.mean);
        this.binCount.addPropertyListener((PropertyListener)new PropertyListener<Integer>(this){
            private /* synthetic */ DefaultAxisModel this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            public final void propertyChanged(PropertyEvent<Integer> event) {
                this.this$0.fireAxisChanged();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected MutableBoundedInterval createBoundedInterval() {
        void var1_1;
        SimpleBoundedInterval interval = new SimpleBoundedInterval(this.min, this.max - this.min, this.min, this.max);
        interval.setMinimumExtent(-(this.max - this.min));
        this.registerInterval((BoundedInterval)interval);
        return var1_1;
    }

    protected MutableBoundedInterval createScaledBoundedInterval() {
        TransformBoundedInterval transformBoundedInterval = new TransformBoundedInterval(this.getInterval(), this.scale);
        return transformBoundedInterval;
    }

    @Override
    public MutableProperty<Boolean> getButtonModel() {
        return this.buttonModel;
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public String getName() {
        return this.dataFrame.getColumnName(this.column);
    }

    @Override
    public Class getType() {
        return this.dataFrame.getColumnClass(this.column);
    }

    @Override
    public C getColumn() {
        return this.column;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.dataFrame.rows().iterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Number getValue(Row row) {
        void var1_1;
        return (Number)this.series[0].get((Object)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Number getValue(int layer, Row row) {
        Series s = this.series[layer];
        if (s != null) {
            void var2_3;
            void var1_2;
            return (Number)var1_2.get((Object)var2_3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Number getScaledValue(int layer, Row row) {
        void var2_3;
        Number value = this.getValue(layer, var2_3);
        if (value != null) {
            void var1_2;
            if (this.scale.getValue() != null) {
                return (Number)((Transform)this.scale.getValue()).getTransform().apply(value.doubleValue());
            }
            return var1_2;
        }
        return null;
    }

    @Override
    public String getFormattedMinimum() {
        DefaultAxisModel defaultAxisModel = this;
        return defaultAxisModel.getFormattedValue(defaultAxisModel.getMinimum());
    }

    @Override
    public String getFormattedMaximum() {
        DefaultAxisModel defaultAxisModel = this;
        return defaultAxisModel.getFormattedValue(defaultAxisModel.getMaximum());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedValue(Row row) {
        void var1_1;
        return this.getFormattedValue(0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedValue(int layer, Row row) {
        void var2_3;
        Object value = this.series[layer].get((Object)var2_3);
        if (value != null) {
            void var1_2;
            if (value instanceof Number) {
                if (this.getFormat() != null) {
                    return this.getFormat().formatHtml(value, true);
                }
                return value.toString();
            }
            return var1_2.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getFormattedValue(double value) {
        void var1_1;
        if (this.getFormat() != null) {
            return this.getFormat().formatHtml((Object)value, true);
        }
        return Double.toString((double)var1_1);
    }

    @Override
    public Object getOriginalFloorValue(double value) {
        return value;
    }

    @Override
    public Object getOriginalCeilValue(double value) {
        return value;
    }

    @Override
    public double getMinimum() {
        this.getInterval();
        return this.min;
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getStdDev() {
        return this.stdDev;
    }

    @Override
    public double getMaximum() {
        this.getScaledInterval();
        return this.max;
    }

    @Override
    public boolean isDegenerate() {
        this.getInterval();
        return this.max == this.min;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMinimum(double min) {
        if (this.min != min) {
            void var1_1;
            this.min = min;
            this.getInterval().setMinMax(min, this.max);
            this.getInterval().setMinimumExtent(-(this.max - var1_1));
            this.fireAxisChanged();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMaximum(double max) {
        if (this.max != max) {
            void var1_1;
            this.max = max;
            this.getInterval().setMinMax(this.min, max);
            this.getInterval().setMinimumExtent((double)(-(var1_1 - this.min)));
            this.fireAxisChanged();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setMinMax(double min, double max) {
        if (this.max != max || this.min != min) {
            void var1_1;
            void var3_2;
            this.min = min;
            this.max = max;
            this.getInterval().setMinMax(min, max);
            this.getInterval().setMinimumExtent(max >= min ? 0.0 : max - min);
            this.getInterval().setMaximumExtent(max >= min ? var3_2 - var1_1 : 0.0);
            this.fireAxisChanged();
        }
    }

    @Override
    public DataFrameHelper.ColumnStatistics getColumnStatistics() {
        return DataFrameHelper.getColumnStatistics(this.dataFrame, this.column);
    }

    @Override
    public int getRowCount() {
        return this.dataFrame.getRowCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Row getRow(int row) {
        void var1_1;
        return (Row)this.dataFrame.getRowKey((int)var1_1);
    }

    @Override
    public MutableBoundedInterval getInterval() {
        if (this.interval == null) {
            this.interval = this.createBoundedInterval();
            DefaultAxisModel defaultAxisModel = this;
            defaultAxisModel.addIntervalListener((BoundedInterval)defaultAxisModel.interval);
        }
        return this.interval;
    }

    @Override
    public MutableBoundedInterval getScaledInterval() {
        if (this.scaledInterval == null) {
            this.scaledInterval = this.createScaledBoundedInterval();
            DefaultAxisModel defaultAxisModel = this;
            defaultAxisModel.addIntervalListener((BoundedInterval)defaultAxisModel.scaledInterval);
        }
        return this.scaledInterval;
    }

    @Override
    public SingleSelection<Row> getProbing() {
        return this.probing;
    }

    @Override
    public Selection<Row> getSelection() {
        return this.selection;
    }

    @Override
    public MutableFilter<Row> getFilter() {
        return this.filter;
    }

    @Override
    public OrdinalDimension getDimension() {
        return this.dimension;
    }

    @Override
    public MutableProperty<Integer> getBinCount() {
        return this.binCount;
    }

    @Override
    public MutableProperty<Transform> getScale() {
        return this.scale;
    }

    @Override
    public MutableProperty<AxisModel.BinType> getBinType() {
        return this.binType;
    }

    public String toString() {
        return this.getName();
    }
}

