/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.mds.swing;

import com.macrofocus.high_d.mds.MDSPanel;
import com.macrofocus.high_d.mds.MDSScatterPlotModel;
import com.macrofocus.high_d.mds.swing.SwingMDS;
import com.macrofocus.high_d.scatterplot.ScatterPlotListener;
import com.macrofocus.high_d.scatterplot.swing.SwingScatterPlotView;
import com.macrofocus.plot.AxisPlotPanel;
import com.macrofocus.plot.SwingAxisPlotPanel;
import com.macrofocus.plot.guide.AbstractSwingGuide;
import com.macrofocus.selection.swing.SingleSelectionComboBoxModel;
import com.macrofocus.slider.BoundedIntervalRangeSliderAdapter;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.SliderView;
import com.macrofocus.slider.swing.JRangeSlider;
import com.macrofocus.slider.swing.SimpleRangeSliderController;
import com.macrofocus.slider.swing.TrapezoidRangeSlider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SwingMDSPanel
extends JPanel
implements MDSPanel<JComponent> {
    private final SwingMDS mds;
    private final AxisPlotPanel<JComponent> axisPlotPanel;
    private final JButton startButton;
    private final JButton stopButton;
    private final JComboBox algorithmComboBox;
    private final ScatterPlotListener listener = new ScatterPlotListener(){

        public void scatterPlotChanged() {
            SwingMDSPanel.this.updateButtons();
        }
    };

    public SwingMDSPanel(final SwingMDS mds) {
        this.mds = mds;
        this.setLayout(new BorderLayout());
        SwingScatterPlotView view = (SwingScatterPlotView)mds.getView();
        this.axisPlotPanel = new SwingAxisPlotPanel(view.getXGuide(), view.getYGuide());
        ((AbstractSwingGuide)view.getXGuide()).setPanel(this.axisPlotPanel);
        ((AbstractSwingGuide)view.getYGuide()).setPanel(this.axisPlotPanel);
        this.add((Component)this.axisPlotPanel.getNativeComponent(), "Center");
        this.axisPlotPanel.addComponent((Object)mds.getNativeComponent());
        ((JComponent)this.axisPlotPanel.getLeftYAxisContainer()).setBackground(new Color(250, 250, 247));
        ((JComponent)this.axisPlotPanel.getBottomTimeAxisContainer()).setBackground(new Color(250, 250, 247));
        ((JComponent)this.axisPlotPanel.getLeftYAxisContainer()).setOpaque(false);
        ((JComponent)this.axisPlotPanel.getBottomTimeAxisContainer()).setOpaque(false);
        this.axisPlotPanel.setShowTopTimeAxis(true);
        this.axisPlotPanel.setTopAxisVisible(true);
        BoundedIntervalRangeSliderAdapter xSliderModel = new BoundedIntervalRangeSliderAdapter(view.getXRangeModel(), 0.0, 0.0);
        JRangeSlider xRangeSlider = new JRangeSlider((RangeSliderModel)xSliderModel, 0);
        TrapezoidRangeSlider xZoomTrapezoid = new TrapezoidRangeSlider(xRangeSlider);
        xZoomTrapezoid.setOpaque(true);
        JPanel xRange = new JPanel();
        xRange.setLayout(new BorderLayout());
        xRange.add((Component)xRangeSlider, "North");
        xZoomTrapezoid.setMinimumSize(new Dimension(12, 12));
        xRange.add((Component)xZoomTrapezoid, "South");
        new SimpleRangeSliderController((SliderView)xRangeSlider, true);
        this.axisPlotPanel.addTopTimeAxisComponent((Object)xRange);
        this.axisPlotPanel.setLeftAxisVisible(false);
        this.axisPlotPanel.setRightAxisVisible(true);
        this.axisPlotPanel.setShowLeftYAxis(false);
        this.axisPlotPanel.setBottomAxisVisible(false);
        this.axisPlotPanel.setShowBottomTimeAxis(false);
        BoundedIntervalRangeSliderAdapter ySliderModel = new BoundedIntervalRangeSliderAdapter(view.getYRangeModel(), 0.0, 0.0);
        JRangeSlider yRangeSlider = new JRangeSlider((RangeSliderModel)ySliderModel, 1);
        TrapezoidRangeSlider yZoomTrapezoid = new TrapezoidRangeSlider(yRangeSlider);
        yZoomTrapezoid.setOpaque(true);
        JPanel yRange = new JPanel();
        yRange.setLayout(new BorderLayout());
        yZoomTrapezoid.setMinimumSize(new Dimension(12, 12));
        yRange.add((Component)yZoomTrapezoid, "West");
        yRange.add((Component)yRangeSlider, "East");
        new SimpleRangeSliderController((SliderView)yRangeSlider, true);
        this.axisPlotPanel.addRightYAxisComponent((Object)yRange);
        JPanel control = new JPanel();
        control.setLayout(new FlowLayout(3, 0, 0));
        control.add(new JLabel("Algorithm: "));
        this.algorithmComboBox = new JComboBox();
        control.add(this.algorithmComboBox);
        this.startButton = new JButton(new AbstractAction("Start"){

            @Override
            public void actionPerformed(ActionEvent e) {
                mds.getModel().start();
            }
        });
        this.startButton.putClientProperty("JComponent.sizeVariant", "small");
        control.add(this.startButton);
        this.stopButton = new JButton(new AbstractAction("Stop"){

            @Override
            public void actionPerformed(ActionEvent e) {
                mds.getModel().stop();
            }
        });
        control.add(this.stopButton);
        this.add((Component)control, "South");
        this.setModel(mds.getModel());
    }

    public AxisPlotPanel getAxisPlotPanel() {
        return this.axisPlotPanel;
    }

    public void setModel(MDSScatterPlotModel model) {
        if (this.mds.getModel() != null) {
            this.mds.getModel().removeScatterPlotListener(this.listener);
        }
        if (model != null) {
            this.mds.getModel().addScatterPlotListener(this.listener);
        }
        this.algorithmComboBox.setModel(new SingleSelectionComboBoxModel(this.mds.getModel().getAlgorithm(), (Object[])MDSScatterPlotModel.Algorithm.values()));
        this.updateButtons();
    }

    private void updateButtons() {
        this.startButton.setEnabled(!this.mds.getModel().isRunning());
        this.stopButton.setEnabled(this.mds.getModel().isRunning());
        this.algorithmComboBox.setEnabled(!this.mds.getModel().isRunning());
        this.startButton.setVisible(this.startButton.isEnabled());
        this.stopButton.setVisible(this.stopButton.isEnabled());
    }

    public SwingMDS getMDS() {
        return this.mds;
    }

    public void setStyleClass(String ... styleClasses) {
    }

    public JComponent getNativeComponent() {
        return this;
    }
}

