/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates;

import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.swing.SwingParallelCoordinatesView;
import com.macrofocus.molap.dataframe.DataFrameHelper;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class ParallelCoordinatesPopupMenu<R, C>
extends JPopupMenu {
    public ParallelCoordinatesPopupMenu(final ParallelCoordinatesModel<?, ?, ?> model, final SwingParallelCoordinatesView<R, C> view) {
        AxisModel axisModel;
        AxisModel axisModel2;
        this.add(new AbstractAction("Hide"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (AxisModel axisModel : model.getSelectedAxis()) {
                    model.setHidden(axisModel, true);
                }
            }
        });
        this.add(new AbstractAction("Show all hidden"){

            @Override
            public void actionPerformed(ActionEvent e) {
                model.unhideAllAxis();
            }
        });
        this.add(new JSeparator());
        this.add(new AbstractAction("Invert"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (AxisModel axisModel : model.getSelectedAxis()) {
                    double min = axisModel.getMaximum();
                    double max = axisModel.getMinimum();
                    double start = axisModel.getInterval().getStart();
                    double end = axisModel.getInterval().getEnd();
                    axisModel.setMinimum(min);
                    axisModel.setMaximum(max);
                    axisModel.getInterval().setValue(end, start - end);
                }
            }
        });
        this.add(new AbstractAction("Show full range"){

            @Override
            public boolean isEnabled() {
                for (AxisModel axisModel : model.getSelectedAxis()) {
                    DataFrameHelper.ColumnStatistics statistics = axisModel.getColumnStatistics();
                    if ((!axisModel.isNumerical() || axisModel.getInterval().getMaximum() == statistics.getMax().doubleValue()) && axisModel.getInterval().getMinimum() == statistics.getMin().doubleValue()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                for (AxisModel axisModel : model.getSelectedAxis()) {
                    DataFrameHelper.ColumnStatistics statistics = axisModel.getColumnStatistics();
                    boolean fullRange = axisModel.getInterval().isFullRange();
                    axisModel.setMinimum(statistics.getMin().doubleValue());
                    axisModel.setMaximum(statistics.getMax().doubleValue());
                    if (!fullRange) continue;
                    axisModel.getInterval().setValue(axisModel.getMinimum(), axisModel.getMaximum() - axisModel.getMinimum());
                }
            }
        });
        this.add(new AbstractAction("Show only current range"){

            @Override
            public boolean isEnabled() {
                for (AxisModel axisModel : model.getSelectedAxis()) {
                    if (axisModel.getInterval().isFullRange()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                for (AxisModel axisModel : model.getSelectedAxis()) {
                    axisModel.setMinimum(axisModel.getInterval().getStart());
                    axisModel.setMaximum(axisModel.getInterval().getEnd());
                }
            }
        });
        this.add(new AbstractAction("Center on zero"){

            @Override
            public boolean isEnabled() {
                for (AxisModel axisModel : model.getSelectedAxis()) {
                    DataFrameHelper.ColumnStatistics statistics = axisModel.getColumnStatistics();
                    if (!axisModel.isNumerical() || !(statistics.getMin().doubleValue() < 0.0) || !(statistics.getMax().doubleValue() > 0.0)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                for (AxisModel axisModel : model.getSelectedAxis()) {
                    DataFrameHelper.ColumnStatistics statistics = axisModel.getColumnStatistics();
                    double max = Math.max(Math.abs(statistics.getMin().doubleValue()), Math.abs(statistics.getMax().doubleValue()));
                    boolean fullRange = axisModel.getInterval().isFullRange();
                    axisModel.setMinimum(-max);
                    axisModel.setMaximum(max);
                    if (!fullRange) continue;
                    axisModel.getInterval().setValue(axisModel.getMinimum(), axisModel.getMaximum() - axisModel.getMinimum());
                }
            }
        });
        this.add(new AbstractAction("Align on mean"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (AxisModel axisModel : model.getSelectedAxis()) {
                    DataFrameHelper.ColumnStatistics statistics = axisModel.getColumnStatistics();
                    double range = Math.max(statistics.getMean() - statistics.getMin().doubleValue(), statistics.getMax().doubleValue() - statistics.getMean());
                    double min = statistics.getMean() - range;
                    double max = statistics.getMean() + range;
                    boolean fullRange = axisModel.getInterval().isFullRange();
                    axisModel.setMinimum(min);
                    axisModel.setMaximum(max);
                    if (!fullRange) continue;
                    axisModel.getInterval().setValue(axisModel.getMinimum(), axisModel.getMaximum() - axisModel.getMinimum());
                }
            }
        });
        this.add(new AbstractAction("Reset range"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (AxisModel axisModel : model.getSelectedAxis()) {
                    DataFrameHelper.ColumnStatistics statistics = axisModel.getColumnStatistics();
                    axisModel.setMinimum(statistics.getMin().doubleValue());
                    axisModel.setMaximum(statistics.getMax().doubleValue());
                    axisModel.getInterval().setValue(statistics.getMin().doubleValue(), statistics.getMax().doubleValue() - statistics.getMin().doubleValue());
                }
            }
        });
        this.add(new JSeparator());
        boolean aV = true;
        Iterator iterator = model.getSelectedAxis().iterator();
        while (iterator.hasNext() && (aV = ((JComponent)view.getAxisView(axisModel2 = (AxisModel)iterator.next()).getNativeComponent()).isVisible())) {
        }
        final boolean axisVisible = aV;
        boolean lV = true;
        Iterator iterator2 = model.getSelectedAxis().iterator();
        while (iterator2.hasNext() && (lV = view.getMaximumLabel(axisModel = (AxisModel)iterator2.next()).isVisible())) {
        }
        final boolean labelVisible = lV;
        this.add(new AbstractAction(axisVisible ? "Hide range slider" : "Show range slider"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (AxisModel axisModel : model.getSelectedAxis()) {
                    ((JComponent)view.getAxisView(axisModel).getNativeComponent()).setVisible(!axisVisible);
                }
            }
        });
        this.add(new AbstractAction(labelVisible ? "Hide labels" : "Show labels"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (AxisModel axisModel : model.getSelectedAxis()) {
                    view.getMinimumLabel(axisModel).setVisible(!labelVisible);
                    view.getMaximumLabel(axisModel).setVisible(!labelVisible);
                }
            }
        });
    }
}

