/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinates.swing;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.application.ApplicationModelFactory;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormap.swing.SwingColorMapFactory;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPComponent;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.AbstractSwingComponent;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.high_d.axis.Alignment;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.parallelcoordinates.AbstractParallelCoordinates;
import com.macrofocus.high_d.parallelcoordinates.DefaultParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinates;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesController;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesModel;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesView;
import com.macrofocus.high_d.parallelcoordinates.geometry.Geometry;
import com.macrofocus.high_d.parallelcoordinates.swing.SwingParallelCoordinatesController;
import com.macrofocus.high_d.parallelcoordinates.swing.SwingParallelCoordinatesView;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.colortheme.DarkColorTheme;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.java.CPDataFrameFactory;
import com.macrofocus.order.MutableVisibleOrder;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;

public class SwingParallelCoordinates<R, C>
extends AbstractParallelCoordinates<JComponent, Color, R, C> {
    private final JComponent nativeComponent = new JComponent(){};

    public SwingParallelCoordinates() {
        this.nativeComponent.setLayout(new OverlayLayout(this.nativeComponent));
        this.view = this.createView();
        this.view.setLicenseModel(licenseModel);
        this.controller = this.createController(this.view);
        this.setView(this.view);
    }

    public SwingParallelCoordinates(ParallelCoordinatesModel model) {
        this();
        this.setModel(model);
    }

    public SwingParallelCoordinates(DataFrame dataFrame) {
        this();
        this.load(dataFrame);
    }

    public void setStyleClass(String ... styleClasses) {
        AbstractSwingComponent.setStyleClass((CPComponent)this, (String[])styleClasses);
    }

    public void setView(ParallelCoordinatesView<JComponent, Color, R, C> view) {
        if (this.getView() != null) {
            this.nativeComponent.remove((Component)this.getView().getNativeComponent());
        }
        super.setView(view);
        if (this.getView() != null) {
            this.nativeComponent.add((Component)this.getView().getNativeComponent());
        }
        this.nativeComponent.revalidate();
    }

    protected ParallelCoordinatesModel<Color, R, C> createModel(DataFrame dataFrame) {
        return new DefaultParallelCoordinatesModel((ColorMapFactory)SwingColorMapFactory.getInstance(), (CPFactory)SwingFactory.getInstance(), dataFrame);
    }

    protected ParallelCoordinatesView<JComponent, Color, R, C> createView() {
        SwingParallelCoordinatesView view = new SwingParallelCoordinatesView();
        return view;
    }

    protected ParallelCoordinatesController createController(ParallelCoordinatesView view) {
        return new SwingParallelCoordinatesController(view);
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public static void main(String[] args) {
        SwingParallelCoordinates.setLicenseKey((String)"Macrofocus GmbH", (String)"3RCD9-DMQDM-AAEMV-LGN5S-76384-FE5WA");
        DataFrame dataFrame = CPDataFrameFactory.getInstance().createRandomDataFrame(3, 10000, 100);
        SwingParallelCoordinates parallelCoordinates = new SwingParallelCoordinates(dataFrame);
        MutableVisibleOrder axisOrder = ((AxisGroupModel)parallelCoordinates.getModel().getAxisHierarchy().getAxisGroupHierarchy().getRoot()).getAxisOrder();
        for (AxisModel axisModel : axisOrder.iterableAll()) {
            axisOrder.setVisible((Object)axisModel, true);
        }
        ParallelCoordinatesModel model = parallelCoordinates.getModel();
        parallelCoordinates.getView().getGeometry().setValue((Object)Geometry.Polycurves);
        parallelCoordinates.getView().getColorTheme().setValue((Object)new DarkColorTheme((CPColorFactory)SwingFactory.getInstance()));
        parallelCoordinates.getView().getRendering().setValue((Object)CPCanvas.Rendering.Density);
        parallelCoordinates.getView().setShowTiming(true);
        parallelCoordinates.getView().getAlignment().setValue((Object)Alignment.Center);
        SwingUtilities.invokeLater(new Runnable((ParallelCoordinates)parallelCoordinates){
            final /* synthetic */ ParallelCoordinates val$parallelCoordinates;
            {
                this.val$parallelCoordinates = parallelCoordinates;
            }

            @Override
            public void run() {
                ApplicationModel applicationModel = ApplicationModelFactory.HIGHD_API_V1;
                JFrame frame = new JFrame(applicationModel.getName() + " " + applicationModel.getVersion() + ", Copyright (c) " + applicationModel.getCopyright() + " " + applicationModel.getEdition());
                frame.setSize(800, 400);
                frame.setDefaultCloseOperation(3);
                JScrollPane scrollPane = new JScrollPane((Component)this.val$parallelCoordinates.getNativeComponent());
                frame.getContentPane().add(scrollPane);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }
}

