/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.parallelcoordinatesmatrix.swing;

import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.high_d.axis.AxisHeaderView;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.axis.CompactAxisHeaderView;
import com.macrofocus.high_d.axis.group.AxisGroupModel;
import com.macrofocus.high_d.axis.swing.SwingAxisGroupView;
import com.macrofocus.high_d.axis.swing.SwingAxisView;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinates;
import com.macrofocus.high_d.parallelcoordinates.ParallelCoordinatesView;
import com.macrofocus.high_d.parallelcoordinates.swing.PopupAxisController;
import com.macrofocus.high_d.parallelcoordinates.swing.SwingParallelCoordinates;
import com.macrofocus.high_d.parallelcoordinates.swing.SwingParallelCoordinatesView;
import com.macrofocus.high_d.parallelcoordinatesmatrix.AbstractParallelCoordinatesMatrixView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;

public class SwingParallelCoordinatesMatrixView<Row, Column>
extends AbstractParallelCoordinatesMatrixView<JComponent, Color, Row, Column> {
    private final JPanel nativeComponent = new ParallelCoordinatesMatrixPanel();

    public SwingParallelCoordinatesMatrixView() {
        this.nativeComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SwingParallelCoordinatesMatrixView.this.refresh();
            }
        });
        this.nativeComponent.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    SwingParallelCoordinatesMatrixView.this.refresh();
                }
            }
        });
        this.nativeComponent.setLayout(new OverlayLayout(this.nativeComponent));
        this.nativeComponent.add((Component)this.parallelCoordinates.getNativeComponent());
        this.nativeComponent.setOpaque(true);
        this.nativeComponent.updateUI();
    }

    protected ParallelCoordinates<JComponent, Color, Row, Column> createParallelCoordinates() {
        return new SwingParallelCoordinates(){

            protected ParallelCoordinatesView createView() {
                SwingParallelCoordinatesView view = new SwingParallelCoordinatesView(){

                    @Override
                    protected SwingAxisView createAxisView(AxisModel axisModel) {
                        SwingAxisView axisView = new SwingAxisView(axisModel){

                            public boolean isPaintHandles() {
                                return false;
                            }
                        };
                        axisView.setEnabled(false);
                        axisView.setVisible(false);
                        return axisView;
                    }

                    @Override
                    protected AxisHeaderView createAxisHeaderView(AxisModel axisModel) {
                        CompactAxisHeaderView label = new CompactAxisHeaderView(axisModel);
                        return label;
                    }

                    @Override
                    protected MouseListener createAxisMouseListener(JButton label) {
                        return null;
                    }

                    @Override
                    protected PopupAxisController createAxisController(JButton label, SwingAxisView axisView) {
                        return null;
                    }

                    protected SwingAxisGroupView createAxisGroupView(AxisGroupModel axisGroup) {
                        return null;
                    }

                    @Override
                    protected SwingAxisView createDummyAxisView() {
                        return new SwingAxisView(){

                            public int getBeforeTrackGap() {
                                return 0;
                            }

                            public int getAfterTrackGap() {
                                return 0;
                            }
                        };
                    }
                };
                return view;
            }
        };
    }

    public Object getClosestRow(int x, int y) {
        Rectangle b = ((JComponent)this.parallelCoordinates.getNativeComponent()).getBounds();
        if (b.contains(x, y)) {
            return this.parallelCoordinates.getView().getClosestRow(x - b.x, y - b.y);
        }
        return null;
    }

    protected void refresh() {
        if (this.nativeComponent.isShowing()) {
            this.updateParallelCoordinatesModel();
        }
    }

    protected void updateParallelCoordinatesModel() {
        super.updateParallelCoordinatesModel();
        this.nativeComponent.revalidate();
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    protected CPFactory<JComponent, ?, ?, Color> getFactory() {
        return SwingFactory.getInstance();
    }

    private class ParallelCoordinatesMatrixPanel
    extends JPanel {
        private ParallelCoordinatesMatrixPanel() {
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = ((JComponent)SwingParallelCoordinatesMatrixView.this.parallelCoordinates.getView().getNativeComponent()).getPreferredSize();
            return new Dimension(preferredSize.width / 2, SwingParallelCoordinatesMatrixView.getRowCount((int)SwingParallelCoordinatesMatrixView.this.model.getAxisGroupModel().getAxisOrder().size()) * 40);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
    }
}

