/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplot.swing;

import com.macrofocus.helper.SwingHelper;
import com.macrofocus.high_d.scatterplot.ScatterPlotController;
import com.macrofocus.high_d.scatterplot.ScatterPlotView;
import com.macrofocus.utils.SwingUtils;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class SwingScatterPlotController<Row, Column>
implements ScatterPlotController<JComponent, Row, Column> {
    private ScatterPlotView<JComponent, ?, Font, Row, Column> view;
    private Mode mode = Mode.Selection;
    private final DefaultMouseListener mouseListener = new DefaultMouseListener();
    private final boolean multipleSelectionEnabled = true;
    private final boolean selectOnPopupTrigger = false;
    private boolean improvedBorderZooming = false;
    private final KeyListener keyListener = new KeyAdapter(){
        Mode oldMode;

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 83) {
                if (this.oldMode == null) {
                    this.oldMode = SwingScatterPlotController.this.mode;
                }
                SwingScatterPlotController.this.mode = Mode.Selection;
            }
            if (e.getKeyCode() == 90 || e.getKeyCode() == 16) {
                if (this.oldMode == null) {
                    this.oldMode = SwingScatterPlotController.this.mode;
                }
                SwingScatterPlotController.this.mode = Mode.Zooming;
            }
            if (e.getKeyCode() == 80 || e.getKeyCode() == 32) {
                if (this.oldMode == null) {
                    this.oldMode = SwingScatterPlotController.this.mode;
                }
                SwingScatterPlotController.this.mode = Mode.Panning;
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this.oldMode != null) {
                SwingScatterPlotController.this.mode = this.oldMode;
                this.oldMode = null;
            }
        }
    };

    public SwingScatterPlotController(ScatterPlotView view) {
        this.setView(view);
    }

    public void setView(ScatterPlotView<JComponent, ?, Font, Row, Column> view) {
        if (this.view != null) {
            ((JComponent)this.view.getNativeComponent()).removeKeyListener(this.keyListener);
            ((JComponent)this.view.getNativeComponent()).removeMouseListener(this.mouseListener);
            ((JComponent)this.view.getNativeComponent()).removeMouseMotionListener(this.mouseListener);
            ((JComponent)this.view.getNativeComponent()).removeMouseWheelListener(this.mouseListener);
        }
        this.view = view;
        if (view != null) {
            ((JComponent)view.getNativeComponent()).setFocusable(true);
            ((JComponent)view.getNativeComponent()).addKeyListener(this.keyListener);
            ((JComponent)view.getNativeComponent()).addMouseListener(this.mouseListener);
            ((JComponent)view.getNativeComponent()).addMouseMotionListener(this.mouseListener);
            ((JComponent)view.getNativeComponent()).addMouseWheelListener(this.mouseListener);
        }
    }

    private void zoom(double amount, Double xCenter, Double yCenter) {
        Rectangle2D viewport = this.getViewport();
        Rectangle2D world = this.getWorld();
        Range xRange = new Range(amount, xCenter, viewport.getMinX(), viewport.getWidth(), world.getMinX(), world.getMaxX(), this.view.getXRangeModel().getMaximumExtent()).invoke();
        double xMin = xRange.getMin();
        double xMax = xRange.getMax();
        Range yRange = new Range(amount, yCenter, viewport.getMinY(), viewport.getHeight(), world.getMinY(), world.getMaxY(), this.view.getYRangeModel().getMaximumExtent()).invoke();
        double yMin = yRange.getMin();
        double yMax = yRange.getMax();
        if (xMin < xMax && yMin < yMax) {
            this.view.zoom(false, xMin, xMax, yMin, yMax);
        }
    }

    public Rectangle2D getViewport() {
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setFrameFromDiagonal(this.view.getXRangeModel().getStart(), this.view.getYRangeModel().getStart(), this.view.getXRangeModel().getStart() + this.view.getXRangeModel().getExtent(), this.view.getYRangeModel().getStart() + this.view.getYRangeModel().getExtent());
        return r;
    }

    public Rectangle2D getWorld() {
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setFrameFromDiagonal(this.view.getXRangeModel().getMinimum(), this.view.getYRangeModel().getMinimum(), this.view.getXRangeModel().getMaximum(), this.view.getYRangeModel().getMaximum());
        return r;
    }

    public static enum Mode {
        Selection,
        Zooming,
        Panning;

    }

    private class DefaultMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private Point last;
        private Object selectOnRelease = null;
        private Point zoomOnRelease = null;
        private Point zoomingPoint = null;
        private Point pressedPoint = null;

        private DefaultMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent event) {
            if (SwingScatterPlotController.this.view != null) {
                ((JComponent)SwingScatterPlotController.this.view.getNativeComponent()).requestFocusInWindow();
                if (SwingScatterPlotController.this.view.getModel() != null) {
                    Point point = event.getPoint();
                    SwingScatterPlotController.this.view.getModel().getProbing().setSelected(SwingScatterPlotController.this.view.getClosestRow(point.x, point.y));
                }
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (SwingScatterPlotController.this.view != null && SwingScatterPlotController.this.view.getModel() != null) {
                SwingScatterPlotController.this.view.getModel().getProbing().clearSelection();
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (SwingScatterPlotController.this.view != null) {
                this.pressedPoint = event.getPoint();
                ((JComponent)SwingScatterPlotController.this.view.getNativeComponent()).requestFocus();
                Object bestrow = SwingScatterPlotController.this.view.getClosestRow(event.getX(), event.getY());
                if (bestrow != null) {
                    if (!SwingHelper.isMultipleSelectionKey((InputEvent)event)) {
                        if (!SwingScatterPlotController.this.view.getModel().getSelection().isSelected(bestrow) || SwingScatterPlotController.this.view.getModel().getSelection().getSelectedCount() > 1) {
                            SwingScatterPlotController.this.view.getModel().getSelection().clearSelection();
                            SwingScatterPlotController.this.view.getModel().getSelection().setSelected(bestrow);
                            SwingScatterPlotController.this.view.setSelectionMode(SwingScatterPlotController.this.view.getModel().getSelection().isSelected(bestrow));
                        }
                    } else {
                        SwingScatterPlotController.this.view.setSelectionMode(!SwingScatterPlotController.this.view.getModel().getSelection().isSelected(bestrow));
                        if (SwingScatterPlotController.this.view.isSelectionMode()) {
                            SwingScatterPlotController.this.view.getModel().getSelection().setSelectedState(bestrow, true);
                        } else {
                            SwingScatterPlotController.this.view.getModel().getSelection().setSelectedState(bestrow, false);
                        }
                    }
                } else {
                    SwingScatterPlotController.this.view.getModel().getSelection().clearSelection();
                }
            }
        }

        private void removeFromSelection(Object observation) {
            SwingScatterPlotController.this.view.getModel().getSelection().setSelectedState(observation, false);
        }

        private void setSelection(Object observation) {
            if (observation != null) {
                SwingScatterPlotController.this.view.getModel().getSelection().setSelectedElements(new Object[]{observation});
            } else {
                SwingScatterPlotController.this.view.getModel().getSelection().clearSelection();
            }
        }

        private void addToSelection(Object observation) {
            SwingScatterPlotController.this.view.getModel().getSelection().setSelectedState(observation, true);
        }

        private void addToSelection(List<Object> newSelection) {
            SwingScatterPlotController.this.view.getModel().getSelection().setSelectedIterableState(newSelection, true);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (SwingScatterPlotController.this.view != null) {
                if (!event.isPopupTrigger()) {
                    if (this.selectOnRelease != null && SwingUtilities.isLeftMouseButton(event)) {
                        SwingScatterPlotController.this.view.getModel().getSelection().clearSelection();
                        this.addToSelection(this.selectOnRelease);
                        this.selectOnRelease = null;
                    }
                    if (this.zoomOnRelease != null) {
                        if (SwingUtilities.isLeftMouseButton(event)) {
                            // empty if block
                        }
                        this.zoomOnRelease = null;
                    }
                    SwingScatterPlotController.this.view.getRubberBand().stopRubberBand();
                }
                this.last = null;
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (SwingScatterPlotController.this.view != null && SwingScatterPlotController.this.view.getModel() != null) {
                Point point = event.getPoint();
                if (this.last != null) {
                    switch (SwingScatterPlotController.this.mode.ordinal()) {
                        case 0: {
                            boolean isAlreadySelected;
                            if (!SwingUtilities.isLeftMouseButton(event)) break;
                            if (event.isAltDown()) {
                                SwingScatterPlotController.this.view.getModel().getProbing().clearSelection();
                                if (!SwingScatterPlotController.this.view.getRubberBand().getRubberBand().isActive()) {
                                    SwingScatterPlotController.this.view.getRubberBand().startRubberBand(this.pressedPoint.x, this.pressedPoint.y);
                                }
                                SwingScatterPlotController.this.view.getRubberBand().stretchRubberBand(event.getPoint().x, event.getPoint().y);
                                com.macrofocus.geom.Rectangle2D rect = SwingScatterPlotController.this.view.getRubberBand().getRubberBandScreen();
                                if (rect == null) break;
                                List toSelect = SwingScatterPlotController.this.view.getRows(rect);
                                if (SwingHelper.isMultipleSelectionKey((InputEvent)event)) {
                                    this.addToSelection((Object)toSelect);
                                } else {
                                    SwingScatterPlotController.this.view.getModel().getSelection().setSelectedIterable((Iterable)toSelect);
                                }
                                this.selectOnRelease = null;
                                break;
                            }
                            Object observation = SwingScatterPlotController.this.view.getClosestRow(point.x, point.y);
                            SwingScatterPlotController.this.view.getModel().getProbing().setSelected(observation);
                            this.selectOnRelease = null;
                            boolean bl = isAlreadySelected = SwingScatterPlotController.this.view.getModel().getSelection() != null && SwingScatterPlotController.this.view.getModel().getSelection().isSelected(observation);
                            if (!isAlreadySelected && !SwingUtils.isMenuShortcutKeyDown((InputEvent)event)) {
                                SwingScatterPlotController.this.view.getModel().getSelection().clearSelection();
                            }
                            if (SwingUtils.isMenuShortcutKeyDown((InputEvent)event)) {
                                this.addToSelection(observation);
                                break;
                            }
                            if (isAlreadySelected) {
                                this.selectOnRelease = observation;
                                break;
                            }
                            this.addToSelection(observation);
                            break;
                        }
                        case 2: {
                            if (!SwingUtilities.isLeftMouseButton(event)) break;
                            Rectangle2D viewport = SwingScatterPlotController.this.getViewport();
                            Rectangle2D world = SwingScatterPlotController.this.getWorld();
                            double x1 = SwingScatterPlotController.this.view.getScreenTransform().getX().screenToWorld(this.last.x);
                            double x2 = SwingScatterPlotController.this.view.getScreenTransform().getX().screenToWorld(event.getPoint().x);
                            double worldDiffX = x1 - x2;
                            double xMin = viewport.getMinX() + worldDiffX;
                            double xMax = viewport.getMaxX() + worldDiffX;
                            double y1 = SwingScatterPlotController.this.view.getScreenTransform().getY().screenToWorld(this.last.y);
                            double y2 = SwingScatterPlotController.this.view.getScreenTransform().getY().screenToWorld(event.getPoint().y);
                            double worldDiffY = y1 - y2;
                            double yMin = viewport.getMinY() + worldDiffY;
                            double yMax = viewport.getMaxY() + worldDiffY;
                            if (xMin < world.getMinX()) {
                                xMax += world.getMinX() - xMin;
                                xMin = world.getMinX();
                            }
                            if (xMax > world.getMaxX()) {
                                xMin -= xMax - world.getMaxX();
                                xMax = world.getMaxX();
                            }
                            xMin = Math.max(world.getMinX(), xMin);
                            xMax = Math.min(world.getMaxX(), xMax);
                            if (yMin < world.getMinY()) {
                                yMax += world.getMinY() - yMin;
                                yMin = world.getMinY();
                            }
                            if (yMax > world.getMaxY()) {
                                yMin -= yMax - world.getMaxY();
                                yMax = world.getMaxY();
                            }
                            yMin = Math.max(world.getMinY(), yMin);
                            yMax = Math.min(world.getMaxY(), yMax);
                            if (!(xMin < xMax) || !(yMin < yMax)) break;
                            SwingScatterPlotController.this.view.zoom(false, xMin, xMax, yMin, yMax);
                            break;
                        }
                        case 1: {
                            if (!SwingUtilities.isMiddleMouseButton(event)) break;
                            Point p = event.getPoint();
                            SwingScatterPlotController.this.zoom(event.getPoint().getY() - this.last.getY() / 100.0, SwingScatterPlotController.this.view.getScreenTransform().getX().screenToWorld(p.x), SwingScatterPlotController.this.view.getScreenTransform().getY().screenToWorld(p.y));
                            this.zoomOnRelease = null;
                        }
                    }
                }
                this.last = event.getPoint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            Object closest = SwingScatterPlotController.this.view.getClosestRow(event.getX(), event.getY());
            SwingScatterPlotController.this.view.getModel().getProbing().setSelected(closest);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            if (SwingScatterPlotController.this.view != null) {
                int amount = event.getWheelRotation();
                Point p = event.getPoint();
                SwingScatterPlotController.this.zoom((double)amount / 20.0, SwingScatterPlotController.this.view.getScreenTransform().getX().screenToWorld(p.x), SwingScatterPlotController.this.view.getScreenTransform().getY().screenToWorld(p.y));
            }
        }
    }

    private class Range {
        private final double _amount;
        private final Double _center;
        private final double _start;
        private final double _extent;
        private final double _minRange;
        private final double _maxRange;
        private double _min;
        private double _max;
        private final double _maxExtent;

        public Range(double amount, Double center, double start, double extent, double minRange, double maxRange, double maxExtent) {
            this._amount = amount;
            this._center = center;
            this._start = start;
            this._extent = extent;
            this._minRange = minRange;
            this._maxRange = maxRange;
            this._maxExtent = maxExtent;
        }

        public double getMin() {
            return this._min;
        }

        public double getMax() {
            return this._max;
        }

        public Range invoke() {
            double range = this._extent;
            double newRange = Math.min(this._maxExtent, range + range * this._amount);
            if (this._center != null) {
                this._min = this._center - newRange * ((this._center - this._start) / range);
                this._max = this._center + newRange * ((this._start + this._extent - this._center) / range);
            } else {
                this._min = this._start;
                this._max = this._start + newRange;
            }
            if (this._min < this._minRange) {
                this._max += this._minRange - this._min;
                this._min = this._minRange;
            }
            if (this._max > this._maxRange) {
                this._min -= this._max - this._maxRange;
                this._max = this._maxRange;
            }
            this._min = Math.max(this._minRange, this._min);
            this._max = Math.min(this._maxRange, this._max);
            return this;
        }
    }
}

