/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplot.swing;

import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.filters.swing.DropDownButton;
import com.macrofocus.high_d.scatterplot.ScatterPlot;
import com.macrofocus.high_d.scatterplot.ScatterPlotModel;
import com.macrofocus.high_d.scatterplot.ScatterPlotPanel;
import com.macrofocus.high_d.scatterplot.swing.AxisSelectionComboBoxModel;
import com.macrofocus.high_d.scatterplot.swing.SwingScatterPlotView;
import com.macrofocus.high_d.scatterplot.swing.WideComboBox;
import com.macrofocus.plot.AxisPlotPanel;
import com.macrofocus.plot.SwingAxisPlotPanel;
import com.macrofocus.plot.guide.AbstractSwingGuide;
import com.macrofocus.properties.swing.BooleanPropertyButtonModel;
import com.macrofocus.properties.swing.PropertySpinnerModel;
import com.macrofocus.slider.BoundedIntervalRangeSliderAdapter;
import com.macrofocus.slider.RangeSliderModel;
import com.macrofocus.slider.SliderView;
import com.macrofocus.slider.swing.JRangeSlider;
import com.macrofocus.slider.swing.SimpleRangeSliderController;
import com.macrofocus.slider.swing.TrapezoidRangeSlider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;

public class SwingScatterPlotPanel
extends JPanel
implements ScatterPlotPanel<JComponent> {
    private final ScatterPlot scatterPlot;
    private final AxisPlotPanel<JComponent> axisPlotPanel;
    private final WideComboBox xComboBox;
    private final WideComboBox yComboBox;
    private final WideComboBox sizeComboBox;
    private final JPanel yPanel;

    public SwingScatterPlotPanel(ScatterPlot<JComponent, Color, Font, ?, ?> scatterPlot) {
        this.scatterPlot = scatterPlot;
        this.setLayout(new BorderLayout());
        SwingScatterPlotView view = (SwingScatterPlotView)scatterPlot.getView();
        this.axisPlotPanel = new SwingAxisPlotPanel(view.getXGuide(), view.getYGuide());
        ((AbstractSwingGuide)view.getXGuide()).setPanel(this.axisPlotPanel);
        ((AbstractSwingGuide)view.getYGuide()).setPanel(this.axisPlotPanel);
        this.add((Component)this.axisPlotPanel.getNativeComponent(), "Center");
        this.axisPlotPanel.addComponent((Object)((JComponent)scatterPlot.getNativeComponent()));
        ((JComponent)this.axisPlotPanel.getLeftYAxisContainer()).setBackground(new Color(250, 250, 247));
        ((JComponent)this.axisPlotPanel.getBottomTimeAxisContainer()).setBackground(new Color(250, 250, 247));
        ((JComponent)this.axisPlotPanel.getLeftYAxisContainer()).setOpaque(false);
        ((JComponent)this.axisPlotPanel.getBottomTimeAxisContainer()).setOpaque(false);
        this.axisPlotPanel.setShowTopTimeAxis(true);
        this.axisPlotPanel.setTopAxisVisible(true);
        BoundedIntervalRangeSliderAdapter xSliderModel = new BoundedIntervalRangeSliderAdapter(scatterPlot.getView().getXRangeModel(), 0.0, 0.0);
        JRangeSlider xRangeSlider = new JRangeSlider((RangeSliderModel)xSliderModel, 0);
        TrapezoidRangeSlider xZoomTrapezoid = new TrapezoidRangeSlider(xRangeSlider);
        xZoomTrapezoid.setOpaque(true);
        JPanel xRange = new JPanel();
        xRange.setLayout(new BorderLayout());
        xRange.add((Component)xRangeSlider, "North");
        xZoomTrapezoid.setMinimumSize(new Dimension(12, 12));
        xRange.add((Component)xZoomTrapezoid, "South");
        new SimpleRangeSliderController((SliderView)xRangeSlider, true);
        this.axisPlotPanel.addTopTimeAxisComponent((Object)xRange);
        this.axisPlotPanel.setLeftAxisVisible(true);
        this.axisPlotPanel.setRightAxisVisible(true);
        this.axisPlotPanel.setShowLeftYAxis(true);
        BoundedIntervalRangeSliderAdapter ySliderModel = new BoundedIntervalRangeSliderAdapter(scatterPlot.getView().getYRangeModel(), 0.0, 0.0);
        JRangeSlider yRangeSlider = new JRangeSlider((RangeSliderModel)ySliderModel, 1);
        TrapezoidRangeSlider yZoomTrapezoid = new TrapezoidRangeSlider(yRangeSlider);
        yZoomTrapezoid.setOpaque(true);
        JPanel yRange = new JPanel();
        yRange.setLayout(new BorderLayout());
        yZoomTrapezoid.setMinimumSize(new Dimension(12, 12));
        yRange.add((Component)yZoomTrapezoid, "West");
        yRange.add((Component)yRangeSlider, "East");
        new SimpleRangeSliderController((SliderView)yRangeSlider, true);
        this.axisPlotPanel.addRightYAxisComponent((Object)yRange);
        JPanel xPanel = new JPanel();
        xPanel.setLayout(new BoxLayout(xPanel, 0));
        xPanel.add(new JLabel("Size: "));
        this.sizeComboBox = new WideComboBox(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(0, super.getPreferredSize().height);
            }
        };
        this.sizeComboBox.setRenderer(new AxisModelRenderer());
        xPanel.add(this.sizeComboBox);
        xPanel.add(Box.createHorizontalGlue());
        xPanel.add(new JLabel("X: "));
        this.xComboBox = new WideComboBox(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(0, super.getPreferredSize().height);
            }
        };
        this.xComboBox.setRenderer(new AxisModelRenderer());
        xPanel.add(this.xComboBox);
        this.yPanel = new JPanel();
        this.yPanel.setLayout(new BoxLayout(this.yPanel, 0));
        this.yPanel.add(new JLabel("Y: "));
        this.yComboBox = new WideComboBox(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(0, super.getPreferredSize().height);
            }
        };
        this.yComboBox.setRenderer(new AxisModelRenderer());
        this.yPanel.add(this.yComboBox);
        this.yPanel.add(Box.createHorizontalGlue());
        this.add((Component)xPanel, "South");
        this.add((Component)this.yPanel, "North");
        if (scatterPlot.getModel() != null) {
            this.setModel(scatterPlot.getModel());
        }
        DropDownButton dropDownButton = new DropDownButton();
        dropDownButton.setHideActionText(true);
        dropDownButton.setIconTextGap(0);
        dropDownButton.setMargin(new Insets(0, 0, 0, 0));
        JCheckBox showGrid = new JCheckBox("Show Grid");
        showGrid.setModel((ButtonModel)new BooleanPropertyButtonModel(scatterPlot.getView().getShowGrid()));
        dropDownButton.getPopupMenu().add(showGrid);
        JCheckBox regression = new JCheckBox("Fitted Regression Line");
        regression.setModel((ButtonModel)new BooleanPropertyButtonModel(scatterPlot.getView().getRegression()));
        dropDownButton.getPopupMenu().add(regression);
        JPanel markerSizePanel = new JPanel();
        markerSizePanel.setLayout(new FlowLayout());
        markerSizePanel.add(new JLabel("Marker Size: "));
        JSpinner markerSize = new JSpinner((SpinnerModel)new PropertySpinnerModel(scatterPlot.getView().getMarkerSize(), (Number)1.0, (Number)0.0, (Number)100.0));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(markerSize);
        JFormattedTextField tf = editor.getTextField();
        tf.setColumns(2);
        markerSize.setEditor(editor);
        markerSizePanel.add(markerSize);
        dropDownButton.getPopupMenu().add(markerSizePanel);
        this.getYPanel().add((Component)dropDownButton);
    }

    public void setModel(ScatterPlotModel model) {
        this.scatterPlot.setModel(model);
        this.xComboBox.setModel(new AxisSelectionComboBoxModel((MutableSingleSelection<AxisModel>)this.scatterPlot.getModel().getX(), this.scatterPlot.getModel().getAxisGroupModel()));
        this.yComboBox.setModel(new AxisSelectionComboBoxModel((MutableSingleSelection<AxisModel>)this.scatterPlot.getModel().getY(), this.scatterPlot.getModel().getAxisGroupModel()));
        this.sizeComboBox.setModel(new AxisSelectionComboBoxModel((MutableSingleSelection<AxisModel>)this.scatterPlot.getModel().getSize(), this.scatterPlot.getModel().getAxisGroupModel(), true));
    }

    public AxisPlotPanel getAxisPlotPanel() {
        return this.axisPlotPanel;
    }

    public ScatterPlot getScatterPlot() {
        return this.scatterPlot;
    }

    public void setYPanelVisible(boolean b) {
        this.yPanel.setVisible(b);
    }

    public JPanel getYPanel() {
        return this.yPanel;
    }

    public void setStyleClass(String ... styleClasses) {
    }

    public JComponent getNativeComponent() {
        return this;
    }

    public class AxisModelRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            AxisModel column = (AxisModel)value;
            if (column != null) {
                return super.getListCellRendererComponent((JList<?>)list, column.getName(), index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent((JList<?>)list, "---", index, isSelected, cellHasFocus);
        }
    }
}

