/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.high_d.scatterplot.swing;

import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import com.macrofocus.crossplatform.CPCalendarFactory;
import com.macrofocus.crossplatform.CPCanvas;
import com.macrofocus.crossplatform.CPFactory;
import com.macrofocus.crossplatform.CPLocaleFactory;
import com.macrofocus.crossplatform.CPTimeZoneFactory;
import com.macrofocus.crossplatform.swing.SwingCalendarFactory;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.crossplatform.swing.SwingLocaleFactory;
import com.macrofocus.crossplatform.swing.SwingTimeZoneFactory;
import com.macrofocus.filter.FilterEvent;
import com.macrofocus.filter.FilterListener;
import com.macrofocus.format.FormatFactory;
import com.macrofocus.format.swing.SwingFormatFactory;
import com.macrofocus.geom.Point;
import com.macrofocus.geom.Point2D;
import com.macrofocus.helper.SwingHelper;
import com.macrofocus.high_d.axis.AxisModel;
import com.macrofocus.high_d.scatterplot.AbstractScatterPlotView;
import com.macrofocus.high_d.scatterplot.ScatterPlotModel;
import com.macrofocus.high_d.scatterplot.ScatterPlotView;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPFontFactory;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.IHeadless;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.swing.SwingIGraphics;
import com.macrofocus.igraphics.swing.SwingIHeadless;
import com.macrofocus.igraphics.swing.SwingITiming;
import com.macrofocus.labeling.EnhancedJLabel;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.plot.guide.DateAxis;
import com.macrofocus.plot.guide.Guide;
import com.macrofocus.plot.guide.NumberAxis;
import com.macrofocus.plot.guide.SwingXNumberOneDScreenTransformAxisGuide;
import com.macrofocus.plot.guide.SwingYNumberOneDScreenTransformAxisGuide;
import com.macrofocus.plot.guide.ValueAxis;
import com.macrofocus.transform.OneDScreenTransform;
import com.macrofocus.transform.RangesScreenTransformCoordinator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.Line2D;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;

public class SwingScatterPlotView<Row, C>
extends AbstractScatterPlotView<JComponent, Color, Font, Row, C> {
    private final JComponent nativeComponent;
    private SwingITiming timing = new SwingITiming("Paint");
    private boolean _showTiming = false;
    private final SwingITiming prepareTiming = new SwingITiming("Prepare");
    private final SwingITiming renderTiming = new SwingITiming("Render");
    private LicenseModel licenseModel;
    private JPanel unregisteredPanel;
    private ComponentAdapter unregisteredPanelListener;
    private double[] olsRegression;
    private final SingleSelectionListener<AxisModel<Row, C>> axisSelectionListener = new SingleSelectionListener<AxisModel<Row, C>>(){

        public void selectionChanged(SingleSelectionEvent<AxisModel<Row, C>> event) {
            SwingScatterPlotView.this.olsRegression = null;
        }
    };
    private final FilterListener<Row> filterListener = new FilterListener<Row>(){

        public void filterChanged(FilterEvent<Row> event) {
            SwingScatterPlotView.this.olsRegression = null;
            SwingScatterPlotView.this.timer.restart();
        }
    };

    protected void scheduleUpdate() {
        if (this.nativeComponent.isShowing()) {
            this.timer.restart();
            this.nativeComponent.repaint();
        }
    }

    protected void updateAxisType() {
        if (this.model.getX().isActive()) {
            if (((AxisModel)this.model.getX().getSelected()).getType() == Date.class) {
                this.xGuide.setAxis((ValueAxis)new DateAxis((CPFontFactory)SwingFactory.getInstance(), (IHeadless)new SwingIHeadless(), (FormatFactory)SwingFormatFactory.getInstance(), (CPTimeZoneFactory)SwingTimeZoneFactory.getInstance(), (CPLocaleFactory)SwingLocaleFactory.getInstance(), (CPCalendarFactory)SwingCalendarFactory.getInstance()));
            } else {
                this.xGuide.setAxis((ValueAxis)new NumberAxis((CPFontFactory)SwingFactory.getInstance(), (IHeadless)new SwingIHeadless(), (FormatFactory)SwingFormatFactory.getInstance()));
            }
        }
        if (this.model.getY().isActive()) {
            if (((AxisModel)this.model.getY().getSelected()).getType() == Date.class) {
                this.yGuide.setAxis((ValueAxis)new DateAxis((CPFontFactory)SwingFactory.getInstance(), (IHeadless)new SwingIHeadless(), (FormatFactory)SwingFormatFactory.getInstance(), (CPTimeZoneFactory)SwingTimeZoneFactory.getInstance(), (CPLocaleFactory)SwingLocaleFactory.getInstance(), (CPCalendarFactory)SwingCalendarFactory.getInstance()));
            } else {
                this.yGuide.setAxis((ValueAxis)new NumberAxis((CPFontFactory)SwingFactory.getInstance(), (IHeadless)new SwingIHeadless(), (FormatFactory)SwingFormatFactory.getInstance()));
            }
        }
    }

    public SwingScatterPlotView() {
        super((CPCanvas)SwingFactory.getInstance().createCanvas(), (CPFactory)SwingFactory.getInstance());
        this.nativeComponent = new JLayeredPane(){

            @Override
            public void printAll(Graphics g) {
                this.doLayout();
                super.printAll(g);
            }
        };
        this.nativeComponent.setLayout(new OverlayLayout(this.nativeComponent));
        this.nativeComponent.add((Component)this.canvas.getNativeComponent(), JLayeredPane.DEFAULT_LAYER);
        this.nativeComponent.add((Component)new ScatterPlotPanel(), JLayeredPane.MODAL_LAYER);
        this.nativeComponent.setOpaque(true);
        this.nativeComponent.updateUI();
        Dimension d = this.nativeComponent.getSize();
        this.xGuide = new SwingXNumberOneDScreenTransformAxisGuide(Guide.Type.Bottom, (OneDScreenTransform)this.screenTransform.getX());
        this.yGuide = new SwingYNumberOneDScreenTransformAxisGuide(Guide.Type.Left, (OneDScreenTransform)this.screenTransform.getY());
        this.nativeComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension d = SwingScatterPlotView.this.nativeComponent.getSize();
                SwingScatterPlotView.this.screenTransform.setScreenSize(d.width, d.height);
            }
        });
        this.nativeComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SwingScatterPlotView.this.scheduleUpdate();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                SwingScatterPlotView.this.scheduleUpdate();
            }
        });
        this.nativeComponent.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    SwingScatterPlotView.this.refresh();
                }
            }
        });
        this.properties.addPropertiesListener(new PropertiesListener(){

            public void propertyChanged(Object name, PropertyEvent event) {
                if (name == ScatterPlotView.PropertyType.ColorTheme) {
                    SwingScatterPlotView.this.nativeComponent.updateUI();
                    SwingScatterPlotView.this.nativeComponent.repaint();
                }
            }
        });
    }

    protected int getWidth() {
        return this.nativeComponent.getWidth();
    }

    protected int getHeight() {
        return this.nativeComponent.getHeight();
    }

    protected void repaint() {
        this.nativeComponent.repaint();
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    public void setModel(ScatterPlotModel model) {
        if (this.model != null) {
            if (this.model.getX() != null) {
                this.model.getX().removeSingleSelectionListener(this.axisSelectionListener);
            }
            if (this.model.getY() != null) {
                this.model.getY().removeSingleSelectionListener(this.axisSelectionListener);
            }
            this.model.getVisual().getFilter().removeFilterListener(this.filterListener);
        }
        this.model = model;
        this.createOverplots();
        if (this.model != null) {
            if (this.model.getX() != null) {
                MutableSingleSelection x = this.model.getX();
                x.addSingleSelectionListener(this.axisSelectionListener);
            }
            if (this.model.getY() != null) {
                MutableSingleSelection y = this.model.getY();
                y.addSingleSelectionListener(this.axisSelectionListener);
            }
            this.model.getVisual().getFilter().addFilterListener(this.filterListener);
        }
        super.setModel(model);
    }

    public void setLicenseModel(LicenseModel licenseModel) {
        if (this.unregisteredPanel != null) {
            this.nativeComponent.removeComponentListener(this.unregisteredPanelListener);
            this.nativeComponent.remove(this.unregisteredPanel);
            this.unregisteredPanel = null;
            this.unregisteredPanelListener = null;
        }
        if (licenseModel == null || licenseModel.verify() != LicenseModel.State.Valid) {
            EnhancedJLabel unregisteredLabel = new EnhancedJLabel();
            unregisteredLabel.setEffect(EnhancedLabel.Effect.Outline);
            String message = licenseModel == null ? "Unregistered version" : licenseModel.verify().toString();
            unregisteredLabel.setText(message);
            unregisteredLabel.setForeground(new Color(0, 0, 0, 63));
            unregisteredLabel.setBackground(new Color(255, 255, 255));
            unregisteredLabel.setEffectOpacity(0.2f);
            this.unregisteredPanel = new JPanel(){

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    super.paint(g2);
                }
            };
            this.unregisteredPanel.setOpaque(false);
            this.unregisteredPanel.setLayout(new OverlayLayout(this.unregisteredPanel));
            this.unregisteredPanel.add((Component)unregisteredLabel);
            unregisteredLabel.setFont(unregisteredLabel.getFont().deriveFont(1, 32.0f));
            this.nativeComponent.add(this.unregisteredPanel, JLayeredPane.MODAL_LAYER, 0);
            this.unregisteredPanelListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    SwingHelper.centerBottom((Container)SwingScatterPlotView.this.getNativeComponent(), (Component)SwingScatterPlotView.this.unregisteredPanel);
                }
            };
            this.nativeComponent.addComponentListener(this.unregisteredPanelListener);
        }
    }

    public boolean isShowTiming() {
        return this._showTiming;
    }

    public void setShowTiming(boolean showTiming) {
        this._showTiming = showTiming;
        this.nativeComponent.repaint();
    }

    public Guide getXGuide() {
        return this.xGuide;
    }

    public Guide getYGuide() {
        return this.yGuide;
    }

    protected void refresh() {
        if (this.nativeComponent.isShowing()) {
            this.prepareTiming.start();
            this.canvas.refresh();
            this.prepareTiming.end();
            this.nativeComponent.repaint();
        }
    }

    public void setMaintainAspectRatio(boolean maintainAspectRatio) {
        if (maintainAspectRatio && this.rangesScreenTransformCoordinator == null) {
            this.rangesScreenTransformCoordinator = new RangesScreenTransformCoordinator(this.getXRangeModel(), this.getYRangeModel());
        } else if (!maintainAspectRatio && this.rangesScreenTransformCoordinator != null) {
            this.rangesScreenTransformCoordinator.setRanges(null, null);
            this.rangesScreenTransformCoordinator = null;
        }
        this.screenTransform.setMaintainAspectRatio(maintainAspectRatio);
    }

    public boolean isMaintainAspectRatio() {
        return this.rangesScreenTransformCoordinator != null;
    }

    public MutableProperties getProperties() {
        return this.properties;
    }

    public double[] getOLSRegression() {
        if (this.olsRegression == null) {
            this.olsRegression = this.computeOLSRegression();
        }
        return this.olsRegression;
    }

    public double[] computeOLSRegression() {
        if (this.model.getXAxisModel() != null && this.model.getYAxisModel() != null) {
            int n = this.model.getVisual().getActive().getObjectCount();
            if (n < 2) {
                throw new IllegalArgumentException("Not enough data.");
            }
            double sumX = 0.0;
            double sumY = 0.0;
            double sumXX = 0.0;
            double sumXY = 0.0;
            for (Object row : this.model.getVisual().getVisible()) {
                Number v1 = this.model.getXAxisModel().getScaledValue(0, row);
                Number v2 = this.model.getYAxisModel().getScaledValue(0, row);
                if (v1 == null || v2 == null) continue;
                double x = v1.doubleValue();
                double y = v2.doubleValue();
                sumX += x;
                sumY += y;
                double xx = x * x;
                sumXX += xx;
                double xy = x * y;
                sumXY += xy;
            }
            double sxx = sumXX - sumX * sumX / (double)n;
            double sxy = sumXY - sumX * sumY / (double)n;
            double xbar = sumX / (double)n;
            double ybar = sumY / (double)n;
            double[] result = new double[2];
            result[1] = sxy / sxx;
            result[0] = ybar - result[1] * xbar;
            return result;
        }
        throw new IllegalArgumentException("Not enough data.");
    }

    private class ScatterPlotPanel
    extends JComponent {
        private ScatterPlotPanel() {
        }

        @Override
        protected void printComponent(Graphics g) {
            super.printComponent(g);
        }

        @Override
        public void paintComponent(Graphics g) {
            Color color;
            Object antialias;
            Graphics2D g2;
            SwingScatterPlotView.this.timing.start();
            if (this.isPaintingForPrint()) {
                SwingScatterPlotView.this.canvas.refresh();
                SwingScatterPlotView.this.canvas.repaint();
            }
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, (antialias = (g2 = (Graphics2D)g).getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING)) != null ? antialias : RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
            super.paintComponent(g);
            SwingScatterPlotView.this.timing.end();
            if (SwingScatterPlotView.this.isShowTiming()) {
                SwingScatterPlotView.this.timing.draw(g2, this.getSize(), 10);
            }
            SwingScatterPlotView.this.renderTiming.start();
            if (((Boolean)SwingScatterPlotView.this.getAntialiasing().getValue()).booleanValue()) {
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialias != null ? antialias : RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            }
            float thickness = ((Float)SwingScatterPlotView.this.getGridThickness().getValue()).floatValue();
            if (((Boolean)SwingScatterPlotView.this.getShowGrid().getValue()).booleanValue() && thickness > 0.0f && (color = (Color)((CPColor)SwingScatterPlotView.this.getShowColor().getValue()).getNativeColor()) != null) {
                Rectangle rect = this.getBounds();
                Graphics2D g3 = (Graphics2D)g2.create(rect.x, rect.y, rect.width, rect.height);
                g3.setStroke(new BasicStroke(thickness));
                g3.setColor(color);
                g3.setRenderingHints(g2.getRenderingHints());
                SwingScatterPlotView.this.getXGuide().drawGrid((IGraphics)new SwingIGraphics(g3), new Dimension(rect.width, rect.height));
                SwingScatterPlotView.this.getYGuide().drawGrid((IGraphics)new SwingIGraphics(g3), new Dimension(rect.width, rect.height));
                g3.dispose();
            }
            if (((Boolean)SwingScatterPlotView.this.getRegression().getValue()).booleanValue() && SwingScatterPlotView.this.model != null && SwingScatterPlotView.this.model.getVisual().getActive().getObjectCount() > 2 && SwingScatterPlotView.this.model.getXAxisModel() != null && SwingScatterPlotView.this.model.getYAxisModel() != null) {
                double[] regression = SwingScatterPlotView.this.getOLSRegression();
                double minX = SwingScatterPlotView.this.model.getXAxisModel().getMinimum();
                double maxX = SwingScatterPlotView.this.model.getXAxisModel().getMaximum();
                double intercept = regression[0];
                double slope = regression[1];
                Point2D.Double p1 = new Point2D.Double(minX, intercept + slope * minX);
                Point2D.Double p2 = new Point2D.Double(maxX, intercept + slope * maxX);
                g2.setColor(new Color(0, 0, 255, 100));
                Stroke oldStroke = g2.getStroke();
                g2.setStroke(new BasicStroke(2.0f));
                Point s1 = SwingScatterPlotView.this.screenTransform.worldToScreen((Point2D)p1);
                Point s2 = SwingScatterPlotView.this.screenTransform.worldToScreen((Point2D)p2);
                g2.draw(new Line2D.Double(s1.getX(), s1.getY(), s2.getX(), s2.getY()));
                g2.setStroke(oldStroke);
            }
            SwingScatterPlotView.this.renderTiming.end();
            if (SwingScatterPlotView.this.isShowTiming()) {
                SwingScatterPlotView.this.prepareTiming.draw((Graphics2D)g, this.getSize(), 40);
                SwingScatterPlotView.this.renderTiming.draw((Graphics2D)g, this.getSize(), 25);
            }
        }

        @Override
        public void updateUI() {
            this.setBackground(null);
            super.updateUI();
            ColorTheme colorTheme = (ColorTheme)SwingScatterPlotView.this.getColorTheme().getValue();
            if (colorTheme != null) {
                Color background = this.getBackground();
                if (background != null) {
                    colorTheme.setBackground(SwingFactory.getInstance().createRGBAColor(background.getRed(), background.getGreen(), background.getBlue(), background.getAlpha()));
                }
                this.setBackground((Color)colorTheme.getBackground().getNativeColor());
                this.setForeground((Color)colorTheme.getForeground().getNativeColor());
            }
        }
    }
}

